# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from qanswer_sdk.models.qn_a_pair_model import QnAPairModel
from typing import Optional, Set
from typing_extensions import Self

class AddQnARequest(BaseModel):
    """
    AddQnARequest
    """ # noqa: E501
    qna_pairs: List[QnAPairModel] = Field(description="List of Question and Answer pairs")
    username: StrictStr = Field(description="Username of the creator")
    dataset: StrictStr = Field(description="Name of the dataset")
    connector_id: StrictInt = Field(description="Connector ID")
    quota: StrictInt = Field(description="Quota of the user")
    __properties: ClassVar[List[str]] = ["qna_pairs", "username", "dataset", "connector_id", "quota"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddQnARequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in qna_pairs (list)
        _items = []
        if self.qna_pairs:
            for _item_qna_pairs in self.qna_pairs:
                if _item_qna_pairs:
                    _items.append(_item_qna_pairs.to_dict())
            _dict['qna_pairs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddQnARequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "qna_pairs": [QnAPairModel.from_dict(_item) for _item in obj["qna_pairs"]] if obj.get("qna_pairs") is not None else None,
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "connector_id": obj.get("connector_id"),
            "quota": obj.get("quota")
        })
        return _obj


