# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AiAssistantFilterDto(BaseModel):
    """
    AiAssistantFilterDto
    """ # noqa: E501
    search: Optional[StrictStr] = Field(default='The QA Company', description="Filter over the ai assistant dataset and display name")
    ai_assistant_id: Optional[StrictInt] = Field(default=None, description="Filter over the ai assistant id", alias="aiAssistantId")
    user_id: Optional[StrictInt] = Field(default=None, description="Filter over the user id", alias="userId")
    team_id: Optional[StrictInt] = Field(default=None, description="Filter over the team id", alias="teamId")
    organization_id: Optional[StrictInt] = Field(default=None, description="Filter over the organization id", alias="organizationId")
    owned: Optional[StrictBool] = None
    page: Optional[StrictInt] = None
    size: Optional[StrictInt] = None
    sort_by: Optional[StrictStr] = Field(default=None, alias="sortBy")
    sort_dir: Optional[StrictStr] = Field(default=None, alias="sortDir")
    __properties: ClassVar[List[str]] = ["search", "aiAssistantId", "userId", "teamId", "organizationId", "owned", "page", "size", "sortBy", "sortDir"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AiAssistantFilterDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AiAssistantFilterDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "search": obj.get("search") if obj.get("search") is not None else 'The QA Company',
            "aiAssistantId": obj.get("aiAssistantId"),
            "userId": obj.get("userId"),
            "teamId": obj.get("teamId"),
            "organizationId": obj.get("organizationId"),
            "owned": obj.get("owned"),
            "page": obj.get("page"),
            "size": obj.get("size"),
            "sortBy": obj.get("sortBy"),
            "sortDir": obj.get("sortDir")
        })
        return _obj


