# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.llm_dto import LlmDto
from typing import Optional, Set
from typing_extensions import Self

class ChatbotSettingDto(BaseModel):
    """
    ChatbotSettingDto
    """ # noqa: E501
    system_message: Optional[StrictStr] = Field(default=None, alias="systemMessage")
    agentic_chatbot_enabled: Optional[StrictBool] = Field(default=None, alias="agenticChatbotEnabled")
    enable_enhanced_context_length: Optional[StrictBool] = Field(default=None, alias="enableEnhancedContextLength")
    llm: Optional[LlmDto] = None
    __properties: ClassVar[List[str]] = ["systemMessage", "agenticChatbotEnabled", "enableEnhancedContextLength", "llm"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChatbotSettingDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of llm
        if self.llm:
            _dict['llm'] = self.llm.to_dict()
        # set to None if system_message (nullable) is None
        # and model_fields_set contains the field
        if self.system_message is None and "system_message" in self.model_fields_set:
            _dict['systemMessage'] = None

        # set to None if agentic_chatbot_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.agentic_chatbot_enabled is None and "agentic_chatbot_enabled" in self.model_fields_set:
            _dict['agenticChatbotEnabled'] = None

        # set to None if enable_enhanced_context_length (nullable) is None
        # and model_fields_set contains the field
        if self.enable_enhanced_context_length is None and "enable_enhanced_context_length" in self.model_fields_set:
            _dict['enableEnhancedContextLength'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChatbotSettingDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "systemMessage": obj.get("systemMessage"),
            "agenticChatbotEnabled": obj.get("agenticChatbotEnabled"),
            "enableEnhancedContextLength": obj.get("enableEnhancedContextLength"),
            "llm": LlmDto.from_dict(obj["llm"]) if obj.get("llm") is not None else None
        })
        return _obj


