# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ConnectorModel(BaseModel):
    """
    ConnectorModel
    """ # noqa: E501
    connector_id: StrictInt
    connector_name: StrictStr
    connector_type: StrictStr
    embedding_model: StrictStr
    number_of_files: StrictInt
    has_files_pending_upload: Optional[StrictBool] = None
    refresh_frequency: StrictStr
    last_refreshed: StrictStr
    next_refresh: StrictStr
    is_indexing: Optional[StrictBool] = None
    n_files_to_index: Optional[StrictInt] = None
    size_in_mb: Optional[Union[StrictFloat, StrictInt]] = None
    n_tokens: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["connector_id", "connector_name", "connector_type", "embedding_model", "number_of_files", "has_files_pending_upload", "refresh_frequency", "last_refreshed", "next_refresh", "is_indexing", "n_files_to_index", "size_in_mb", "n_tokens"]

    @field_validator('connector_type')
    def connector_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['document', 'audio', 'website', 'qna', 'pinecone', 'rdf', 'websearch', 'econsilium', 'econsilium_search_index', 'publication_office', 'onedrive', 'sharepoint', 'gdrive', 'onenote', 'imap']):
            raise ValueError("must be one of enum values ('document', 'audio', 'website', 'qna', 'pinecone', 'rdf', 'websearch', 'econsilium', 'econsilium_search_index', 'publication_office', 'onedrive', 'sharepoint', 'gdrive', 'onenote', 'imap')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConnectorModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConnectorModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "connector_id": obj.get("connector_id"),
            "connector_name": obj.get("connector_name"),
            "connector_type": obj.get("connector_type"),
            "embedding_model": obj.get("embedding_model"),
            "number_of_files": obj.get("number_of_files"),
            "has_files_pending_upload": obj.get("has_files_pending_upload"),
            "refresh_frequency": obj.get("refresh_frequency"),
            "last_refreshed": obj.get("last_refreshed"),
            "next_refresh": obj.get("next_refresh"),
            "is_indexing": obj.get("is_indexing"),
            "n_files_to_index": obj.get("n_files_to_index"),
            "size_in_mb": obj.get("size_in_mb"),
            "n_tokens": obj.get("n_tokens")
        })
        return _obj


