# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ContentItem(BaseModel):
    """
    ContentItem
    """ # noqa: E501
    content_item_type: StrictStr
    text: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    image_detail: Optional[StrictStr] = None
    audio_data: Optional[StrictStr] = None
    audio_format: Optional[StrictStr] = None
    file_id: Optional[StrictStr] = None
    file_data: Optional[StrictStr] = None
    file_name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["content_item_type", "text", "url", "image_detail", "audio_data", "audio_format", "file_id", "file_data", "file_name"]

    @field_validator('content_item_type')
    def content_item_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['text', 'image_url', 'file', 'input_audio']):
            raise ValueError("must be one of enum values ('text', 'image_url', 'file', 'input_audio')")
        return value

    @field_validator('image_detail')
    def image_detail_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['low', 'high', 'auto']):
            raise ValueError("must be one of enum values ('low', 'high', 'auto')")
        return value

    @field_validator('audio_format')
    def audio_format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['wav', 'mp3']):
            raise ValueError("must be one of enum values ('wav', 'mp3')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "content_item_type": obj.get("content_item_type"),
            "text": obj.get("text"),
            "url": obj.get("url"),
            "image_detail": obj.get("image_detail"),
            "audio_data": obj.get("audio_data"),
            "audio_format": obj.get("audio_format"),
            "file_id": obj.get("file_id"),
            "file_data": obj.get("file_data"),
            "file_name": obj.get("file_name")
        })
        return _obj


