# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class EmbedderCreateDto(BaseModel):
    """
    EmbedderCreateDto
    """ # noqa: E501
    modality: Optional[StrictStr] = None
    provider: Optional[StrictStr] = None
    endpoint_url: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    onpremise: Optional[StrictBool] = None
    sensitivity_label: Optional[StrictStr] = None
    api_version: Optional[StrictStr] = None
    aws_access_key_id: Optional[StrictStr] = None
    aws_secret_access_key: Optional[StrictStr] = None
    aws_region_name: Optional[StrictStr] = None
    batch_size: Optional[StrictInt] = None
    display_name: StrictStr
    engine: StrictStr
    api_key: Optional[StrictStr] = None
    name: StrictStr
    embedding_size: StrictInt
    context_window: StrictInt
    cost_input_per_million_token: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="costInputPerMillionToken")
    __properties: ClassVar[List[str]] = ["modality", "provider", "endpoint_url", "description", "onpremise", "sensitivity_label", "api_version", "aws_access_key_id", "aws_secret_access_key", "aws_region_name", "batch_size", "display_name", "engine", "api_key", "name", "embedding_size", "context_window", "costInputPerMillionToken"]

    @field_validator('modality')
    def modality_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['text', 'text-image']):
            raise ValueError("must be one of enum values ('text', 'text-image')")
        return value

    @field_validator('provider')
    def provider_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['openai', 'azure', 'bedrock']):
            raise ValueError("must be one of enum values ('openai', 'azure', 'bedrock')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmbedderCreateDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmbedderCreateDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "modality": obj.get("modality"),
            "provider": obj.get("provider"),
            "endpoint_url": obj.get("endpoint_url"),
            "description": obj.get("description"),
            "onpremise": obj.get("onpremise"),
            "sensitivity_label": obj.get("sensitivity_label"),
            "api_version": obj.get("api_version"),
            "aws_access_key_id": obj.get("aws_access_key_id"),
            "aws_secret_access_key": obj.get("aws_secret_access_key"),
            "aws_region_name": obj.get("aws_region_name"),
            "batch_size": obj.get("batch_size"),
            "display_name": obj.get("display_name"),
            "engine": obj.get("engine"),
            "api_key": obj.get("api_key"),
            "name": obj.get("name"),
            "embedding_size": obj.get("embedding_size"),
            "context_window": obj.get("context_window"),
            "costInputPerMillionToken": obj.get("costInputPerMillionToken")
        })
        return _obj


