# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from qanswer_sdk.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class LlmConsumption(BaseModel):
    """
    LlmConsumption
    """ # noqa: E501
    id: Optional[StrictInt] = None
    created: Optional[datetime] = None
    user: Optional[User] = None
    dataset: Optional[UserDataset] = None
    llm: Optional[Llm] = None
    input_tokens: Optional[StrictInt] = Field(default=None, alias="inputTokens")
    input_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="inputCost")
    output_tokens: Optional[StrictInt] = Field(default=None, alias="outputTokens")
    output_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="outputCost")
    usage_origin: Optional[StrictStr] = Field(default=None, alias="usageOrigin")
    __properties: ClassVar[List[str]] = ["id", "created", "user", "dataset", "llm", "inputTokens", "inputCost", "outputTokens", "outputCost", "usageOrigin"]

    @field_validator('usage_origin')
    def usage_origin_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['query-expansion', 'response-audit', 'title-generation', 'chat', 'sparql2text', 'guardrail', 'jailbreak', 'human-take-over', 'auto-es-filters-generation', 'question-suggestion', 'language-detection', 'advanced-classification', 'advanced-classification-v2', 'highlight', 'tool-choice', 'pdf-vision-conversion', 'map-reduce-map', 'map-reduce-reduce', 'shorten-instruction', 'openai-chat-completion', 'unknown']):
            raise ValueError("must be one of enum values ('query-expansion', 'response-audit', 'title-generation', 'chat', 'sparql2text', 'guardrail', 'jailbreak', 'human-take-over', 'auto-es-filters-generation', 'question-suggestion', 'language-detection', 'advanced-classification', 'advanced-classification-v2', 'highlight', 'tool-choice', 'pdf-vision-conversion', 'map-reduce-map', 'map-reduce-reduce', 'shorten-instruction', 'openai-chat-completion', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LlmConsumption from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dataset
        if self.dataset:
            _dict['dataset'] = self.dataset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of llm
        if self.llm:
            _dict['llm'] = self.llm.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LlmConsumption from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created": obj.get("created"),
            "user": User.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "dataset": UserDataset.from_dict(obj["dataset"]) if obj.get("dataset") is not None else None,
            "llm": Llm.from_dict(obj["llm"]) if obj.get("llm") is not None else None,
            "inputTokens": obj.get("inputTokens"),
            "inputCost": obj.get("inputCost"),
            "outputTokens": obj.get("outputTokens"),
            "outputCost": obj.get("outputCost"),
            "usageOrigin": obj.get("usageOrigin")
        })
        return _obj

from qanswer_sdk.models.llm import Llm
from qanswer_sdk.models.user_dataset import UserDataset
# TODO: Rewrite to not use raise_errors
LlmConsumption.model_rebuild(raise_errors=False)

