# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class PlanDto(BaseModel):
    """
    PlanDto
    """ # noqa: E501
    plan: Optional[StrictStr] = None
    short_name: Optional[StrictStr] = Field(default=None, alias="shortName")
    pricing_plan: Optional[StrictStr] = Field(default=None, alias="pricingPlan")
    features: Optional[List[StrictStr]] = None
    description: Optional[StrictStr] = None
    price: Optional[Union[StrictFloat, StrictInt]] = None
    price_monthly: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="priceMonthly")
    duration_in_months: Optional[StrictInt] = Field(default=None, alias="durationInMonths")
    currency: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["plan", "shortName", "pricingPlan", "features", "description", "price", "priceMonthly", "durationInMonths", "currency"]

    @field_validator('pricing_plan')
    def pricing_plan_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NOT_LOGGED', 'FREE', 'BASIC', 'BASIC_DOLLAR', 'BASIC_ANNUAL', 'BASIC_ANNUAL_DOLLAR', 'PROFESSIONAL', 'PROFESSIONAL_DOLLAR', 'PROFESSIONAL_ANNUAL', 'PROFESSIONAL_ANNUAL_DOLLAR', 'CUSTOM', 'UNLIMITED']):
            raise ValueError("must be one of enum values ('NOT_LOGGED', 'FREE', 'BASIC', 'BASIC_DOLLAR', 'BASIC_ANNUAL', 'BASIC_ANNUAL_DOLLAR', 'PROFESSIONAL', 'PROFESSIONAL_DOLLAR', 'PROFESSIONAL_ANNUAL', 'PROFESSIONAL_ANNUAL_DOLLAR', 'CUSTOM', 'UNLIMITED')")
        return value

    @field_validator('currency')
    def currency_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['EURO', 'DOLLAR', 'NONE']):
            raise ValueError("must be one of enum values ('EURO', 'DOLLAR', 'NONE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlanDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlanDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "plan": obj.get("plan"),
            "shortName": obj.get("shortName"),
            "pricingPlan": obj.get("pricingPlan"),
            "features": obj.get("features"),
            "description": obj.get("description"),
            "price": obj.get("price"),
            "priceMonthly": obj.get("priceMonthly"),
            "durationInMonths": obj.get("durationInMonths"),
            "currency": obj.get("currency")
        })
        return _obj


