# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class PublicationOfficeAdditionalFields(BaseModel):
    """
    PublicationOfficeAdditionalFields
    """ # noqa: E501
    file_id: StrictStr
    collections: List[StrictStr]
    thumbnail_url: StrictStr
    modified_at: StrictStr
    created_at: StrictStr
    work_date: StrictStr
    languages: List[StrictStr]
    titles: List[Dict[str, StrictStr]]
    descriptions: List[Dict[str, StrictStr]]
    subjects: List[Dict[str, StrictStr]]
    formats: List[StrictStr]
    domains: List[StrictStr]
    download_url: StrictStr
    __properties: ClassVar[List[str]] = ["file_id", "collections", "thumbnail_url", "modified_at", "created_at", "work_date", "languages", "titles", "descriptions", "subjects", "formats", "domains", "download_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicationOfficeAdditionalFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicationOfficeAdditionalFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "file_id": obj.get("file_id"),
            "collections": obj.get("collections"),
            "thumbnail_url": obj.get("thumbnail_url"),
            "modified_at": obj.get("modified_at"),
            "created_at": obj.get("created_at"),
            "work_date": obj.get("work_date"),
            "languages": obj.get("languages"),
            "titles": obj.get("titles"),
            "descriptions": obj.get("descriptions"),
            "subjects": obj.get("subjects"),
            "formats": obj.get("formats"),
            "domains": obj.get("domains"),
            "download_url": obj.get("download_url")
        })
        return _obj


