# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.aggregations_group import AggregationsGroup
from qanswer_sdk.models.publication_file_metadata import PublicationFileMetadata
from typing import Optional, Set
from typing_extensions import Self

class PublicationSearchIndexSearchResponse(BaseModel):
    """
    PublicationSearchIndexSearchResponse
    """ # noqa: E501
    username: StrictStr
    dataset: StrictStr
    connector_id: StrictInt
    total_count: StrictInt
    aggregations: Optional[List[AggregationsGroup]] = None
    files: List[PublicationFileMetadata]
    __properties: ClassVar[List[str]] = ["username", "dataset", "connector_id", "total_count", "aggregations", "files"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicationSearchIndexSearchResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in aggregations (list)
        _items = []
        if self.aggregations:
            for _item_aggregations in self.aggregations:
                if _item_aggregations:
                    _items.append(_item_aggregations.to_dict())
            _dict['aggregations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item_files in self.files:
                if _item_files:
                    _items.append(_item_files.to_dict())
            _dict['files'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicationSearchIndexSearchResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "connector_id": obj.get("connector_id"),
            "total_count": obj.get("total_count"),
            "aggregations": [AggregationsGroup.from_dict(_item) for _item in obj["aggregations"]] if obj.get("aggregations") is not None else None,
            "files": [PublicationFileMetadata.from_dict(_item) for _item in obj["files"]] if obj.get("files") is not None else None
        })
        return _obj


