# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from qanswer_sdk.models.coordinates import Coordinates
from typing import Optional, Set
from typing_extensions import Self

class QaContext(BaseModel):
    """
    QaContext
    """ # noqa: E501
    kb: Optional[StrictStr] = None
    uri: Optional[StrictStr] = None
    user: Optional[StrictStr] = None
    literal: Optional[StrictStr] = None
    literal_datatype: Optional[StrictStr] = Field(default=None, alias="literalDatatype")
    label: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    disambiguation: Optional[StrictStr] = None
    links: Optional[Dict[str, StrictStr]] = None
    time: Optional[StrictStr] = None
    time_series: Optional[StrictStr] = Field(default=None, alias="timeSeries")
    images: Optional[List[StrictStr]] = None
    audio: Optional[List[StrictStr]] = None
    geo: Optional[List[Coordinates]] = None
    video: Optional[List[StrictStr]] = None
    geo_json: Optional[StrictStr] = Field(default=None, alias="geoJson")
    optional: Optional[Dict[str, List[StrictStr]]] = None
    page_rank: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="pageRank")
    __properties: ClassVar[List[str]] = ["kb", "uri", "user", "literal", "literalDatatype", "label", "description", "disambiguation", "links", "time", "timeSeries", "images", "audio", "geo", "video", "geoJson", "optional", "pageRank"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QaContext from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in geo (list)
        _items = []
        if self.geo:
            for _item_geo in self.geo:
                if _item_geo:
                    _items.append(_item_geo.to_dict())
            _dict['geo'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QaContext from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "kb": obj.get("kb"),
            "uri": obj.get("uri"),
            "user": obj.get("user"),
            "literal": obj.get("literal"),
            "literalDatatype": obj.get("literalDatatype"),
            "label": obj.get("label"),
            "description": obj.get("description"),
            "disambiguation": obj.get("disambiguation"),
            "links": obj.get("links"),
            "time": obj.get("time"),
            "timeSeries": obj.get("timeSeries"),
            "images": obj.get("images"),
            "audio": obj.get("audio"),
            "geo": [Coordinates.from_dict(_item) for _item in obj["geo"]] if obj.get("geo") is not None else None,
            "video": obj.get("video"),
            "geoJson": obj.get("geoJson"),
            "optional": obj.get("optional"),
            "pageRank": obj.get("pageRank")
        })
        return _obj


