# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.qa_context import QaContext
from qanswer_sdk.models.qa_table import QaTable
from typing import Optional, Set
from typing_extensions import Self

class QaContexts(BaseModel):
    """
    QaContexts
    """ # noqa: E501
    qa_context: Optional[List[QaContext]] = Field(default=None, alias="qaContext")
    display_types: Optional[List[StrictStr]] = Field(default=None, alias="displayTypes")
    qa_table: Optional[QaTable] = Field(default=None, alias="qaTable")
    timeout: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["qaContext", "displayTypes", "qaTable", "timeout"]

    @field_validator('display_types')
    def display_types_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['SIMPLE', 'LIST', 'FACET', 'IMAGES', 'TABLE', 'MAP', 'TIME_SERIES', 'TIME', 'TIMEOUT']):
                raise ValueError("each list item must be one of ('SIMPLE', 'LIST', 'FACET', 'IMAGES', 'TABLE', 'MAP', 'TIME_SERIES', 'TIME', 'TIMEOUT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QaContexts from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in qa_context (list)
        _items = []
        if self.qa_context:
            for _item_qa_context in self.qa_context:
                if _item_qa_context:
                    _items.append(_item_qa_context.to_dict())
            _dict['qaContext'] = _items
        # override the default output from pydantic by calling `to_dict()` of qa_table
        if self.qa_table:
            _dict['qaTable'] = self.qa_table.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QaContexts from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "qaContext": [QaContext.from_dict(_item) for _item in obj["qaContext"]] if obj.get("qaContext") is not None else None,
            "displayTypes": obj.get("displayTypes"),
            "qaTable": QaTable.from_dict(obj["qaTable"]) if obj.get("qaTable") is not None else None,
            "timeout": obj.get("timeout")
        })
        return _obj


