# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.search_metadata_filter import SearchMetadataFilter
from typing import Optional, Set
from typing_extensions import Self

class RAGPayload(BaseModel):
    """
    RAGPayload
    """ # noqa: E501
    question: StrictStr = Field(description="The input question from the user.")
    username: StrictStr = Field(description="The username of the user.")
    dataset: StrictStr = Field(description="The dataset to be queried for information.")
    organization_id: Optional[StrictInt] = Field(default=None, description="organization identifier to access shared resources.", alias="organizationId")
    image_urls: Optional[List[StrictStr]] = Field(default=None, description="List of image URLs to be processed if provided.")
    parent_message_id: Optional[StrictStr] = Field(default=None, description="ID of the parent generation (message_id of parent response or question) if applicable; used for tracking multi-turn conversations.")
    conversation_id: StrictStr = Field(description="Unique identifier for the conversation.")
    is_regenerate: Optional[StrictBool] = Field(default=None, description="Indicates if the user is asking for a regenerated response.")
    origin: Optional[StrictStr] = Field(default=None, description="The username or IP address of the user making the request.")
    text_fragmentation: Optional[StrictBool] = Field(default=None, description="Detemines wether links for website sources should have text fragments.")
    interface_origin: Optional[StrictStr] = Field(default=None, description="The interface from which the request originated (search, chat, microsoft_teams, etc.).")
    system_prompt: Optional[StrictStr] = Field(default=None, description="The system prompt to be used for the response.")
    prompt: Optional[StrictStr] = Field(default=None, description="The raw prompt submitted to the model.")
    additional_fields: Optional[Dict[str, Any]] = Field(default=None, description="Additional metadata fields for customization, generally metadata that can be consumed in the prompt.")
    bypass_guardrail: Optional[StrictBool] = Field(default=None, description="Determines whether safety guardrails should be bypassed.")
    talk_to_web: Optional[StrictBool] = Field(default=None, description="Determines whether the response should be sent to the web interface.")
    original_question: Optional[StrictStr] = Field(default=None, description="The original question submitted to the model.")
    oauth_token: Optional[StrictStr] = Field(default=None, description="The oauth token")
    auto_filters: Optional[StrictBool] = Field(default=None, description="Determines whether the auto filters should be used for the response.")
    filters: Optional[List[List[SearchMetadataFilter]]] = None
    exclude_filters: Optional[List[List[SearchMetadataFilter]]] = None
    index_hashes: Optional[List[Dict[str, Any]]] = Field(default=None, description="The hashes of the indexes to be used for the response.")
    agentic_chatbot_enabled: Optional[StrictBool] = Field(default=None, description="Whether the agentic chatbot is enabled.")
    apply_map_reduce: Optional[StrictBool] = Field(default=None, description="Determines whether to apply map-reduce strategy for the response.")
    conversation_has_clip: Optional[StrictBool] = Field(default=None, description="Indicates whether the conversation has a clip associated with it.")
    current_time: Optional[StrictStr] = Field(default=None, description="The current time to be used in the prompt, if applicable.")
    __properties: ClassVar[List[str]] = ["question", "username", "dataset", "organizationId", "image_urls", "parent_message_id", "conversation_id", "is_regenerate", "origin", "text_fragmentation", "interface_origin", "system_prompt", "prompt", "additional_fields", "bypass_guardrail", "talk_to_web", "original_question", "oauth_token", "auto_filters", "filters", "exclude_filters", "index_hashes", "agentic_chatbot_enabled", "apply_map_reduce", "conversation_has_clip", "current_time"]

    @field_validator('interface_origin')
    def interface_origin_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['search', 'chat', 'widget', 'microsoft_teams', 'discord', 'slack', 'chatbot_playground', 'undefined', 'report_copilot']):
            raise ValueError("must be one of enum values ('search', 'chat', 'widget', 'microsoft_teams', 'discord', 'slack', 'chatbot_playground', 'undefined', 'report_copilot')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RAGPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list of list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(
                         [_inner_item.to_dict() for _inner_item in _item_filters if _inner_item is not None]
                    )
            _dict['filters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in exclude_filters (list of list)
        _items = []
        if self.exclude_filters:
            for _item_exclude_filters in self.exclude_filters:
                if _item_exclude_filters:
                    _items.append(
                         [_inner_item.to_dict() for _inner_item in _item_exclude_filters if _inner_item is not None]
                    )
            _dict['exclude_filters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RAGPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "question": obj.get("question"),
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "organizationId": obj.get("organizationId"),
            "image_urls": obj.get("image_urls"),
            "parent_message_id": obj.get("parent_message_id"),
            "conversation_id": obj.get("conversation_id"),
            "is_regenerate": obj.get("is_regenerate"),
            "origin": obj.get("origin"),
            "text_fragmentation": obj.get("text_fragmentation"),
            "interface_origin": obj.get("interface_origin"),
            "system_prompt": obj.get("system_prompt"),
            "prompt": obj.get("prompt"),
            "additional_fields": obj.get("additional_fields"),
            "bypass_guardrail": obj.get("bypass_guardrail"),
            "talk_to_web": obj.get("talk_to_web"),
            "original_question": obj.get("original_question"),
            "oauth_token": obj.get("oauth_token"),
            "auto_filters": obj.get("auto_filters"),
            "filters": [
                    [SearchMetadataFilter.from_dict(_inner_item) for _inner_item in _item]
                    for _item in obj["filters"]
                ] if obj.get("filters") is not None else None,
            "exclude_filters": [
                    [SearchMetadataFilter.from_dict(_inner_item) for _inner_item in _item]
                    for _item in obj["exclude_filters"]
                ] if obj.get("exclude_filters") is not None else None,
            "index_hashes": obj.get("index_hashes"),
            "agentic_chatbot_enabled": obj.get("agentic_chatbot_enabled"),
            "apply_map_reduce": obj.get("apply_map_reduce"),
            "conversation_has_clip": obj.get("conversation_has_clip"),
            "current_time": obj.get("current_time")
        })
        return _obj


