# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.slot_update import SlotUpdate
from typing import Optional, Set
from typing_extensions import Self

class ReportTemplateCreatePayload(BaseModel):
    """
    ReportTemplateCreatePayload
    """ # noqa: E501
    username: StrictStr
    author: Optional[StrictStr] = None
    dataset: StrictStr
    template_name: StrictStr
    template_with_slots: StrictStr
    slots: List[SlotUpdate]
    __properties: ClassVar[List[str]] = ["username", "author", "dataset", "template_name", "template_with_slots", "slots"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReportTemplateCreatePayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in slots (list)
        _items = []
        if self.slots:
            for _item_slots in self.slots:
                if _item_slots:
                    _items.append(_item_slots.to_dict())
            _dict['slots'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReportTemplateCreatePayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "author": obj.get("author"),
            "dataset": obj.get("dataset"),
            "template_name": obj.get("template_name"),
            "template_with_slots": obj.get("template_with_slots"),
            "slots": [SlotUpdate.from_dict(_item) for _item in obj["slots"]] if obj.get("slots") is not None else None
        })
        return _obj


