# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ReportTemplateSimplified(BaseModel):
    """
    ReportTemplateSimplified
    """ # noqa: E501
    id: StrictInt
    username: StrictStr
    conversation_id: StrictStr
    author: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    template_name: StrictStr
    creation_date: StrictStr
    last_updated: StrictStr
    shared_to: Optional[StrictStr] = None
    is_duplicated: StrictBool
    is_generating: Optional[StrictBool] = None
    active_slot_id: Optional[StrictInt] = None
    description: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "username", "conversation_id", "author", "email", "template_name", "creation_date", "last_updated", "shared_to", "is_duplicated", "is_generating", "active_slot_id", "description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReportTemplateSimplified from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReportTemplateSimplified from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "username": obj.get("username"),
            "conversation_id": obj.get("conversation_id"),
            "author": obj.get("author"),
            "email": obj.get("email"),
            "template_name": obj.get("template_name"),
            "creation_date": obj.get("creation_date"),
            "last_updated": obj.get("last_updated"),
            "shared_to": obj.get("shared_to"),
            "is_duplicated": obj.get("is_duplicated"),
            "is_generating": obj.get("is_generating"),
            "active_slot_id": obj.get("active_slot_id"),
            "description": obj.get("description")
        })
        return _obj


