# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.aggregations_group import AggregationsGroup
from qanswer_sdk.models.source import Source
from typing import Optional, Set
from typing_extensions import Self

class SearchResponse(BaseModel):
    """
    SearchResponse
    """ # noqa: E501
    documents: Optional[List[Source]] = None
    limit: StrictInt
    offset: StrictInt
    count: StrictInt
    total: StrictInt
    aggs: Optional[List[AggregationsGroup]] = Field(default=None, description="Aggregations response containing additional metadata or statistics related to the response.")
    __properties: ClassVar[List[str]] = ["documents", "limit", "offset", "count", "total", "aggs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SearchResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in documents (list)
        _items = []
        if self.documents:
            for _item_documents in self.documents:
                if _item_documents:
                    _items.append(_item_documents.to_dict())
            _dict['documents'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in aggs (list)
        _items = []
        if self.aggs:
            for _item_aggs in self.aggs:
                if _item_aggs:
                    _items.append(_item_aggs.to_dict())
            _dict['aggs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SearchResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "documents": [Source.from_dict(_item) for _item in obj["documents"]] if obj.get("documents") is not None else None,
            "limit": obj.get("limit"),
            "offset": obj.get("offset"),
            "count": obj.get("count"),
            "total": obj.get("total"),
            "aggs": [AggregationsGroup.from_dict(_item) for _item in obj["aggs"]] if obj.get("aggs") is not None else None
        })
        return _obj


