# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from qanswer_sdk.models.llm_endpoint_read_output import LLMEndpointReadOutput
from typing import Optional, Set
from typing_extensions import Self

class SearchTaskSettings(BaseModel):
    """
    SearchTaskSettings
    """ # noqa: E501
    prompt: Optional[StrictStr] = None
    bot_seed: Optional[StrictInt] = None
    bot_temperature: Optional[Union[StrictFloat, StrictInt]] = None
    bot_answer_length: Optional[StrictStr] = None
    number_of_references: Optional[StrictInt] = None
    stream_speed: Optional[Union[StrictFloat, StrictInt]] = None
    context_window: Optional[StrictInt] = None
    max_tokens: Optional[StrictInt] = None
    slots_values: Optional[Dict[str, StrictStr]] = None
    bot_name: Optional[StrictStr] = None
    bot_description: Optional[StrictStr] = None
    llm_id: Optional[StrictInt] = Field(default=None, description="The LLM ID. This field is populated based on the llm_choice.")
    llm_endpoint: Optional[LLMEndpointReadOutput] = None
    query_expansion_prompt: Optional[StrictStr] = None
    enable_enhanced_context: Optional[StrictBool] = None
    map_prompt: Optional[StrictStr] = None
    reduce_prompt: Optional[StrictStr] = None
    show_date_in_sources: Optional[StrictBool] = None
    show_reference_question: Optional[StrictBool] = None
    selected_aggregations: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["prompt", "bot_seed", "bot_temperature", "bot_answer_length", "number_of_references", "stream_speed", "context_window", "max_tokens", "slots_values", "bot_name", "bot_description", "llm_id", "llm_endpoint", "query_expansion_prompt", "enable_enhanced_context", "map_prompt", "reduce_prompt", "show_date_in_sources", "show_reference_question", "selected_aggregations"]

    @field_validator('bot_answer_length')
    def bot_answer_length_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['short', 'brief', 'long']):
            raise ValueError("must be one of enum values ('short', 'brief', 'long')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SearchTaskSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of llm_endpoint
        if self.llm_endpoint:
            _dict['llm_endpoint'] = self.llm_endpoint.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SearchTaskSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "prompt": obj.get("prompt"),
            "bot_seed": obj.get("bot_seed"),
            "bot_temperature": obj.get("bot_temperature"),
            "bot_answer_length": obj.get("bot_answer_length"),
            "number_of_references": obj.get("number_of_references"),
            "stream_speed": obj.get("stream_speed"),
            "context_window": obj.get("context_window"),
            "max_tokens": obj.get("max_tokens"),
            "slots_values": obj.get("slots_values"),
            "bot_name": obj.get("bot_name"),
            "bot_description": obj.get("bot_description"),
            "llm_id": obj.get("llm_id"),
            "llm_endpoint": LLMEndpointReadOutput.from_dict(obj["llm_endpoint"]) if obj.get("llm_endpoint") is not None else None,
            "query_expansion_prompt": obj.get("query_expansion_prompt"),
            "enable_enhanced_context": obj.get("enable_enhanced_context"),
            "map_prompt": obj.get("map_prompt"),
            "reduce_prompt": obj.get("reduce_prompt"),
            "show_date_in_sources": obj.get("show_date_in_sources"),
            "show_reference_question": obj.get("show_reference_question"),
            "selected_aggregations": obj.get("selected_aggregations")
        })
        return _obj


