# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.audio_segment import AudioSegment
from qanswer_sdk.models.audio_word_segment import AudioWordSegment
from typing import Optional, Set
from typing_extensions import Self

class SocketSpeech2TextResponse(BaseModel):
    """
    SocketSpeech2TextResponse
    """ # noqa: E501
    transcription: StrictStr
    mode: Optional[StrictStr] = None
    segments: Optional[List[AudioSegment]] = None
    word_segments: Optional[List[AudioWordSegment]] = None
    username: StrictStr = Field(description="Username of the dataset")
    dataset: StrictStr = Field(description="Name of the dataset")
    jwt: StrictStr = Field(description="JTW token for authentification to join the conversation.")
    api_key: Optional[StrictStr] = Field(default=None, description="Api ley for authentification to join the conversation.")
    conversation_id: StrictStr = Field(description="ID of the conversation")
    user: Optional[StrictStr] = Field(default=None, description="User that is joining the conversation")
    __properties: ClassVar[List[str]] = ["transcription", "mode", "segments", "word_segments", "username", "dataset", "jwt", "api_key", "conversation_id", "user"]

    @field_validator('mode')
    def mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['transcription', 'diarization']):
            raise ValueError("must be one of enum values ('transcription', 'diarization')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SocketSpeech2TextResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in segments (list)
        _items = []
        if self.segments:
            for _item_segments in self.segments:
                if _item_segments:
                    _items.append(_item_segments.to_dict())
            _dict['segments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in word_segments (list)
        _items = []
        if self.word_segments:
            for _item_word_segments in self.word_segments:
                if _item_word_segments:
                    _items.append(_item_word_segments.to_dict())
            _dict['word_segments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SocketSpeech2TextResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "transcription": obj.get("transcription"),
            "mode": obj.get("mode"),
            "segments": [AudioSegment.from_dict(_item) for _item in obj["segments"]] if obj.get("segments") is not None else None,
            "word_segments": [AudioWordSegment.from_dict(_item) for _item in obj["word_segments"]] if obj.get("word_segments") is not None else None,
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "jwt": obj.get("jwt"),
            "api_key": obj.get("api_key"),
            "conversation_id": obj.get("conversation_id"),
            "user": obj.get("user")
        })
        return _obj


