# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Source(BaseModel):
    """
    Source
    """ # noqa: E501
    title: StrictStr = Field(description="The title of the source document.")
    document: StrictStr = Field(description="The full text content of the source document.")
    document_with_highlights: Optional[StrictStr] = Field(default=None, description="The document text with highlighted matched keywords.")
    from_page: Optional[StrictInt] = Field(default=None, description="The starting page number of the document section, if applicable.")
    to_page: Optional[StrictInt] = Field(default=None, description="The ending page number of the document section, if applicable.")
    source_url: Optional[StrictStr] = Field(default=None, description="The URL of the source document, if applicable.")
    source_type: Optional[StrictStr] = Field(default=None, description="The type of source (e.g., qna, website, document).")
    file_type: Optional[StrictStr] = Field(default=None, description="The file&#39;s extension associated with the source (e.g., PDF, DOCX, TXT).")
    file_id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the file in the system.")
    display_name: Optional[StrictStr] = Field(default=None, description="A human-readable name for the file, if available.")
    file_name: Optional[StrictStr] = Field(default=None, description="The system-assigned name of the file.")
    original_file_name: Optional[StrictStr] = Field(default=None, description="The original name of the file as uploaded.")
    connector_type: Optional[StrictStr] = Field(default=None, description="The document&#39;s connector type (e.g., website, document, sharepoint).")
    connector_id: Optional[StrictInt] = Field(default=None, description="The unique identifier of the connector")
    additional_fields: Optional[Dict[str, Any]] = Field(default=None, description="A dictionary containing extra metadata fields.")
    ref_id: Optional[StrictStr] = Field(default=None, description="A reference identifier for tracking the document, used to map the superscript in the ai response.")
    favicon: Optional[StrictStr] = Field(default=None, description="The favicon of the source website, if applicable.")
    username: Optional[StrictStr] = Field(default=None, description="The username of the user who uploaded the document or source.")
    dataset: Optional[StrictStr] = Field(default=None, description="The dataset to which the document or source belongs.")
    last_updated_at: Optional[StrictStr] = Field(default=None, description="The last updated timestamp of the source document.")
    __properties: ClassVar[List[str]] = ["title", "document", "document_with_highlights", "from_page", "to_page", "source_url", "source_type", "file_type", "file_id", "display_name", "file_name", "original_file_name", "connector_type", "connector_id", "additional_fields", "ref_id", "favicon", "username", "dataset", "last_updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Source from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Source from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "document": obj.get("document"),
            "document_with_highlights": obj.get("document_with_highlights"),
            "from_page": obj.get("from_page"),
            "to_page": obj.get("to_page"),
            "source_url": obj.get("source_url"),
            "source_type": obj.get("source_type"),
            "file_type": obj.get("file_type"),
            "file_id": obj.get("file_id"),
            "display_name": obj.get("display_name"),
            "file_name": obj.get("file_name"),
            "original_file_name": obj.get("original_file_name"),
            "connector_type": obj.get("connector_type"),
            "connector_id": obj.get("connector_id"),
            "additional_fields": obj.get("additional_fields"),
            "ref_id": obj.get("ref_id"),
            "favicon": obj.get("favicon"),
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "last_updated_at": obj.get("last_updated_at")
        })
        return _obj


