# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UIMappings(BaseModel):
    """
    UIMappings
    """ # noqa: E501
    username: Optional[StrictStr] = None
    dataset: Optional[StrictStr] = None
    main_label: Optional[StrictStr] = Field(default=None, alias="mainLabel")
    label: Optional[List[StrictStr]] = None
    description: Optional[List[StrictStr]] = None
    disambiguation: Optional[List[StrictStr]] = None
    image: Optional[List[StrictStr]] = None
    coordinate: Optional[List[StrictStr]] = None
    latitude: Optional[List[StrictStr]] = None
    longitude: Optional[List[StrictStr]] = None
    time: Optional[List[StrictStr]] = None
    time_series: Optional[List[StrictStr]] = Field(default=None, alias="timeSeries")
    osm_relation: Optional[List[StrictStr]] = Field(default=None, alias="osmRelation")
    youtube: Optional[List[StrictStr]] = None
    github: Optional[List[StrictStr]] = None
    twitter: Optional[List[StrictStr]] = None
    facebook: Optional[List[StrictStr]] = None
    instagram: Optional[List[StrictStr]] = None
    homepage: Optional[List[StrictStr]] = None
    orcid: Optional[List[StrictStr]] = None
    linkedin: Optional[List[StrictStr]] = None
    doi: Optional[List[StrictStr]] = None
    geometry: Optional[List[StrictStr]] = None
    wikipedia: Optional[List[StrictStr]] = None
    wikidata: Optional[List[StrictStr]] = None
    dbpedia: Optional[List[StrictStr]] = None
    optional: Optional[List[StrictStr]] = None
    ignore: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["username", "dataset", "mainLabel", "label", "description", "disambiguation", "image", "coordinate", "latitude", "longitude", "time", "timeSeries", "osmRelation", "youtube", "github", "twitter", "facebook", "instagram", "homepage", "orcid", "linkedin", "doi", "geometry", "wikipedia", "wikidata", "dbpedia", "optional", "ignore"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UIMappings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UIMappings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "mainLabel": obj.get("mainLabel"),
            "label": obj.get("label"),
            "description": obj.get("description"),
            "disambiguation": obj.get("disambiguation"),
            "image": obj.get("image"),
            "coordinate": obj.get("coordinate"),
            "latitude": obj.get("latitude"),
            "longitude": obj.get("longitude"),
            "time": obj.get("time"),
            "timeSeries": obj.get("timeSeries"),
            "osmRelation": obj.get("osmRelation"),
            "youtube": obj.get("youtube"),
            "github": obj.get("github"),
            "twitter": obj.get("twitter"),
            "facebook": obj.get("facebook"),
            "instagram": obj.get("instagram"),
            "homepage": obj.get("homepage"),
            "orcid": obj.get("orcid"),
            "linkedin": obj.get("linkedin"),
            "doi": obj.get("doi"),
            "geometry": obj.get("geometry"),
            "wikipedia": obj.get("wikipedia"),
            "wikidata": obj.get("wikidata"),
            "dbpedia": obj.get("dbpedia"),
            "optional": obj.get("optional"),
            "ignore": obj.get("ignore")
        })
        return _obj


