# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from qanswer_sdk.models.entity_description import EntityDescription
from qanswer_sdk.models.logo import Logo
from qanswer_sdk.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class UserDataset(BaseModel):
    """
    UserDataset
    """ # noqa: E501
    id: Optional[StrictInt] = None
    dataset: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    user: Optional[User] = None
    uploaded: Optional[StrictBool] = None
    indexed: Optional[StrictBool] = None
    access: Optional[StrictBool] = None
    access_type: Optional[StrictStr] = Field(default=None, alias="accessType")
    size: Optional[StrictInt] = None
    created: Optional[datetime] = None
    index_type: Optional[StrictStr] = Field(default=None, alias="indexType")
    languages: Optional[List[StrictStr]] = None
    shared_users: Optional[List[UserDatasetShared]] = Field(default=None, alias="sharedUsers")
    shared_teams: Optional[List[SharedTeamAccess]] = Field(default=None, alias="sharedTeams")
    shared_organizations: Optional[List[SharedOrganizationAccess]] = Field(default=None, alias="sharedOrganizations")
    entity_description: Optional[EntityDescription] = Field(default=None, alias="entityDescription")
    logo: Optional[Logo] = None
    llm_consumptions: Optional[List[LlmConsumption]] = Field(default=None, alias="llmConsumptions")
    __properties: ClassVar[List[str]] = ["id", "dataset", "name", "description", "user", "uploaded", "indexed", "access", "accessType", "size", "created", "indexType", "languages", "sharedUsers", "sharedTeams", "sharedOrganizations", "entityDescription", "logo", "llmConsumptions"]

    @field_validator('access_type')
    def access_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Owned', 'SharedWrite', 'SharedRead', 'UseOnly', 'LoggedIn', 'Open', 'None']):
            raise ValueError("must be one of enum values ('Owned', 'SharedWrite', 'SharedRead', 'UseOnly', 'LoggedIn', 'Open', 'None')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserDataset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in shared_users (list)
        _items = []
        if self.shared_users:
            for _item_shared_users in self.shared_users:
                if _item_shared_users:
                    _items.append(_item_shared_users.to_dict())
            _dict['sharedUsers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shared_teams (list)
        _items = []
        if self.shared_teams:
            for _item_shared_teams in self.shared_teams:
                if _item_shared_teams:
                    _items.append(_item_shared_teams.to_dict())
            _dict['sharedTeams'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shared_organizations (list)
        _items = []
        if self.shared_organizations:
            for _item_shared_organizations in self.shared_organizations:
                if _item_shared_organizations:
                    _items.append(_item_shared_organizations.to_dict())
            _dict['sharedOrganizations'] = _items
        # override the default output from pydantic by calling `to_dict()` of entity_description
        if self.entity_description:
            _dict['entityDescription'] = self.entity_description.to_dict()
        # override the default output from pydantic by calling `to_dict()` of logo
        if self.logo:
            _dict['logo'] = self.logo.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in llm_consumptions (list)
        _items = []
        if self.llm_consumptions:
            for _item_llm_consumptions in self.llm_consumptions:
                if _item_llm_consumptions:
                    _items.append(_item_llm_consumptions.to_dict())
            _dict['llmConsumptions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserDataset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "dataset": obj.get("dataset"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "user": User.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "uploaded": obj.get("uploaded"),
            "indexed": obj.get("indexed"),
            "access": obj.get("access"),
            "accessType": obj.get("accessType"),
            "size": obj.get("size"),
            "created": obj.get("created"),
            "indexType": obj.get("indexType"),
            "languages": obj.get("languages"),
            "sharedUsers": [UserDatasetShared.from_dict(_item) for _item in obj["sharedUsers"]] if obj.get("sharedUsers") is not None else None,
            "sharedTeams": [SharedTeamAccess.from_dict(_item) for _item in obj["sharedTeams"]] if obj.get("sharedTeams") is not None else None,
            "sharedOrganizations": [SharedOrganizationAccess.from_dict(_item) for _item in obj["sharedOrganizations"]] if obj.get("sharedOrganizations") is not None else None,
            "entityDescription": EntityDescription.from_dict(obj["entityDescription"]) if obj.get("entityDescription") is not None else None,
            "logo": Logo.from_dict(obj["logo"]) if obj.get("logo") is not None else None,
            "llmConsumptions": [LlmConsumption.from_dict(_item) for _item in obj["llmConsumptions"]] if obj.get("llmConsumptions") is not None else None
        })
        return _obj

from qanswer_sdk.models.llm_consumption import LlmConsumption
from qanswer_sdk.models.shared_organization_access import SharedOrganizationAccess
from qanswer_sdk.models.shared_team_access import SharedTeamAccess
from qanswer_sdk.models.user_dataset_shared import UserDatasetShared
# TODO: Rewrite to not use raise_errors
UserDataset.model_rebuild(raise_errors=False)

