# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class UserDatasetApiKey(BaseModel):
    """
    UserDatasetApiKey
    """ # noqa: E501
    id: Optional[StrictInt] = None
    username: Optional[StrictStr] = None
    dataset: Optional[StrictStr] = None
    api_key: Optional[StrictStr] = Field(default=None, alias="apiKey")
    api_key_name: Optional[StrictStr] = Field(default=None, alias="apiKeyName")
    expiry_date: Optional[datetime] = Field(default=None, alias="expiryDate")
    question_credits_start: Optional[datetime] = Field(default=None, alias="questionCreditsStart")
    question_credits_used: Optional[StrictInt] = Field(default=None, alias="questionCreditsUsed")
    quota_question_credits: Optional[StrictInt] = Field(default=None, alias="quotaQuestionCredits")
    access_type: Optional[StrictStr] = Field(default=None, alias="accessType")
    credit_capacity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="creditCapacity")
    credit_usage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="creditUsage")
    credit_quota_exceeded: Optional[StrictBool] = Field(default=None, alias="creditQuotaExceeded")
    __properties: ClassVar[List[str]] = ["id", "username", "dataset", "apiKey", "apiKeyName", "expiryDate", "questionCreditsStart", "questionCreditsUsed", "quotaQuestionCredits", "accessType", "creditCapacity", "creditUsage", "creditQuotaExceeded"]

    @field_validator('access_type')
    def access_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Owned', 'SharedWrite', 'SharedRead', 'UseOnly', 'LoggedIn', 'Open', 'None']):
            raise ValueError("must be one of enum values ('Owned', 'SharedWrite', 'SharedRead', 'UseOnly', 'LoggedIn', 'Open', 'None')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserDatasetApiKey from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserDatasetApiKey from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "apiKey": obj.get("apiKey"),
            "apiKeyName": obj.get("apiKeyName"),
            "expiryDate": obj.get("expiryDate"),
            "questionCreditsStart": obj.get("questionCreditsStart"),
            "questionCreditsUsed": obj.get("questionCreditsUsed"),
            "quotaQuestionCredits": obj.get("quotaQuestionCredits"),
            "accessType": obj.get("accessType"),
            "creditCapacity": obj.get("creditCapacity"),
            "creditUsage": obj.get("creditUsage"),
            "creditQuotaExceeded": obj.get("creditQuotaExceeded")
        })
        return _obj


