# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class WebsiteConnectorSettings(BaseModel):
    """
    WebsiteConnectorSettings
    """ # noqa: E501
    connector_id: Annotated[int, Field(strict=True, ge=1)] = Field(description="Connector ID")
    username: Annotated[str, Field(min_length=1, strict=True, max_length=2147483647)] = Field(description="Username")
    dataset: Annotated[str, Field(min_length=1, strict=True, max_length=2147483647)] = Field(description="Dataset")
    explicit_sleep: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Explicit Sleep for loading the website")
    scrolling_strategy: Optional[StrictStr] = Field(default=None, description="How the website should be scrolled for loading the contents")
    css_include: Optional[StrictStr] = Field(default=None, description="What is the css query that should be used for including the elements")
    css_exclude: Optional[StrictStr] = Field(default=None, description="What is the css query that should be used for exluding the elements")
    return_type: Optional[StrictStr] = Field(default=None, description="Return type of the website txt or md")
    skip_404: Optional[StrictBool] = Field(default=None, description="If the website responds with 404 should this be excluded for scraping ")
    iframe_strategy: Optional[StrictStr] = Field(default=None, description="Should the iframes be actively searched or automatically processed?")
    shadow_dom_strategy: Optional[StrictStr] = Field(default=None, description="Should the shadow doem be actively searched or automatically processed?")
    cookies: Optional[Dict[str, Any]] = Field(default=None, description="What are the cookies that should be used for extracting websites")
    local_storage: Optional[Dict[str, Any]] = Field(default=None, description="What are the local storage key values that should be used for extracting websties")
    page_load_timeout: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="What is the page load timeout that is set for the webdriver")
    script_timeout: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="What is the script timeout used for the webdriver")
    implicit_timeout: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="What is the implicit timeout used for the webdeiver")
    custom_script: Optional[StrictStr] = Field(default=None, description="The custom java script to be executed.")
    __properties: ClassVar[List[str]] = ["connector_id", "username", "dataset", "explicit_sleep", "scrolling_strategy", "css_include", "css_exclude", "return_type", "skip_404", "iframe_strategy", "shadow_dom_strategy", "cookies", "local_storage", "page_load_timeout", "script_timeout", "implicit_timeout", "custom_script"]

    @field_validator('scrolling_strategy')
    def scrolling_strategy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['full', 'step']):
            raise ValueError("must be one of enum values ('full', 'step')")
        return value

    @field_validator('return_type')
    def return_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['txt', 'md', 'html']):
            raise ValueError("must be one of enum values ('txt', 'md', 'html')")
        return value

    @field_validator('iframe_strategy')
    def iframe_strategy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['auto', 'force', 'skip']):
            raise ValueError("must be one of enum values ('auto', 'force', 'skip')")
        return value

    @field_validator('shadow_dom_strategy')
    def shadow_dom_strategy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['auto', 'force', 'skip']):
            raise ValueError("must be one of enum values ('auto', 'force', 'skip')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebsiteConnectorSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebsiteConnectorSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "connector_id": obj.get("connector_id"),
            "username": obj.get("username"),
            "dataset": obj.get("dataset"),
            "explicit_sleep": obj.get("explicit_sleep"),
            "scrolling_strategy": obj.get("scrolling_strategy"),
            "css_include": obj.get("css_include"),
            "css_exclude": obj.get("css_exclude"),
            "return_type": obj.get("return_type"),
            "skip_404": obj.get("skip_404"),
            "iframe_strategy": obj.get("iframe_strategy"),
            "shadow_dom_strategy": obj.get("shadow_dom_strategy"),
            "cookies": obj.get("cookies"),
            "local_storage": obj.get("local_storage"),
            "page_load_timeout": obj.get("page_load_timeout"),
            "script_timeout": obj.get("script_timeout"),
            "implicit_timeout": obj.get("implicit_timeout"),
            "custom_script": obj.get("custom_script")
        })
        return _obj


