import typing as _t
import json
import logging
from ..api.renderers import ORJSONRenderer as ORJSONRenderer
from ..utils import raise_context_decorator_with_default as raise_context_decorator_with_default
from .base import get_proxy_labels as get_proxy_labels
from .model import BaseModel as BaseModel
from django.db.models import signals, Model

logger: logging.Logger


class NotifyClient(_t.Protocol):
    def add(self, method: _t.Text, params: _t.Dict): ...
    def send(self) -> list: ...
    def reset(self): ...


class JsonEncoder(json.JSONEncoder):
    def default(self, o): ...

class Notificator:
    client_class = NotifyClient
    queue: _t.List[_t.Tuple[_t.Sequence[_t.Text], _t.Any]]
    cent_client: NotifyClient
    label: _t.Text
    _json_renderer: ORJSONRenderer
    _signals: _t.List[signals.ModelSignal]
    def __init__(
        self,
        queue: _t.Optional[_t.List[_t.Tuple[_t.Sequence[_t.Text], _t.Any]]] = ...,
        client: _t.Optional[NotifyClient] = ...,
        label: _t.Optional[_t.Text] = ...,
        autoconnect: bool = ...
    ) -> None: ...
    def is_usable(self) -> bool: ...
    def connect_signal(self, signal: signals.ModelSignal): ...
    def disconnect_signal(self, signal: signals.ModelSignal): ...
    def signal_handler(self, instance: Model, *args, **kwargs) -> None: ...
    def get_openapi_secret(self) -> _t.Text: ...
    def get_client(self) -> NotifyClient: ...
    def create_notification_from_instance(self, instance) -> None: ...
    def create_notification(self, labels, data) -> None: ...
    def clear_messages(self) -> None: ...
    def send(self) -> _t.Optional[list]: ...
    def disconnect_all(self) -> None: ...
    def get_subscription_channel(self, label: _t.Text) -> _t.Text: ...
    def __del__(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type, exc_val, exc_tb) -> None: ...
