from typing import Text, Type
from django.core.files.images import ImageFile
from django.db.models import FileField, ForeignKey, ImageField, TextField
from django.db.models.fields.files import FieldFile, FileDescriptor
from vstutils.utils import raise_context_decorator_with_default as raise_context_decorator_with_default

class MultipleFieldFile(FieldFile):
    _old_name: Text
    def __init__(self, instance, field, name) -> None: ...
    def _set_attr_value(self) -> None: ...
    def _clear_attr_value(self) -> None: ...
    name: Text
    _committed: bool
    def save(self, name, content, save: bool = ...) -> None: ...
    def delete(self, save: bool = ...) -> None: ...

class MultipleFileDescriptor(FileDescriptor):
    def get_file(self, file, instance): ...
    def __get__(self, instance, cls: Type | None = ...): ...

class MultipleFileMixin:
    def __init__(self, **kwargs) -> None: ...
    def pre_save(self, model_instance, add): ...
    def get_prep_value(self, value): ...
    def from_db_value(self, value, expression, connection): ...
    def get_internal_type(self): ...

class MultipleFileField(MultipleFileMixin, FileField):
    attr_class = MultipleFieldFile
    descriptor_class = MultipleFileDescriptor
    description: str

class MultipleImageFieldFile(ImageFile, MultipleFieldFile):
    def delete(self, save: bool = ...) -> None: ...

class MultipleImageField(MultipleFileMixin, ImageField):
    attr_class = MultipleImageFieldFile
    descriptor_class = MultipleFileDescriptor
    description: str
    def update_dimension_fields(self, instance, force: bool = ..., *args, **kwargs) -> None: ...

class NamedBinaryFileInJSONField(TextField): ...
class NamedBinaryImageInJSONField(NamedBinaryFileInJSONField): ...
class MultipleNamedBinaryFileInJSONField(TextField): ...
class MultipleNamedBinaryImageInJSONField(MultipleNamedBinaryFileInJSONField): ...
class FkModelField(ForeignKey): ...
class HTMLField(TextField): ...
class WYSIWYGField(TextField): ...
