# Generated by Django 4.2.7 on 2024-01-18 06:49

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sessions', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='WebPushNotificationSubscription',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('type', models.CharField(max_length=200)),
                ('enabled', models.BooleanField(default=False)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_related_name': 'webpush_notification_subscriptions',
            },
        ),
        migrations.CreateModel(
            name='WebPushDeviceSubscription',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('user_id', models.IntegerField(db_index=True)),
                ('endpoint', models.TextField(db_index=True, unique=True)),
                ('language_code', models.CharField(default='en', max_length=24)),
                ('_data', models.BinaryField()),
                ('session', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sessions.session')),
            ],
            options={
                'default_related_name': 'webpush_device_subscriptions',
            },
        ),
        migrations.AddConstraint(
            model_name='webpushnotificationsubscription',
            constraint=models.UniqueConstraint(fields=('user', 'type'), include=('enabled',), name='uniq_user_push_type'),
        ),
    ]
