# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AzureVpcPeeringConnectionArgs', 'AzureVpcPeeringConnection']

@pulumi.input_type
class AzureVpcPeeringConnectionArgs:
    def __init__(__self__, *,
                 azure_subscription_id: pulumi.Input[str],
                 peer_azure_app_id: pulumi.Input[str],
                 peer_azure_tenant_id: pulumi.Input[str],
                 peer_resource_group: pulumi.Input[str],
                 vnet_name: pulumi.Input[str],
                 vpc_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AzureVpcPeeringConnection resource.
        :param pulumi.Input[str] azure_subscription_id: Azure Subscription ID. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_azure_app_id: Azure app registration id in UUID4 form that is allowed to create a peering to the peer vnet. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_azure_tenant_id: Azure tenant id in UUID4 form. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_resource_group: Azure resource group name of the peered VPC. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] vnet_name: Azure Network name. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] vpc_id: The VPC the peering connection belongs to. This property cannot be changed, doing so forces recreation of the resource.
        """
        pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        pulumi.set(__self__, "peer_azure_app_id", peer_azure_app_id)
        pulumi.set(__self__, "peer_azure_tenant_id", peer_azure_tenant_id)
        pulumi.set(__self__, "peer_resource_group", peer_resource_group)
        pulumi.set(__self__, "vnet_name", vnet_name)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> pulumi.Input[str]:
        """
        Azure Subscription ID. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "azure_subscription_id")

    @azure_subscription_id.setter
    def azure_subscription_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "azure_subscription_id", value)

    @property
    @pulumi.getter(name="peerAzureAppId")
    def peer_azure_app_id(self) -> pulumi.Input[str]:
        """
        Azure app registration id in UUID4 form that is allowed to create a peering to the peer vnet. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_app_id")

    @peer_azure_app_id.setter
    def peer_azure_app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_azure_app_id", value)

    @property
    @pulumi.getter(name="peerAzureTenantId")
    def peer_azure_tenant_id(self) -> pulumi.Input[str]:
        """
        Azure tenant id in UUID4 form. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_tenant_id")

    @peer_azure_tenant_id.setter
    def peer_azure_tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_azure_tenant_id", value)

    @property
    @pulumi.getter(name="peerResourceGroup")
    def peer_resource_group(self) -> pulumi.Input[str]:
        """
        Azure resource group name of the peered VPC. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "peer_resource_group")

    @peer_resource_group.setter
    def peer_resource_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_resource_group", value)

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> pulumi.Input[str]:
        """
        Azure Network name. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "vnet_name")

    @vnet_name.setter
    def vnet_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vnet_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The VPC the peering connection belongs to. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _AzureVpcPeeringConnectionState:
    def __init__(__self__, *,
                 azure_subscription_id: Optional[pulumi.Input[str]] = None,
                 peer_azure_app_id: Optional[pulumi.Input[str]] = None,
                 peer_azure_tenant_id: Optional[pulumi.Input[str]] = None,
                 peer_resource_group: Optional[pulumi.Input[str]] = None,
                 peering_connection_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_info: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vnet_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AzureVpcPeeringConnection resources.
        :param pulumi.Input[str] azure_subscription_id: Azure Subscription ID. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_azure_app_id: Azure app registration id in UUID4 form that is allowed to create a peering to the peer vnet. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_azure_tenant_id: Azure tenant id in UUID4 form. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_resource_group: Azure resource group name of the peered VPC. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peering_connection_id: Cloud provider identifier for the peering connection if available
        :param pulumi.Input[str] state: State of the peering connection
        :param pulumi.Input[Mapping[str, Any]] state_info: State-specific help or error information
        :param pulumi.Input[str] vnet_name: Azure Network name. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] vpc_id: The VPC the peering connection belongs to. This property cannot be changed, doing so forces recreation of the resource.
        """
        if azure_subscription_id is not None:
            pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        if peer_azure_app_id is not None:
            pulumi.set(__self__, "peer_azure_app_id", peer_azure_app_id)
        if peer_azure_tenant_id is not None:
            pulumi.set(__self__, "peer_azure_tenant_id", peer_azure_tenant_id)
        if peer_resource_group is not None:
            pulumi.set(__self__, "peer_resource_group", peer_resource_group)
        if peering_connection_id is not None:
            pulumi.set(__self__, "peering_connection_id", peering_connection_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_info is not None:
            pulumi.set(__self__, "state_info", state_info)
        if vnet_name is not None:
            pulumi.set(__self__, "vnet_name", vnet_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Subscription ID. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "azure_subscription_id")

    @azure_subscription_id.setter
    def azure_subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_subscription_id", value)

    @property
    @pulumi.getter(name="peerAzureAppId")
    def peer_azure_app_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure app registration id in UUID4 form that is allowed to create a peering to the peer vnet. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_app_id")

    @peer_azure_app_id.setter
    def peer_azure_app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_azure_app_id", value)

    @property
    @pulumi.getter(name="peerAzureTenantId")
    def peer_azure_tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure tenant id in UUID4 form. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_tenant_id")

    @peer_azure_tenant_id.setter
    def peer_azure_tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_azure_tenant_id", value)

    @property
    @pulumi.getter(name="peerResourceGroup")
    def peer_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Azure resource group name of the peered VPC. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "peer_resource_group")

    @peer_resource_group.setter
    def peer_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_resource_group", value)

    @property
    @pulumi.getter(name="peeringConnectionId")
    def peering_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud provider identifier for the peering connection if available
        """
        return pulumi.get(self, "peering_connection_id")

    @peering_connection_id.setter
    def peering_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_connection_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the peering connection
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateInfo")
    def state_info(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        State-specific help or error information
        """
        return pulumi.get(self, "state_info")

    @state_info.setter
    def state_info(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "state_info", value)

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Network name. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "vnet_name")

    @vnet_name.setter
    def vnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC the peering connection belongs to. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AzureVpcPeeringConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_subscription_id: Optional[pulumi.Input[str]] = None,
                 peer_azure_app_id: Optional[pulumi.Input[str]] = None,
                 peer_azure_tenant_id: Optional[pulumi.Input[str]] = None,
                 peer_resource_group: Optional[pulumi.Input[str]] = None,
                 vnet_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The Azure VPC Peering Connection resource allows the creation and management of Aiven VPC Peering Connections.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        foo = aiven.AzureVpcPeeringConnection("foo",
            vpc_id=data["aiven_project_vpc"]["vpc"]["id"],
            azure_subscription_id="xxxxxx",
            peer_resource_group="my-pr1",
            vnet_name="my-vnet1",
            peer_azure_app_id="xxxxxx",
            peer_azure_tenant_id="xxxxxx")
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/azureVpcPeeringConnection:AzureVpcPeeringConnection foo project_name/vpc_id/azure_subscription_id/vnet_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azure_subscription_id: Azure Subscription ID. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_azure_app_id: Azure app registration id in UUID4 form that is allowed to create a peering to the peer vnet. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_azure_tenant_id: Azure tenant id in UUID4 form. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_resource_group: Azure resource group name of the peered VPC. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] vnet_name: Azure Network name. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] vpc_id: The VPC the peering connection belongs to. This property cannot be changed, doing so forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureVpcPeeringConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Azure VPC Peering Connection resource allows the creation and management of Aiven VPC Peering Connections.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        foo = aiven.AzureVpcPeeringConnection("foo",
            vpc_id=data["aiven_project_vpc"]["vpc"]["id"],
            azure_subscription_id="xxxxxx",
            peer_resource_group="my-pr1",
            vnet_name="my-vnet1",
            peer_azure_app_id="xxxxxx",
            peer_azure_tenant_id="xxxxxx")
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/azureVpcPeeringConnection:AzureVpcPeeringConnection foo project_name/vpc_id/azure_subscription_id/vnet_name
        ```

        :param str resource_name: The name of the resource.
        :param AzureVpcPeeringConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureVpcPeeringConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_subscription_id: Optional[pulumi.Input[str]] = None,
                 peer_azure_app_id: Optional[pulumi.Input[str]] = None,
                 peer_azure_tenant_id: Optional[pulumi.Input[str]] = None,
                 peer_resource_group: Optional[pulumi.Input[str]] = None,
                 vnet_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureVpcPeeringConnectionArgs.__new__(AzureVpcPeeringConnectionArgs)

            if azure_subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'azure_subscription_id'")
            __props__.__dict__["azure_subscription_id"] = azure_subscription_id
            if peer_azure_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_azure_app_id'")
            __props__.__dict__["peer_azure_app_id"] = peer_azure_app_id
            if peer_azure_tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_azure_tenant_id'")
            __props__.__dict__["peer_azure_tenant_id"] = peer_azure_tenant_id
            if peer_resource_group is None and not opts.urn:
                raise TypeError("Missing required property 'peer_resource_group'")
            __props__.__dict__["peer_resource_group"] = peer_resource_group
            if vnet_name is None and not opts.urn:
                raise TypeError("Missing required property 'vnet_name'")
            __props__.__dict__["vnet_name"] = vnet_name
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["peering_connection_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_info"] = None
        super(AzureVpcPeeringConnection, __self__).__init__(
            'aiven:index/azureVpcPeeringConnection:AzureVpcPeeringConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_subscription_id: Optional[pulumi.Input[str]] = None,
            peer_azure_app_id: Optional[pulumi.Input[str]] = None,
            peer_azure_tenant_id: Optional[pulumi.Input[str]] = None,
            peer_resource_group: Optional[pulumi.Input[str]] = None,
            peering_connection_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            state_info: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            vnet_name: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AzureVpcPeeringConnection':
        """
        Get an existing AzureVpcPeeringConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azure_subscription_id: Azure Subscription ID. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_azure_app_id: Azure app registration id in UUID4 form that is allowed to create a peering to the peer vnet. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_azure_tenant_id: Azure tenant id in UUID4 form. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peer_resource_group: Azure resource group name of the peered VPC. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] peering_connection_id: Cloud provider identifier for the peering connection if available
        :param pulumi.Input[str] state: State of the peering connection
        :param pulumi.Input[Mapping[str, Any]] state_info: State-specific help or error information
        :param pulumi.Input[str] vnet_name: Azure Network name. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] vpc_id: The VPC the peering connection belongs to. This property cannot be changed, doing so forces recreation of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureVpcPeeringConnectionState.__new__(_AzureVpcPeeringConnectionState)

        __props__.__dict__["azure_subscription_id"] = azure_subscription_id
        __props__.__dict__["peer_azure_app_id"] = peer_azure_app_id
        __props__.__dict__["peer_azure_tenant_id"] = peer_azure_tenant_id
        __props__.__dict__["peer_resource_group"] = peer_resource_group
        __props__.__dict__["peering_connection_id"] = peering_connection_id
        __props__.__dict__["state"] = state
        __props__.__dict__["state_info"] = state_info
        __props__.__dict__["vnet_name"] = vnet_name
        __props__.__dict__["vpc_id"] = vpc_id
        return AzureVpcPeeringConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> pulumi.Output[str]:
        """
        Azure Subscription ID. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "azure_subscription_id")

    @property
    @pulumi.getter(name="peerAzureAppId")
    def peer_azure_app_id(self) -> pulumi.Output[str]:
        """
        Azure app registration id in UUID4 form that is allowed to create a peering to the peer vnet. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_app_id")

    @property
    @pulumi.getter(name="peerAzureTenantId")
    def peer_azure_tenant_id(self) -> pulumi.Output[str]:
        """
        Azure tenant id in UUID4 form. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_tenant_id")

    @property
    @pulumi.getter(name="peerResourceGroup")
    def peer_resource_group(self) -> pulumi.Output[str]:
        """
        Azure resource group name of the peered VPC. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "peer_resource_group")

    @property
    @pulumi.getter(name="peeringConnectionId")
    def peering_connection_id(self) -> pulumi.Output[str]:
        """
        Cloud provider identifier for the peering connection if available
        """
        return pulumi.get(self, "peering_connection_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the peering connection
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInfo")
    def state_info(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        State-specific help or error information
        """
        return pulumi.get(self, "state_info")

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> pulumi.Output[str]:
        """
        Azure Network name. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "vnet_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC the peering connection belongs to. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "vpc_id")

