# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FlinkApplicationDeploymentArgs', 'FlinkApplicationDeployment']

@pulumi.input_type
class FlinkApplicationDeploymentArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[str],
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 version_id: pulumi.Input[str],
                 parallelism: Optional[pulumi.Input[int]] = None,
                 restart_enabled: Optional[pulumi.Input[bool]] = None,
                 starting_savepoint: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FlinkApplicationDeployment resource.
        :param pulumi.Input[str] application_id: Application ID
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] version_id: ApplicationVersion ID
        :param pulumi.Input[int] parallelism: Flink Job parallelism
        :param pulumi.Input[bool] restart_enabled: Specifies whether a Flink Job is restarted in case it fails
        :param pulumi.Input[str] starting_savepoint: Job savepoint
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "version_id", version_id)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if restart_enabled is not None:
            pulumi.set(__self__, "restart_enabled", restart_enabled)
        if starting_savepoint is not None:
            pulumi.set(__self__, "starting_savepoint", starting_savepoint)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        Application ID
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
        variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Input[str]:
        """
        ApplicationVersion ID
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        Flink Job parallelism
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallelism", value)

    @property
    @pulumi.getter(name="restartEnabled")
    def restart_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether a Flink Job is restarted in case it fails
        """
        return pulumi.get(self, "restart_enabled")

    @restart_enabled.setter
    def restart_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restart_enabled", value)

    @property
    @pulumi.getter(name="startingSavepoint")
    def starting_savepoint(self) -> Optional[pulumi.Input[str]]:
        """
        Job savepoint
        """
        return pulumi.get(self, "starting_savepoint")

    @starting_savepoint.setter
    def starting_savepoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "starting_savepoint", value)


@pulumi.input_type
class _FlinkApplicationDeploymentState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 parallelism: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 restart_enabled: Optional[pulumi.Input[bool]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 starting_savepoint: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FlinkApplicationDeployment resources.
        :param pulumi.Input[str] application_id: Application ID
        :param pulumi.Input[str] created_at: Application deployment creation time
        :param pulumi.Input[str] created_by: Application deployment creator
        :param pulumi.Input[int] parallelism: Flink Job parallelism
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[bool] restart_enabled: Specifies whether a Flink Job is restarted in case it fails
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] starting_savepoint: Job savepoint
        :param pulumi.Input[str] version_id: ApplicationVersion ID
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if restart_enabled is not None:
            pulumi.set(__self__, "restart_enabled", restart_enabled)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if starting_savepoint is not None:
            pulumi.set(__self__, "starting_savepoint", starting_savepoint)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Application ID
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Application deployment creation time
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        Application deployment creator
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        Flink Job parallelism
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallelism", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="restartEnabled")
    def restart_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether a Flink Job is restarted in case it fails
        """
        return pulumi.get(self, "restart_enabled")

    @restart_enabled.setter
    def restart_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restart_enabled", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
        variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="startingSavepoint")
    def starting_savepoint(self) -> Optional[pulumi.Input[str]]:
        """
        Job savepoint
        """
        return pulumi.get(self, "starting_savepoint")

    @starting_savepoint.setter
    def starting_savepoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "starting_savepoint", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        ApplicationVersion ID
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)


class FlinkApplicationDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 parallelism: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 restart_enabled: Optional[pulumi.Input[bool]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 starting_savepoint: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a FlinkApplicationDeployment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: Application ID
        :param pulumi.Input[int] parallelism: Flink Job parallelism
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[bool] restart_enabled: Specifies whether a Flink Job is restarted in case it fails
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] starting_savepoint: Job savepoint
        :param pulumi.Input[str] version_id: ApplicationVersion ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlinkApplicationDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a FlinkApplicationDeployment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param FlinkApplicationDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlinkApplicationDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 parallelism: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 restart_enabled: Optional[pulumi.Input[bool]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 starting_savepoint: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlinkApplicationDeploymentArgs.__new__(FlinkApplicationDeploymentArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["parallelism"] = parallelism
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["restart_enabled"] = restart_enabled
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["starting_savepoint"] = starting_savepoint
            if version_id is None and not opts.urn:
                raise TypeError("Missing required property 'version_id'")
            __props__.__dict__["version_id"] = version_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
        super(FlinkApplicationDeployment, __self__).__init__(
            'aiven:index/flinkApplicationDeployment:FlinkApplicationDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            parallelism: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            restart_enabled: Optional[pulumi.Input[bool]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            starting_savepoint: Optional[pulumi.Input[str]] = None,
            version_id: Optional[pulumi.Input[str]] = None) -> 'FlinkApplicationDeployment':
        """
        Get an existing FlinkApplicationDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: Application ID
        :param pulumi.Input[str] created_at: Application deployment creation time
        :param pulumi.Input[str] created_by: Application deployment creator
        :param pulumi.Input[int] parallelism: Flink Job parallelism
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
               reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[bool] restart_enabled: Specifies whether a Flink Job is restarted in case it fails
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
               variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] starting_savepoint: Job savepoint
        :param pulumi.Input[str] version_id: ApplicationVersion ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlinkApplicationDeploymentState.__new__(_FlinkApplicationDeploymentState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["parallelism"] = parallelism
        __props__.__dict__["project"] = project
        __props__.__dict__["restart_enabled"] = restart_enabled
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["starting_savepoint"] = starting_savepoint
        __props__.__dict__["version_id"] = version_id
        return FlinkApplicationDeployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[str]:
        """
        Application ID
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Application deployment creation time
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        Application deployment creator
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def parallelism(self) -> pulumi.Output[Optional[int]]:
        """
        Flink Job parallelism
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a
        reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="restartEnabled")
    def restart_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether a Flink Job is restarted in case it fails
        """
        return pulumi.get(self, "restart_enabled")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this
        variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="startingSavepoint")
    def starting_savepoint(self) -> pulumi.Output[Optional[str]]:
        """
        Job savepoint
        """
        return pulumi.get(self, "starting_savepoint")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[str]:
        """
        ApplicationVersion ID
        """
        return pulumi.get(self, "version_id")

