# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAzurePrivatelinkResult',
    'AwaitableGetAzurePrivatelinkResult',
    'get_azure_privatelink',
    'get_azure_privatelink_output',
]

@pulumi.output_type
class GetAzurePrivatelinkResult:
    """
    A collection of values returned by getAzurePrivatelink.
    """
    def __init__(__self__, azure_service_alias=None, azure_service_id=None, id=None, message=None, project=None, service_name=None, state=None, user_subscription_ids=None):
        if azure_service_alias and not isinstance(azure_service_alias, str):
            raise TypeError("Expected argument 'azure_service_alias' to be a str")
        pulumi.set(__self__, "azure_service_alias", azure_service_alias)
        if azure_service_id and not isinstance(azure_service_id, str):
            raise TypeError("Expected argument 'azure_service_id' to be a str")
        pulumi.set(__self__, "azure_service_id", azure_service_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if user_subscription_ids and not isinstance(user_subscription_ids, list):
            raise TypeError("Expected argument 'user_subscription_ids' to be a list")
        pulumi.set(__self__, "user_subscription_ids", user_subscription_ids)

    @property
    @pulumi.getter(name="azureServiceAlias")
    def azure_service_alias(self) -> str:
        """
        Azure Privatelink service alias
        """
        return pulumi.get(self, "azure_service_alias")

    @property
    @pulumi.getter(name="azureServiceId")
    def azure_service_id(self) -> str:
        """
        Azure Privatelink service ID
        """
        return pulumi.get(self, "azure_service_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Printable result of the Azure Privatelink request
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Privatelink resource state
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="userSubscriptionIds")
    def user_subscription_ids(self) -> Sequence[str]:
        """
        A List of allowed Subscription IDs. Maximum length: `16`.
        """
        return pulumi.get(self, "user_subscription_ids")


class AwaitableGetAzurePrivatelinkResult(GetAzurePrivatelinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAzurePrivatelinkResult(
            azure_service_alias=self.azure_service_alias,
            azure_service_id=self.azure_service_id,
            id=self.id,
            message=self.message,
            project=self.project,
            service_name=self.service_name,
            state=self.state,
            user_subscription_ids=self.user_subscription_ids)


def get_azure_privatelink(project: Optional[str] = None,
                          service_name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAzurePrivatelinkResult:
    """
    The Azure Privatelink resource allows the creation and management of Aiven Azure Privatelink for a services.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    foo = aiven.get_azure_privatelink(project=data["aiven_project"]["foo"]["project"],
        service_name=aiven_kafka["bar"]["service_name"])
    ```


    :param str project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getAzurePrivatelink:getAzurePrivatelink', __args__, opts=opts, typ=GetAzurePrivatelinkResult).value

    return AwaitableGetAzurePrivatelinkResult(
        azure_service_alias=pulumi.get(__ret__, 'azure_service_alias'),
        azure_service_id=pulumi.get(__ret__, 'azure_service_id'),
        id=pulumi.get(__ret__, 'id'),
        message=pulumi.get(__ret__, 'message'),
        project=pulumi.get(__ret__, 'project'),
        service_name=pulumi.get(__ret__, 'service_name'),
        state=pulumi.get(__ret__, 'state'),
        user_subscription_ids=pulumi.get(__ret__, 'user_subscription_ids'))


@_utilities.lift_output_func(get_azure_privatelink)
def get_azure_privatelink_output(project: Optional[pulumi.Input[str]] = None,
                                 service_name: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAzurePrivatelinkResult]:
    """
    The Azure Privatelink resource allows the creation and management of Aiven Azure Privatelink for a services.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    foo = aiven.get_azure_privatelink(project=data["aiven_project"]["foo"]["project"],
        service_name=aiven_kafka["bar"]["service_name"])
    ```


    :param str project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    """
    ...
