# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, account_id=None, add_account_owners_admin_access=None, available_credits=None, billing_group=None, ca_cert=None, copy_from_project=None, default_cloud=None, estimated_balance=None, id=None, payment_method=None, project=None, tags=None, technical_emails=None, use_source_project_billing_group=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if add_account_owners_admin_access and not isinstance(add_account_owners_admin_access, bool):
            raise TypeError("Expected argument 'add_account_owners_admin_access' to be a bool")
        pulumi.set(__self__, "add_account_owners_admin_access", add_account_owners_admin_access)
        if available_credits and not isinstance(available_credits, str):
            raise TypeError("Expected argument 'available_credits' to be a str")
        pulumi.set(__self__, "available_credits", available_credits)
        if billing_group and not isinstance(billing_group, str):
            raise TypeError("Expected argument 'billing_group' to be a str")
        pulumi.set(__self__, "billing_group", billing_group)
        if ca_cert and not isinstance(ca_cert, str):
            raise TypeError("Expected argument 'ca_cert' to be a str")
        pulumi.set(__self__, "ca_cert", ca_cert)
        if copy_from_project and not isinstance(copy_from_project, str):
            raise TypeError("Expected argument 'copy_from_project' to be a str")
        pulumi.set(__self__, "copy_from_project", copy_from_project)
        if default_cloud and not isinstance(default_cloud, str):
            raise TypeError("Expected argument 'default_cloud' to be a str")
        pulumi.set(__self__, "default_cloud", default_cloud)
        if estimated_balance and not isinstance(estimated_balance, str):
            raise TypeError("Expected argument 'estimated_balance' to be a str")
        pulumi.set(__self__, "estimated_balance", estimated_balance)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if payment_method and not isinstance(payment_method, str):
            raise TypeError("Expected argument 'payment_method' to be a str")
        pulumi.set(__self__, "payment_method", payment_method)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if technical_emails and not isinstance(technical_emails, list):
            raise TypeError("Expected argument 'technical_emails' to be a list")
        pulumi.set(__self__, "technical_emails", technical_emails)
        if use_source_project_billing_group and not isinstance(use_source_project_billing_group, bool):
            raise TypeError("Expected argument 'use_source_project_billing_group' to be a bool")
        pulumi.set(__self__, "use_source_project_billing_group", use_source_project_billing_group)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        An optional property to link a project to already an existing account by using account ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="addAccountOwnersAdminAccess")
    def add_account_owners_admin_access(self) -> bool:
        """
        If account_id is set, grant account owner team admin access to the new project. The default value is `true`.
        """
        return pulumi.get(self, "add_account_owners_admin_access")

    @property
    @pulumi.getter(name="availableCredits")
    def available_credits(self) -> str:
        """
        The amount of platform credits available to the project. This could be your free trial or other promotional credits.
        """
        return pulumi.get(self, "available_credits")

    @property
    @pulumi.getter(name="billingGroup")
    def billing_group(self) -> str:
        """
        The id of the billing group that is linked to this project. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "billing_group")

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> str:
        """
        The CA certificate of the project. This is required for configuring clients that connect to certain services like Kafka.
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter(name="copyFromProject")
    def copy_from_project(self) -> str:
        """
        is the name of another project used to copy billing information and some other project attributes like technical contacts from. This is mostly relevant when an existing project has billing type set to invoice and that needs to be copied over to a new project. (Setting billing is otherwise not allowed over the API.) This only has effect when the project is created. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "copy_from_project")

    @property
    @pulumi.getter(name="defaultCloud")
    def default_cloud(self) -> str:
        """
        Defines the default cloud provider and region where services are hosted. This can be changed freely after the project is created. This will not affect existing services.
        """
        return pulumi.get(self, "default_cloud")

    @property
    @pulumi.getter(name="estimatedBalance")
    def estimated_balance(self) -> str:
        """
        The current accumulated bill for this project in the current billing period.
        """
        return pulumi.get(self, "estimated_balance")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> str:
        """
        The method of invoicing used for payments for this project, e.g. `card`.
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Defines the name of the project. Name must be globally unique (between all Aiven customers) and cannot be changed later without destroying and re-creating the project, including all sub-resources.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetProjectTagResult']:
        """
        Tags are key-value pairs that allow you to categorize projects.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> Sequence[str]:
        """
        Defines the email addresses that will receive alerts about upcoming maintenance updates or warnings about service instability. It is  good practice to keep this up-to-date to be aware of any potential issues with your project.
        """
        return pulumi.get(self, "technical_emails")

    @property
    @pulumi.getter(name="useSourceProjectBillingGroup")
    def use_source_project_billing_group(self) -> bool:
        """
        Use the same billing group that is used in source project.
        """
        return pulumi.get(self, "use_source_project_billing_group")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            account_id=self.account_id,
            add_account_owners_admin_access=self.add_account_owners_admin_access,
            available_credits=self.available_credits,
            billing_group=self.billing_group,
            ca_cert=self.ca_cert,
            copy_from_project=self.copy_from_project,
            default_cloud=self.default_cloud,
            estimated_balance=self.estimated_balance,
            id=self.id,
            payment_method=self.payment_method,
            project=self.project,
            tags=self.tags,
            technical_emails=self.technical_emails,
            use_source_project_billing_group=self.use_source_project_billing_group)


def get_project(project: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    The Project data source provides information about the existing Aiven Project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myproject = aiven.get_project(project="<PROJECT_NAME>")
    ```


    :param str project: Defines the name of the project. Name must be globally unique (between all Aiven customers) and cannot be changed later without destroying and re-creating the project, including all sub-resources.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        add_account_owners_admin_access=pulumi.get(__ret__, 'add_account_owners_admin_access'),
        available_credits=pulumi.get(__ret__, 'available_credits'),
        billing_group=pulumi.get(__ret__, 'billing_group'),
        ca_cert=pulumi.get(__ret__, 'ca_cert'),
        copy_from_project=pulumi.get(__ret__, 'copy_from_project'),
        default_cloud=pulumi.get(__ret__, 'default_cloud'),
        estimated_balance=pulumi.get(__ret__, 'estimated_balance'),
        id=pulumi.get(__ret__, 'id'),
        payment_method=pulumi.get(__ret__, 'payment_method'),
        project=pulumi.get(__ret__, 'project'),
        tags=pulumi.get(__ret__, 'tags'),
        technical_emails=pulumi.get(__ret__, 'technical_emails'),
        use_source_project_billing_group=pulumi.get(__ret__, 'use_source_project_billing_group'))


@_utilities.lift_output_func(get_project)
def get_project_output(project: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectResult]:
    """
    The Project data source provides information about the existing Aiven Project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myproject = aiven.get_project(project="<PROJECT_NAME>")
    ```


    :param str project: Defines the name of the project. Name must be globally unique (between all Aiven customers) and cannot be changed later without destroying and re-creating the project, including all sub-resources.
    """
    ...
