# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetProjectVpcResult',
    'AwaitableGetProjectVpcResult',
    'get_project_vpc',
    'get_project_vpc_output',
]

@pulumi.output_type
class GetProjectVpcResult:
    """
    A collection of values returned by getProjectVpc.
    """
    def __init__(__self__, cloud_name=None, id=None, network_cidr=None, project=None, state=None, vpc_id=None):
        if cloud_name and not isinstance(cloud_name, str):
            raise TypeError("Expected argument 'cloud_name' to be a str")
        pulumi.set(__self__, "cloud_name", cloud_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_cidr and not isinstance(network_cidr, str):
            raise TypeError("Expected argument 'network_cidr' to be a str")
        pulumi.set(__self__, "network_cidr", network_cidr)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[str]:
        """
        Defines where the cloud provider and region where the service is hosted in. See the Service resource for additional information.
        """
        return pulumi.get(self, "cloud_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkCidr")
    def network_cidr(self) -> str:
        """
        Network address range used by the VPC like 192.168.0.0/24
        """
        return pulumi.get(self, "network_cidr")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        """
        Identifies the project this resource belongs to.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the VPC. The possible values are `APPROVED`, `ACTIVE`, `DELETING` and `DELETED`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        ID of the VPC. This can be used to filter out the specific VPC if there are more than one datasource returned.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetProjectVpcResult(GetProjectVpcResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectVpcResult(
            cloud_name=self.cloud_name,
            id=self.id,
            network_cidr=self.network_cidr,
            project=self.project,
            state=self.state,
            vpc_id=self.vpc_id)


def get_project_vpc(cloud_name: Optional[str] = None,
                    project: Optional[str] = None,
                    vpc_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectVpcResult:
    """
    The Project VPC data source provides information about the existing Aiven Project VPC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myvpc = aiven.get_project_vpc(project=aiven_project["myproject"]["project"],
        cloud_name="google-europe-west1")
    myvpc_id = aiven.get_project_vpc(vpc_id=aiven_project_vpc["vpc"]["id"])
    ```


    :param str cloud_name: Defines where the cloud provider and region where the service is hosted in. See the Service resource for additional information.
    :param str project: Identifies the project this resource belongs to.
    :param str vpc_id: ID of the VPC. This can be used to filter out the specific VPC if there are more than one datasource returned.
    """
    __args__ = dict()
    __args__['cloudName'] = cloud_name
    __args__['project'] = project
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getProjectVpc:getProjectVpc', __args__, opts=opts, typ=GetProjectVpcResult).value

    return AwaitableGetProjectVpcResult(
        cloud_name=pulumi.get(__ret__, 'cloud_name'),
        id=pulumi.get(__ret__, 'id'),
        network_cidr=pulumi.get(__ret__, 'network_cidr'),
        project=pulumi.get(__ret__, 'project'),
        state=pulumi.get(__ret__, 'state'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))


@_utilities.lift_output_func(get_project_vpc)
def get_project_vpc_output(cloud_name: Optional[pulumi.Input[Optional[str]]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectVpcResult]:
    """
    The Project VPC data source provides information about the existing Aiven Project VPC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myvpc = aiven.get_project_vpc(project=aiven_project["myproject"]["project"],
        cloud_name="google-europe-west1")
    myvpc_id = aiven.get_project_vpc(vpc_id=aiven_project_vpc["vpc"]["id"])
    ```


    :param str cloud_name: Defines where the cloud provider and region where the service is hosted in. See the Service resource for additional information.
    :param str project: Identifies the project this resource belongs to.
    :param str vpc_id: ID of the VPC. This can be used to filter out the specific VPC if there are more than one datasource returned.
    """
    ...
