# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetTransitGatewayVpcAttachmentResult',
    'AwaitableGetTransitGatewayVpcAttachmentResult',
    'get_transit_gateway_vpc_attachment',
    'get_transit_gateway_vpc_attachment_output',
]

@pulumi.output_type
class GetTransitGatewayVpcAttachmentResult:
    """
    A collection of values returned by getTransitGatewayVpcAttachment.
    """
    def __init__(__self__, id=None, peer_cloud_account=None, peer_region=None, peer_vpc=None, peering_connection_id=None, state=None, state_info=None, user_peer_network_cidrs=None, vpc_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if peer_cloud_account and not isinstance(peer_cloud_account, str):
            raise TypeError("Expected argument 'peer_cloud_account' to be a str")
        pulumi.set(__self__, "peer_cloud_account", peer_cloud_account)
        if peer_region and not isinstance(peer_region, str):
            raise TypeError("Expected argument 'peer_region' to be a str")
        pulumi.set(__self__, "peer_region", peer_region)
        if peer_vpc and not isinstance(peer_vpc, str):
            raise TypeError("Expected argument 'peer_vpc' to be a str")
        pulumi.set(__self__, "peer_vpc", peer_vpc)
        if peering_connection_id and not isinstance(peering_connection_id, str):
            raise TypeError("Expected argument 'peering_connection_id' to be a str")
        pulumi.set(__self__, "peering_connection_id", peering_connection_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_info and not isinstance(state_info, dict):
            raise TypeError("Expected argument 'state_info' to be a dict")
        pulumi.set(__self__, "state_info", state_info)
        if user_peer_network_cidrs and not isinstance(user_peer_network_cidrs, list):
            raise TypeError("Expected argument 'user_peer_network_cidrs' to be a list")
        pulumi.set(__self__, "user_peer_network_cidrs", user_peer_network_cidrs)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="peerCloudAccount")
    def peer_cloud_account(self) -> str:
        """
        AWS account ID or GCP project ID of the peered VPC. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "peer_cloud_account")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> str:
        """
        AWS region of the peered VPC (if not in the same region as Aiven VPC)
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter(name="peerVpc")
    def peer_vpc(self) -> str:
        """
        Transit gateway ID. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "peer_vpc")

    @property
    @pulumi.getter(name="peeringConnectionId")
    def peering_connection_id(self) -> str:
        """
        Cloud provider identifier for the peering connection if available
        """
        return pulumi.get(self, "peering_connection_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the peering connection
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInfo")
    def state_info(self) -> Mapping[str, Any]:
        """
        State-specific help or error information
        """
        return pulumi.get(self, "state_info")

    @property
    @pulumi.getter(name="userPeerNetworkCidrs")
    def user_peer_network_cidrs(self) -> Sequence[str]:
        """
        List of private IPv4 ranges to route through the peering connection
        """
        return pulumi.get(self, "user_peer_network_cidrs")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The VPC the peering connection belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetTransitGatewayVpcAttachmentResult(GetTransitGatewayVpcAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransitGatewayVpcAttachmentResult(
            id=self.id,
            peer_cloud_account=self.peer_cloud_account,
            peer_region=self.peer_region,
            peer_vpc=self.peer_vpc,
            peering_connection_id=self.peering_connection_id,
            state=self.state,
            state_info=self.state_info,
            user_peer_network_cidrs=self.user_peer_network_cidrs,
            vpc_id=self.vpc_id)


def get_transit_gateway_vpc_attachment(peer_cloud_account: Optional[str] = None,
                                       peer_vpc: Optional[str] = None,
                                       vpc_id: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransitGatewayVpcAttachmentResult:
    """
    The Transit Gateway VPC Attachment resource allows the creation and management Transit Gateway VPC Attachment VPC peering connection between Aiven and AWS.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    attachment = aiven.get_transit_gateway_vpc_attachment(vpc_id=aiven_project_vpc["bar"]["id"],
        peer_cloud_account="<PEER_ACCOUNT_ID>",
        peer_vpc="google-project1")
    ```


    :param str peer_cloud_account: AWS account ID or GCP project ID of the peered VPC. This property cannot be changed, doing so forces recreation of the resource.
    :param str peer_vpc: Transit gateway ID. This property cannot be changed, doing so forces recreation of the resource.
    :param str vpc_id: The VPC the peering connection belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    """
    __args__ = dict()
    __args__['peerCloudAccount'] = peer_cloud_account
    __args__['peerVpc'] = peer_vpc
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getTransitGatewayVpcAttachment:getTransitGatewayVpcAttachment', __args__, opts=opts, typ=GetTransitGatewayVpcAttachmentResult).value

    return AwaitableGetTransitGatewayVpcAttachmentResult(
        id=pulumi.get(__ret__, 'id'),
        peer_cloud_account=pulumi.get(__ret__, 'peer_cloud_account'),
        peer_region=pulumi.get(__ret__, 'peer_region'),
        peer_vpc=pulumi.get(__ret__, 'peer_vpc'),
        peering_connection_id=pulumi.get(__ret__, 'peering_connection_id'),
        state=pulumi.get(__ret__, 'state'),
        state_info=pulumi.get(__ret__, 'state_info'),
        user_peer_network_cidrs=pulumi.get(__ret__, 'user_peer_network_cidrs'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))


@_utilities.lift_output_func(get_transit_gateway_vpc_attachment)
def get_transit_gateway_vpc_attachment_output(peer_cloud_account: Optional[pulumi.Input[str]] = None,
                                              peer_vpc: Optional[pulumi.Input[str]] = None,
                                              vpc_id: Optional[pulumi.Input[str]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTransitGatewayVpcAttachmentResult]:
    """
    The Transit Gateway VPC Attachment resource allows the creation and management Transit Gateway VPC Attachment VPC peering connection between Aiven and AWS.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    attachment = aiven.get_transit_gateway_vpc_attachment(vpc_id=aiven_project_vpc["bar"]["id"],
        peer_cloud_account="<PEER_ACCOUNT_ID>",
        peer_vpc="google-project1")
    ```


    :param str peer_cloud_account: AWS account ID or GCP project ID of the peered VPC. This property cannot be changed, doing so forces recreation of the resource.
    :param str peer_vpc: Transit gateway ID. This property cannot be changed, doing so forces recreation of the resource.
    :param str vpc_id: The VPC the peering connection belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    """
    ...
