# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.dashboard import Dashboard
from ..types.react_grid_layout_config import ReactGridLayoutConfig
from ..types.unified_dashboard_response import UnifiedDashboardResponse
from .raw_client import AsyncRawDashboardsClient, RawDashboardsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DashboardsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDashboardsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDashboardsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDashboardsClient
        """
        return self._raw_client

    def list_dashboards(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[Dashboard]:
        """
        List all dashboards for the authenticated user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Dashboard]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.dashboards.list_dashboards()
        """
        _response = self._raw_client.list_dashboards(request_options=request_options)
        return _response.data

    def create_dashboard(
        self,
        *,
        name: str,
        components: typing.Optional[typing.Sequence[str]] = OMIT,
        react_grid_layout_config: typing.Optional[ReactGridLayoutConfig] = OMIT,
        component_state: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Dashboard:
        """
        Create a new dashboard.

        Parameters
        ----------
        name : str

        components : typing.Optional[typing.Sequence[str]]

        react_grid_layout_config : typing.Optional[ReactGridLayoutConfig]

        component_state : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dashboard
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.dashboards.create_dashboard(
            name="name",
        )
        """
        _response = self._raw_client.create_dashboard(
            name=name,
            components=components,
            react_grid_layout_config=react_grid_layout_config,
            component_state=component_state,
            request_options=request_options,
        )
        return _response.data

    def get_dashboard(self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Dashboard:
        """
        Retrieve a single dashboard.

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dashboard
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.dashboards.get_dashboard(
            dashboard_id="dashboard_id",
        )
        """
        _response = self._raw_client.get_dashboard(dashboard_id, request_options=request_options)
        return _response.data

    def update_dashboard_layout(
        self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> str:
        """
        Update a dashboard's layout and component state.

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.dashboards.update_dashboard_layout(
            dashboard_id="dashboard_id",
        )
        """
        _response = self._raw_client.update_dashboard_layout(dashboard_id, request_options=request_options)
        return _response.data

    def delete_dashboard(
        self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete a dashboard.

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.dashboards.delete_dashboard(
            dashboard_id="dashboard_id",
        )
        """
        _response = self._raw_client.delete_dashboard(dashboard_id, request_options=request_options)
        return _response.data

    def get_dashboard_full(
        self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> UnifiedDashboardResponse:
        """
        Retrieve a dashboard with all its components, layers, and datasets in a single request.

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UnifiedDashboardResponse
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.dashboards.get_dashboard_full(
            dashboard_id="dashboard_id",
        )
        """
        _response = self._raw_client.get_dashboard_full(dashboard_id, request_options=request_options)
        return _response.data


class AsyncDashboardsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDashboardsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDashboardsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDashboardsClient
        """
        return self._raw_client

    async def list_dashboards(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Dashboard]:
        """
        List all dashboards for the authenticated user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Dashboard]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.dashboards.list_dashboards()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_dashboards(request_options=request_options)
        return _response.data

    async def create_dashboard(
        self,
        *,
        name: str,
        components: typing.Optional[typing.Sequence[str]] = OMIT,
        react_grid_layout_config: typing.Optional[ReactGridLayoutConfig] = OMIT,
        component_state: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Dashboard:
        """
        Create a new dashboard.

        Parameters
        ----------
        name : str

        components : typing.Optional[typing.Sequence[str]]

        react_grid_layout_config : typing.Optional[ReactGridLayoutConfig]

        component_state : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dashboard
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.dashboards.create_dashboard(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_dashboard(
            name=name,
            components=components,
            react_grid_layout_config=react_grid_layout_config,
            component_state=component_state,
            request_options=request_options,
        )
        return _response.data

    async def get_dashboard(
        self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Dashboard:
        """
        Retrieve a single dashboard.

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Dashboard
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.dashboards.get_dashboard(
                dashboard_id="dashboard_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_dashboard(dashboard_id, request_options=request_options)
        return _response.data

    async def update_dashboard_layout(
        self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> str:
        """
        Update a dashboard's layout and component state.

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.dashboards.update_dashboard_layout(
                dashboard_id="dashboard_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_dashboard_layout(dashboard_id, request_options=request_options)
        return _response.data

    async def delete_dashboard(
        self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete a dashboard.

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.dashboards.delete_dashboard(
                dashboard_id="dashboard_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_dashboard(dashboard_id, request_options=request_options)
        return _response.data

    async def get_dashboard_full(
        self, dashboard_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> UnifiedDashboardResponse:
        """
        Retrieve a dashboard with all its components, layers, and datasets in a single request.

        Parameters
        ----------
        dashboard_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UnifiedDashboardResponse
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.dashboards.get_dashboard_full(
                dashboard_id="dashboard_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_dashboard_full(dashboard_id, request_options=request_options)
        return _response.data
