# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .layout import Layout
from .react_grid_layout_config import ReactGridLayoutConfig


class Dashboard(UniversalBaseModel):
    id: typing.Optional[str] = None
    name: str
    user_id: typing_extensions.Annotated[str, FieldMetadata(alias="userId")]
    layout: typing.Optional[typing.List[Layout]] = pydantic.Field(default=None)
    """
    Single layout array for all components
    """

    react_grid_layout_config: typing_extensions.Annotated[
        typing.Optional[ReactGridLayoutConfig], FieldMetadata(alias="reactGridLayoutConfig")
    ] = None
    components: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of all component IDs on this dashboard.
    """

    component_state: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="componentState")
    ] = pydantic.Field(default=None)
    """
    Component-specific state like layer ordering, stored as JSON
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
