# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class Layout(UniversalBaseModel):
    """
    Represents a single item in a react-grid-layout.
    """

    i: str = pydantic.Field()
    """
    The ID of the component to render in this item.
    """

    x: int
    y: int
    w: int
    h: int
    min_w: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="minW")] = None
    max_w: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="maxW")] = None
    min_h: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="minH")] = None
    max_h: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="maxH")] = None
    static: typing.Optional[bool] = None
    is_draggable: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isDraggable")] = None
    is_resizable: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isResizable")] = None
    is_bounded: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isBounded")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
