# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .ui_control_config_data_type import UiControlConfigDataType
from .ui_control_type import UiControlType


class UiControlConfig(UniversalBaseModel):
    """
    Configuration for a single UI control that can modify layer properties.
    """

    property: str = pydantic.Field()
    """
    Target DeckGL property name to modify, e.g., 'getFillColor', 'getRadius'
    """

    type: UiControlType = pydantic.Field()
    """
    Type of UI control to render
    """

    default: typing.Optional[typing.Any] = None
    options: typing.Optional[typing.List[typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Available options for dropdown/colorScheme/dataColumn types
    """

    range: typing.Optional[typing.List[float]] = pydantic.Field(default=None)
    """
    Min/max values for slider type [min, max]
    """

    label: typing.Optional[str] = pydantic.Field(default=None)
    """
    Display label for the control
    """

    data_type: typing_extensions.Annotated[
        typing.Optional[UiControlConfigDataType], FieldMetadata(alias="dataType")
    ] = pydantic.Field(default=None)
    """
    Expected data type for dataColumn controls
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
