# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .ui_config import UiConfig
from .weather_layer_type import WeatherLayerType


class WeatherLayer(UniversalBaseModel):
    """
    Weather-specific layer with meteorological data visualization.
    """

    id: typing.Optional[str] = None
    user_id: typing_extensions.Annotated[str, FieldMetadata(alias="userId")]
    name: str = pydantic.Field()
    """
    User-defined name for the layer, e.g., 'Danish Wind Turbines'.
    """

    deckgl_props: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="deckglProps")
    ] = pydantic.Field(default=None)
    """
    Base DeckGL layer configuration (styling, interactions, etc.).
    """

    ui_config: typing_extensions.Annotated[typing.Optional[UiConfig], FieldMetadata(alias="uiConfig")] = pydantic.Field(
        default=None
    )
    """
    Configuration for interactive UI controls that can modify layer properties.
    """

    created_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="createdAt")] = None
    updated_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="updatedAt")] = None
    type: WeatherLayerType = pydantic.Field()
    """
    Weather layer type identifier
    """

    weather_model_id: typing_extensions.Annotated[str, FieldMetadata(alias="weatherModelId")] = pydantic.Field()
    """
    Weather model identifier, e.g., 'ECMF_IFS', 'ERA5', 'NCEP_GFS'
    """

    variable: str = pydantic.Field()
    """
    Weather variable, e.g., 'WindSpeed', 'Temperature', 'CloudCover'
    """

    altitude: int = pydantic.Field()
    """
    Height in meters
    """

    run_hour: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="runHour")] = pydantic.Field(
        default=None
    )
    """
    Forecast run hour (0, 6, 12, 18) - only for forecast models
    """

    run_day: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="runDay")] = pydantic.Field(
        default=None
    )
    """
    Forecast run day in ISO format (YYYY-MM-DD) - only for forecast models
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
