# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AScriptArgs', 'AScript']

@pulumi.input_type
class AScriptArgs:
    def __init__(__self__, *,
                 ascript_name: pulumi.Input[_builtins.str],
                 listener_id: pulumi.Input[_builtins.str],
                 position: pulumi.Input[_builtins.str],
                 script_content: pulumi.Input[_builtins.str],
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_attribute_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['AScriptExtAttributeArgs']]]] = None):
        """
        The set of arguments for constructing a AScript resource.
        :param pulumi.Input[_builtins.str] ascript_name: AScript name.
        :param pulumi.Input[_builtins.str] listener_id: Listener ID of script attribution
        :param pulumi.Input[_builtins.str] position: Script execution location.
        :param pulumi.Input[_builtins.str] script_content: AScript script content.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request
        :param pulumi.Input[_builtins.bool] enabled: Whether AScript is enabled.
        :param pulumi.Input[_builtins.bool] ext_attribute_enabled: Whether extension parameters are enabled. When ExtAttributeEnabled is true, ExtAttributes must be set.
        :param pulumi.Input[Sequence[pulumi.Input['AScriptExtAttributeArgs']]] ext_attributes: Expand the list of attributes. When ExtAttributeEnabled is true, ExtAttributes must be set. See `ext_attributes` below.
        """
        pulumi.set(__self__, "ascript_name", ascript_name)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "position", position)
        pulumi.set(__self__, "script_content", script_content)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ext_attribute_enabled is not None:
            pulumi.set(__self__, "ext_attribute_enabled", ext_attribute_enabled)
        if ext_attributes is not None:
            pulumi.set(__self__, "ext_attributes", ext_attributes)

    @_builtins.property
    @pulumi.getter(name="ascriptName")
    def ascript_name(self) -> pulumi.Input[_builtins.str]:
        """
        AScript name.
        """
        return pulumi.get(self, "ascript_name")

    @ascript_name.setter
    def ascript_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ascript_name", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[_builtins.str]:
        """
        Listener ID of script attribution
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Input[_builtins.str]:
        """
        Script execution location.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter(name="scriptContent")
    def script_content(self) -> pulumi.Input[_builtins.str]:
        """
        AScript script content.
        """
        return pulumi.get(self, "script_content")

    @script_content.setter
    def script_content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "script_content", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether AScript is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="extAttributeEnabled")
    def ext_attribute_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether extension parameters are enabled. When ExtAttributeEnabled is true, ExtAttributes must be set.
        """
        return pulumi.get(self, "ext_attribute_enabled")

    @ext_attribute_enabled.setter
    def ext_attribute_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ext_attribute_enabled", value)

    @_builtins.property
    @pulumi.getter(name="extAttributes")
    def ext_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AScriptExtAttributeArgs']]]]:
        """
        Expand the list of attributes. When ExtAttributeEnabled is true, ExtAttributes must be set. See `ext_attributes` below.
        """
        return pulumi.get(self, "ext_attributes")

    @ext_attributes.setter
    def ext_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AScriptExtAttributeArgs']]]]):
        pulumi.set(self, "ext_attributes", value)


@pulumi.input_type
class _AScriptState:
    def __init__(__self__, *,
                 ascript_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_attribute_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['AScriptExtAttributeArgs']]]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 script_content: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AScript resources.
        :param pulumi.Input[_builtins.str] ascript_name: AScript name.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request
        :param pulumi.Input[_builtins.bool] enabled: Whether AScript is enabled.
        :param pulumi.Input[_builtins.bool] ext_attribute_enabled: Whether extension parameters are enabled. When ExtAttributeEnabled is true, ExtAttributes must be set.
        :param pulumi.Input[Sequence[pulumi.Input['AScriptExtAttributeArgs']]] ext_attributes: Expand the list of attributes. When ExtAttributeEnabled is true, ExtAttributes must be set. See `ext_attributes` below.
        :param pulumi.Input[_builtins.str] listener_id: Listener ID of script attribution
        :param pulumi.Input[_builtins.str] position: Script execution location.
        :param pulumi.Input[_builtins.str] script_content: AScript script content.
        :param pulumi.Input[_builtins.str] status: Script status
        """
        if ascript_name is not None:
            pulumi.set(__self__, "ascript_name", ascript_name)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ext_attribute_enabled is not None:
            pulumi.set(__self__, "ext_attribute_enabled", ext_attribute_enabled)
        if ext_attributes is not None:
            pulumi.set(__self__, "ext_attributes", ext_attributes)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if script_content is not None:
            pulumi.set(__self__, "script_content", script_content)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="ascriptName")
    def ascript_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AScript name.
        """
        return pulumi.get(self, "ascript_name")

    @ascript_name.setter
    def ascript_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ascript_name", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether AScript is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="extAttributeEnabled")
    def ext_attribute_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether extension parameters are enabled. When ExtAttributeEnabled is true, ExtAttributes must be set.
        """
        return pulumi.get(self, "ext_attribute_enabled")

    @ext_attribute_enabled.setter
    def ext_attribute_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ext_attribute_enabled", value)

    @_builtins.property
    @pulumi.getter(name="extAttributes")
    def ext_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AScriptExtAttributeArgs']]]]:
        """
        Expand the list of attributes. When ExtAttributeEnabled is true, ExtAttributes must be set. See `ext_attributes` below.
        """
        return pulumi.get(self, "ext_attributes")

    @ext_attributes.setter
    def ext_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AScriptExtAttributeArgs']]]]):
        pulumi.set(self, "ext_attributes", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Listener ID of script attribution
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Script execution location.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter(name="scriptContent")
    def script_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AScript script content.
        """
        return pulumi.get(self, "script_content")

    @script_content.setter
    def script_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_content", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Script status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:alb/aScript:AScript")
class AScript(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ascript_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_attribute_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AScriptExtAttributeArgs', 'AScriptExtAttributeArgsDict']]]]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 script_content: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Application Load Balancer (ALB) A Script resource.

        For information about Application Load Balancer (ALB) A Script and how to use it, see [What is A Script](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createascripts).

        > **NOTE:** Available since v1.195.0.

        ## Import

        Application Load Balancer (ALB) A Script can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/aScript:AScript example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ascript_name: AScript name.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request
        :param pulumi.Input[_builtins.bool] enabled: Whether AScript is enabled.
        :param pulumi.Input[_builtins.bool] ext_attribute_enabled: Whether extension parameters are enabled. When ExtAttributeEnabled is true, ExtAttributes must be set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AScriptExtAttributeArgs', 'AScriptExtAttributeArgsDict']]]] ext_attributes: Expand the list of attributes. When ExtAttributeEnabled is true, ExtAttributes must be set. See `ext_attributes` below.
        :param pulumi.Input[_builtins.str] listener_id: Listener ID of script attribution
        :param pulumi.Input[_builtins.str] position: Script execution location.
        :param pulumi.Input[_builtins.str] script_content: AScript script content.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AScriptArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Load Balancer (ALB) A Script resource.

        For information about Application Load Balancer (ALB) A Script and how to use it, see [What is A Script](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createascripts).

        > **NOTE:** Available since v1.195.0.

        ## Import

        Application Load Balancer (ALB) A Script can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/aScript:AScript example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AScriptArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AScriptArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ascript_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_attribute_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AScriptExtAttributeArgs', 'AScriptExtAttributeArgsDict']]]]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 script_content: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AScriptArgs.__new__(AScriptArgs)

            if ascript_name is None and not opts.urn:
                raise TypeError("Missing required property 'ascript_name'")
            __props__.__dict__["ascript_name"] = ascript_name
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ext_attribute_enabled"] = ext_attribute_enabled
            __props__.__dict__["ext_attributes"] = ext_attributes
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            if position is None and not opts.urn:
                raise TypeError("Missing required property 'position'")
            __props__.__dict__["position"] = position
            if script_content is None and not opts.urn:
                raise TypeError("Missing required property 'script_content'")
            __props__.__dict__["script_content"] = script_content
            __props__.__dict__["status"] = None
        super(AScript, __self__).__init__(
            'alicloud:alb/aScript:AScript',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ascript_name: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ext_attribute_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ext_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AScriptExtAttributeArgs', 'AScriptExtAttributeArgsDict']]]]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            position: Optional[pulumi.Input[_builtins.str]] = None,
            script_content: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'AScript':
        """
        Get an existing AScript resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ascript_name: AScript name.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request
        :param pulumi.Input[_builtins.bool] enabled: Whether AScript is enabled.
        :param pulumi.Input[_builtins.bool] ext_attribute_enabled: Whether extension parameters are enabled. When ExtAttributeEnabled is true, ExtAttributes must be set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AScriptExtAttributeArgs', 'AScriptExtAttributeArgsDict']]]] ext_attributes: Expand the list of attributes. When ExtAttributeEnabled is true, ExtAttributes must be set. See `ext_attributes` below.
        :param pulumi.Input[_builtins.str] listener_id: Listener ID of script attribution
        :param pulumi.Input[_builtins.str] position: Script execution location.
        :param pulumi.Input[_builtins.str] script_content: AScript script content.
        :param pulumi.Input[_builtins.str] status: Script status
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AScriptState.__new__(_AScriptState)

        __props__.__dict__["ascript_name"] = ascript_name
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ext_attribute_enabled"] = ext_attribute_enabled
        __props__.__dict__["ext_attributes"] = ext_attributes
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["position"] = position
        __props__.__dict__["script_content"] = script_content
        __props__.__dict__["status"] = status
        return AScript(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ascriptName")
    def ascript_name(self) -> pulumi.Output[_builtins.str]:
        """
        AScript name.
        """
        return pulumi.get(self, "ascript_name")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to PreCheck only this request
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether AScript is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="extAttributeEnabled")
    def ext_attribute_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether extension parameters are enabled. When ExtAttributeEnabled is true, ExtAttributes must be set.
        """
        return pulumi.get(self, "ext_attribute_enabled")

    @_builtins.property
    @pulumi.getter(name="extAttributes")
    def ext_attributes(self) -> pulumi.Output[Optional[Sequence['outputs.AScriptExtAttribute']]]:
        """
        Expand the list of attributes. When ExtAttributeEnabled is true, ExtAttributes must be set. See `ext_attributes` below.
        """
        return pulumi.get(self, "ext_attributes")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        Listener ID of script attribution
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Output[_builtins.str]:
        """
        Script execution location.
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter(name="scriptContent")
    def script_content(self) -> pulumi.Output[_builtins.str]:
        """
        AScript script content.
        """
        return pulumi.get(self, "script_content")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Script status
        """
        return pulumi.get(self, "status")

