# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ExchangeArgs', 'Exchange']

@pulumi.input_type
class ExchangeArgs:
    def __init__(__self__, *,
                 auto_delete_state: pulumi.Input[_builtins.bool],
                 exchange_name: pulumi.Input[_builtins.str],
                 exchange_type: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 internal: pulumi.Input[_builtins.bool],
                 virtual_host_name: pulumi.Input[_builtins.str],
                 alternate_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 x_delayed_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Exchange resource.
        :param pulumi.Input[_builtins.bool] auto_delete_state: Specifies whether to automatically delete the exchange. Valid values:
        :param pulumi.Input[_builtins.str] exchange_name: The name of the exchange that you want to create. The exchange name must meet the following conventions:
               
               - The name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (\\_), periods (.), number signs (#), forward slashes (/), and at signs (@).
               - After the exchange is created, you cannot change its name. If you want to change its name, delete the exchange and create another exchange.
        :param pulumi.Input[_builtins.str] exchange_type: The Exchange type. Value:
               - `DIRECT`: This type of Routing rule routes messages to a Queue whose Binding Key matches the Routing Key.
               - `TOPIC`: This type is similar to the DIRECT type. It uses Routing Key pattern matching and string comparison to route messages to the bound Queue.
               - `FANOUT`: This type of routing rule is very simple. It routes all messages sent to the Exchange to all queues bound to it, which is equivalent to the broadcast function.
               - `HEADERS`: This type is similar to the DIRECT type. Headers Exchange uses the Headers attribute instead of Routing Key for route matching. When binding Headers Exchange and Queue, the Key-value pair of the bound attribute is set. When sending a message to Headers Exchange, the Headers attribute Key-value pair of the message is set, and the message is routed to the bound Queue by comparing the Headers attribute Key-value pair with the bound attribute Key-value pair.
               - `X_delayed_message`: By declaring this type of Exchange, you can customize the Header attribute x-delay of the message to specify the delivery delay time period, in milliseconds. Messages will be delivered to the corresponding Queue after the time period defined in the x-delay according to the routing rules. The routing rule depends on the Exchange route type specified in the x-delayed-type.
               - `X_CONSISTENT_HASH`: The x-consistent-hash Exchange allows you to Hash the Routing Key or Header value and use the consistent hashing algorithm to route messages to different queues.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the ApsaraMQ for RabbitMQ instance whose exchange you want to delete.
        :param pulumi.Input[_builtins.bool] internal: Specifies whether the exchange is an internal exchange. Valid values:
        :param pulumi.Input[_builtins.str] virtual_host_name: The name of the vhost to which the exchange that you want to create belongs.
        :param pulumi.Input[_builtins.str] alternate_exchange: The alternate exchange. An alternate exchange is used to receive messages that fail to be routed to queues from the current exchange.
        :param pulumi.Input[_builtins.str] x_delayed_type: RabbitMQ supports the x-delayed-message Exchange. By declaring this type of Exchange, you can customize the x-delay header attribute to specify the delay period for message delivery, measured in milliseconds. The message will be delivered to the corresponding Queue after the period defined in x-delay. The routing rules are determined by the type of Exchange specified in x-delayed-type.
        """
        pulumi.set(__self__, "auto_delete_state", auto_delete_state)
        pulumi.set(__self__, "exchange_name", exchange_name)
        pulumi.set(__self__, "exchange_type", exchange_type)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "internal", internal)
        pulumi.set(__self__, "virtual_host_name", virtual_host_name)
        if alternate_exchange is not None:
            pulumi.set(__self__, "alternate_exchange", alternate_exchange)
        if x_delayed_type is not None:
            pulumi.set(__self__, "x_delayed_type", x_delayed_type)

    @_builtins.property
    @pulumi.getter(name="autoDeleteState")
    def auto_delete_state(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether to automatically delete the exchange. Valid values:
        """
        return pulumi.get(self, "auto_delete_state")

    @auto_delete_state.setter
    def auto_delete_state(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "auto_delete_state", value)

    @_builtins.property
    @pulumi.getter(name="exchangeName")
    def exchange_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the exchange that you want to create. The exchange name must meet the following conventions:

        - The name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (\\_), periods (.), number signs (#), forward slashes (/), and at signs (@).
        - After the exchange is created, you cannot change its name. If you want to change its name, delete the exchange and create another exchange.
        """
        return pulumi.get(self, "exchange_name")

    @exchange_name.setter
    def exchange_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "exchange_name", value)

    @_builtins.property
    @pulumi.getter(name="exchangeType")
    def exchange_type(self) -> pulumi.Input[_builtins.str]:
        """
        The Exchange type. Value:
        - `DIRECT`: This type of Routing rule routes messages to a Queue whose Binding Key matches the Routing Key.
        - `TOPIC`: This type is similar to the DIRECT type. It uses Routing Key pattern matching and string comparison to route messages to the bound Queue.
        - `FANOUT`: This type of routing rule is very simple. It routes all messages sent to the Exchange to all queues bound to it, which is equivalent to the broadcast function.
        - `HEADERS`: This type is similar to the DIRECT type. Headers Exchange uses the Headers attribute instead of Routing Key for route matching. When binding Headers Exchange and Queue, the Key-value pair of the bound attribute is set. When sending a message to Headers Exchange, the Headers attribute Key-value pair of the message is set, and the message is routed to the bound Queue by comparing the Headers attribute Key-value pair with the bound attribute Key-value pair.
        - `X_delayed_message`: By declaring this type of Exchange, you can customize the Header attribute x-delay of the message to specify the delivery delay time period, in milliseconds. Messages will be delivered to the corresponding Queue after the time period defined in the x-delay according to the routing rules. The routing rule depends on the Exchange route type specified in the x-delayed-type.
        - `X_CONSISTENT_HASH`: The x-consistent-hash Exchange allows you to Hash the Routing Key or Header value and use the consistent hashing algorithm to route messages to different queues.
        """
        return pulumi.get(self, "exchange_type")

    @exchange_type.setter
    def exchange_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "exchange_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the ApsaraMQ for RabbitMQ instance whose exchange you want to delete.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether the exchange is an internal exchange. Valid values:
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "internal", value)

    @_builtins.property
    @pulumi.getter(name="virtualHostName")
    def virtual_host_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the vhost to which the exchange that you want to create belongs.
        """
        return pulumi.get(self, "virtual_host_name")

    @virtual_host_name.setter
    def virtual_host_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_host_name", value)

    @_builtins.property
    @pulumi.getter(name="alternateExchange")
    def alternate_exchange(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alternate exchange. An alternate exchange is used to receive messages that fail to be routed to queues from the current exchange.
        """
        return pulumi.get(self, "alternate_exchange")

    @alternate_exchange.setter
    def alternate_exchange(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alternate_exchange", value)

    @_builtins.property
    @pulumi.getter(name="xDelayedType")
    def x_delayed_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RabbitMQ supports the x-delayed-message Exchange. By declaring this type of Exchange, you can customize the x-delay header attribute to specify the delay period for message delivery, measured in milliseconds. The message will be delivered to the corresponding Queue after the period defined in x-delay. The routing rules are determined by the type of Exchange specified in x-delayed-type.
        """
        return pulumi.get(self, "x_delayed_type")

    @x_delayed_type.setter
    def x_delayed_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_delayed_type", value)


@pulumi.input_type
class _ExchangeState:
    def __init__(__self__, *,
                 alternate_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_delete_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 exchange_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exchange_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 x_delayed_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Exchange resources.
        :param pulumi.Input[_builtins.str] alternate_exchange: The alternate exchange. An alternate exchange is used to receive messages that fail to be routed to queues from the current exchange.
        :param pulumi.Input[_builtins.bool] auto_delete_state: Specifies whether to automatically delete the exchange. Valid values:
        :param pulumi.Input[_builtins.int] create_time: CreateTime
        :param pulumi.Input[_builtins.str] exchange_name: The name of the exchange that you want to create. The exchange name must meet the following conventions:
               
               - The name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (\\_), periods (.), number signs (#), forward slashes (/), and at signs (@).
               - After the exchange is created, you cannot change its name. If you want to change its name, delete the exchange and create another exchange.
        :param pulumi.Input[_builtins.str] exchange_type: The Exchange type. Value:
               - `DIRECT`: This type of Routing rule routes messages to a Queue whose Binding Key matches the Routing Key.
               - `TOPIC`: This type is similar to the DIRECT type. It uses Routing Key pattern matching and string comparison to route messages to the bound Queue.
               - `FANOUT`: This type of routing rule is very simple. It routes all messages sent to the Exchange to all queues bound to it, which is equivalent to the broadcast function.
               - `HEADERS`: This type is similar to the DIRECT type. Headers Exchange uses the Headers attribute instead of Routing Key for route matching. When binding Headers Exchange and Queue, the Key-value pair of the bound attribute is set. When sending a message to Headers Exchange, the Headers attribute Key-value pair of the message is set, and the message is routed to the bound Queue by comparing the Headers attribute Key-value pair with the bound attribute Key-value pair.
               - `X_delayed_message`: By declaring this type of Exchange, you can customize the Header attribute x-delay of the message to specify the delivery delay time period, in milliseconds. Messages will be delivered to the corresponding Queue after the time period defined in the x-delay according to the routing rules. The routing rule depends on the Exchange route type specified in the x-delayed-type.
               - `X_CONSISTENT_HASH`: The x-consistent-hash Exchange allows you to Hash the Routing Key or Header value and use the consistent hashing algorithm to route messages to different queues.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the ApsaraMQ for RabbitMQ instance whose exchange you want to delete.
        :param pulumi.Input[_builtins.bool] internal: Specifies whether the exchange is an internal exchange. Valid values:
        :param pulumi.Input[_builtins.str] virtual_host_name: The name of the vhost to which the exchange that you want to create belongs.
        :param pulumi.Input[_builtins.str] x_delayed_type: RabbitMQ supports the x-delayed-message Exchange. By declaring this type of Exchange, you can customize the x-delay header attribute to specify the delay period for message delivery, measured in milliseconds. The message will be delivered to the corresponding Queue after the period defined in x-delay. The routing rules are determined by the type of Exchange specified in x-delayed-type.
        """
        if alternate_exchange is not None:
            pulumi.set(__self__, "alternate_exchange", alternate_exchange)
        if auto_delete_state is not None:
            pulumi.set(__self__, "auto_delete_state", auto_delete_state)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if exchange_name is not None:
            pulumi.set(__self__, "exchange_name", exchange_name)
        if exchange_type is not None:
            pulumi.set(__self__, "exchange_type", exchange_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if virtual_host_name is not None:
            pulumi.set(__self__, "virtual_host_name", virtual_host_name)
        if x_delayed_type is not None:
            pulumi.set(__self__, "x_delayed_type", x_delayed_type)

    @_builtins.property
    @pulumi.getter(name="alternateExchange")
    def alternate_exchange(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alternate exchange. An alternate exchange is used to receive messages that fail to be routed to queues from the current exchange.
        """
        return pulumi.get(self, "alternate_exchange")

    @alternate_exchange.setter
    def alternate_exchange(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alternate_exchange", value)

    @_builtins.property
    @pulumi.getter(name="autoDeleteState")
    def auto_delete_state(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically delete the exchange. Valid values:
        """
        return pulumi.get(self, "auto_delete_state")

    @auto_delete_state.setter
    def auto_delete_state(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_delete_state", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        CreateTime
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="exchangeName")
    def exchange_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the exchange that you want to create. The exchange name must meet the following conventions:

        - The name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (\\_), periods (.), number signs (#), forward slashes (/), and at signs (@).
        - After the exchange is created, you cannot change its name. If you want to change its name, delete the exchange and create another exchange.
        """
        return pulumi.get(self, "exchange_name")

    @exchange_name.setter
    def exchange_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exchange_name", value)

    @_builtins.property
    @pulumi.getter(name="exchangeType")
    def exchange_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Exchange type. Value:
        - `DIRECT`: This type of Routing rule routes messages to a Queue whose Binding Key matches the Routing Key.
        - `TOPIC`: This type is similar to the DIRECT type. It uses Routing Key pattern matching and string comparison to route messages to the bound Queue.
        - `FANOUT`: This type of routing rule is very simple. It routes all messages sent to the Exchange to all queues bound to it, which is equivalent to the broadcast function.
        - `HEADERS`: This type is similar to the DIRECT type. Headers Exchange uses the Headers attribute instead of Routing Key for route matching. When binding Headers Exchange and Queue, the Key-value pair of the bound attribute is set. When sending a message to Headers Exchange, the Headers attribute Key-value pair of the message is set, and the message is routed to the bound Queue by comparing the Headers attribute Key-value pair with the bound attribute Key-value pair.
        - `X_delayed_message`: By declaring this type of Exchange, you can customize the Header attribute x-delay of the message to specify the delivery delay time period, in milliseconds. Messages will be delivered to the corresponding Queue after the time period defined in the x-delay according to the routing rules. The routing rule depends on the Exchange route type specified in the x-delayed-type.
        - `X_CONSISTENT_HASH`: The x-consistent-hash Exchange allows you to Hash the Routing Key or Header value and use the consistent hashing algorithm to route messages to different queues.
        """
        return pulumi.get(self, "exchange_type")

    @exchange_type.setter
    def exchange_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exchange_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ApsaraMQ for RabbitMQ instance whose exchange you want to delete.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the exchange is an internal exchange. Valid values:
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internal", value)

    @_builtins.property
    @pulumi.getter(name="virtualHostName")
    def virtual_host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the vhost to which the exchange that you want to create belongs.
        """
        return pulumi.get(self, "virtual_host_name")

    @virtual_host_name.setter
    def virtual_host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_host_name", value)

    @_builtins.property
    @pulumi.getter(name="xDelayedType")
    def x_delayed_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RabbitMQ supports the x-delayed-message Exchange. By declaring this type of Exchange, you can customize the x-delay header attribute to specify the delay period for message delivery, measured in milliseconds. The message will be delivered to the corresponding Queue after the period defined in x-delay. The routing rules are determined by the type of Exchange specified in x-delayed-type.
        """
        return pulumi.get(self, "x_delayed_type")

    @x_delayed_type.setter
    def x_delayed_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_delayed_type", value)


@pulumi.type_token("alicloud:amqp/exchange:Exchange")
class Exchange(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternate_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_delete_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 exchange_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exchange_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 x_delayed_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RabbitMQ (AMQP) Exchange resource.

        For information about RabbitMQ (AMQP) Exchange and how to use it, see [What is Exchange](https://www.alibabacloud.com/help/en/message-queue-for-rabbitmq/latest/createexchange).

        > **NOTE:** Available since v1.128.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        virtual_host_name = config.get("virtualHostName")
        if virtual_host_name is None:
            virtual_host_name = "/"
        create_instance = alicloud.amqp.Instance("CreateInstance",
            renewal_duration=1,
            max_tps="3000",
            period_cycle="Month",
            max_connections=2000,
            support_eip=True,
            auto_renew=False,
            renewal_status="AutoRenewal",
            period=12,
            instance_name=name,
            support_tracing=False,
            payment_type="Subscription",
            renewal_duration_unit="Month",
            instance_type="enterprise",
            queue_capacity="200",
            max_eip_tps="128",
            storage_size="0")
        default = alicloud.amqp.Exchange("default",
            virtual_host_name=virtual_host_name,
            instance_id=create_instance.id,
            internal=True,
            auto_delete_state=False,
            exchange_name=name,
            exchange_type="X_CONSISTENT_HASH",
            alternate_exchange="bakExchange",
            x_delayed_type="DIRECT")
        ```

        ## Import

        RabbitMQ (AMQP) Exchange can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:amqp/exchange:Exchange example <instance_id>:<virtual_host_name>:<exchange_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alternate_exchange: The alternate exchange. An alternate exchange is used to receive messages that fail to be routed to queues from the current exchange.
        :param pulumi.Input[_builtins.bool] auto_delete_state: Specifies whether to automatically delete the exchange. Valid values:
        :param pulumi.Input[_builtins.str] exchange_name: The name of the exchange that you want to create. The exchange name must meet the following conventions:
               
               - The name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (\\_), periods (.), number signs (#), forward slashes (/), and at signs (@).
               - After the exchange is created, you cannot change its name. If you want to change its name, delete the exchange and create another exchange.
        :param pulumi.Input[_builtins.str] exchange_type: The Exchange type. Value:
               - `DIRECT`: This type of Routing rule routes messages to a Queue whose Binding Key matches the Routing Key.
               - `TOPIC`: This type is similar to the DIRECT type. It uses Routing Key pattern matching and string comparison to route messages to the bound Queue.
               - `FANOUT`: This type of routing rule is very simple. It routes all messages sent to the Exchange to all queues bound to it, which is equivalent to the broadcast function.
               - `HEADERS`: This type is similar to the DIRECT type. Headers Exchange uses the Headers attribute instead of Routing Key for route matching. When binding Headers Exchange and Queue, the Key-value pair of the bound attribute is set. When sending a message to Headers Exchange, the Headers attribute Key-value pair of the message is set, and the message is routed to the bound Queue by comparing the Headers attribute Key-value pair with the bound attribute Key-value pair.
               - `X_delayed_message`: By declaring this type of Exchange, you can customize the Header attribute x-delay of the message to specify the delivery delay time period, in milliseconds. Messages will be delivered to the corresponding Queue after the time period defined in the x-delay according to the routing rules. The routing rule depends on the Exchange route type specified in the x-delayed-type.
               - `X_CONSISTENT_HASH`: The x-consistent-hash Exchange allows you to Hash the Routing Key or Header value and use the consistent hashing algorithm to route messages to different queues.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the ApsaraMQ for RabbitMQ instance whose exchange you want to delete.
        :param pulumi.Input[_builtins.bool] internal: Specifies whether the exchange is an internal exchange. Valid values:
        :param pulumi.Input[_builtins.str] virtual_host_name: The name of the vhost to which the exchange that you want to create belongs.
        :param pulumi.Input[_builtins.str] x_delayed_type: RabbitMQ supports the x-delayed-message Exchange. By declaring this type of Exchange, you can customize the x-delay header attribute to specify the delay period for message delivery, measured in milliseconds. The message will be delivered to the corresponding Queue after the period defined in x-delay. The routing rules are determined by the type of Exchange specified in x-delayed-type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExchangeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RabbitMQ (AMQP) Exchange resource.

        For information about RabbitMQ (AMQP) Exchange and how to use it, see [What is Exchange](https://www.alibabacloud.com/help/en/message-queue-for-rabbitmq/latest/createexchange).

        > **NOTE:** Available since v1.128.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        virtual_host_name = config.get("virtualHostName")
        if virtual_host_name is None:
            virtual_host_name = "/"
        create_instance = alicloud.amqp.Instance("CreateInstance",
            renewal_duration=1,
            max_tps="3000",
            period_cycle="Month",
            max_connections=2000,
            support_eip=True,
            auto_renew=False,
            renewal_status="AutoRenewal",
            period=12,
            instance_name=name,
            support_tracing=False,
            payment_type="Subscription",
            renewal_duration_unit="Month",
            instance_type="enterprise",
            queue_capacity="200",
            max_eip_tps="128",
            storage_size="0")
        default = alicloud.amqp.Exchange("default",
            virtual_host_name=virtual_host_name,
            instance_id=create_instance.id,
            internal=True,
            auto_delete_state=False,
            exchange_name=name,
            exchange_type="X_CONSISTENT_HASH",
            alternate_exchange="bakExchange",
            x_delayed_type="DIRECT")
        ```

        ## Import

        RabbitMQ (AMQP) Exchange can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:amqp/exchange:Exchange example <instance_id>:<virtual_host_name>:<exchange_name>
        ```

        :param str resource_name: The name of the resource.
        :param ExchangeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExchangeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternate_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_delete_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 exchange_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exchange_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 x_delayed_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExchangeArgs.__new__(ExchangeArgs)

            __props__.__dict__["alternate_exchange"] = alternate_exchange
            if auto_delete_state is None and not opts.urn:
                raise TypeError("Missing required property 'auto_delete_state'")
            __props__.__dict__["auto_delete_state"] = auto_delete_state
            if exchange_name is None and not opts.urn:
                raise TypeError("Missing required property 'exchange_name'")
            __props__.__dict__["exchange_name"] = exchange_name
            if exchange_type is None and not opts.urn:
                raise TypeError("Missing required property 'exchange_type'")
            __props__.__dict__["exchange_type"] = exchange_type
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if internal is None and not opts.urn:
                raise TypeError("Missing required property 'internal'")
            __props__.__dict__["internal"] = internal
            if virtual_host_name is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_host_name'")
            __props__.__dict__["virtual_host_name"] = virtual_host_name
            __props__.__dict__["x_delayed_type"] = x_delayed_type
            __props__.__dict__["create_time"] = None
        super(Exchange, __self__).__init__(
            'alicloud:amqp/exchange:Exchange',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alternate_exchange: Optional[pulumi.Input[_builtins.str]] = None,
            auto_delete_state: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            exchange_name: Optional[pulumi.Input[_builtins.str]] = None,
            exchange_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            internal: Optional[pulumi.Input[_builtins.bool]] = None,
            virtual_host_name: Optional[pulumi.Input[_builtins.str]] = None,
            x_delayed_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Exchange':
        """
        Get an existing Exchange resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alternate_exchange: The alternate exchange. An alternate exchange is used to receive messages that fail to be routed to queues from the current exchange.
        :param pulumi.Input[_builtins.bool] auto_delete_state: Specifies whether to automatically delete the exchange. Valid values:
        :param pulumi.Input[_builtins.int] create_time: CreateTime
        :param pulumi.Input[_builtins.str] exchange_name: The name of the exchange that you want to create. The exchange name must meet the following conventions:
               
               - The name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (\\_), periods (.), number signs (#), forward slashes (/), and at signs (@).
               - After the exchange is created, you cannot change its name. If you want to change its name, delete the exchange and create another exchange.
        :param pulumi.Input[_builtins.str] exchange_type: The Exchange type. Value:
               - `DIRECT`: This type of Routing rule routes messages to a Queue whose Binding Key matches the Routing Key.
               - `TOPIC`: This type is similar to the DIRECT type. It uses Routing Key pattern matching and string comparison to route messages to the bound Queue.
               - `FANOUT`: This type of routing rule is very simple. It routes all messages sent to the Exchange to all queues bound to it, which is equivalent to the broadcast function.
               - `HEADERS`: This type is similar to the DIRECT type. Headers Exchange uses the Headers attribute instead of Routing Key for route matching. When binding Headers Exchange and Queue, the Key-value pair of the bound attribute is set. When sending a message to Headers Exchange, the Headers attribute Key-value pair of the message is set, and the message is routed to the bound Queue by comparing the Headers attribute Key-value pair with the bound attribute Key-value pair.
               - `X_delayed_message`: By declaring this type of Exchange, you can customize the Header attribute x-delay of the message to specify the delivery delay time period, in milliseconds. Messages will be delivered to the corresponding Queue after the time period defined in the x-delay according to the routing rules. The routing rule depends on the Exchange route type specified in the x-delayed-type.
               - `X_CONSISTENT_HASH`: The x-consistent-hash Exchange allows you to Hash the Routing Key or Header value and use the consistent hashing algorithm to route messages to different queues.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the ApsaraMQ for RabbitMQ instance whose exchange you want to delete.
        :param pulumi.Input[_builtins.bool] internal: Specifies whether the exchange is an internal exchange. Valid values:
        :param pulumi.Input[_builtins.str] virtual_host_name: The name of the vhost to which the exchange that you want to create belongs.
        :param pulumi.Input[_builtins.str] x_delayed_type: RabbitMQ supports the x-delayed-message Exchange. By declaring this type of Exchange, you can customize the x-delay header attribute to specify the delay period for message delivery, measured in milliseconds. The message will be delivered to the corresponding Queue after the period defined in x-delay. The routing rules are determined by the type of Exchange specified in x-delayed-type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExchangeState.__new__(_ExchangeState)

        __props__.__dict__["alternate_exchange"] = alternate_exchange
        __props__.__dict__["auto_delete_state"] = auto_delete_state
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["exchange_name"] = exchange_name
        __props__.__dict__["exchange_type"] = exchange_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["internal"] = internal
        __props__.__dict__["virtual_host_name"] = virtual_host_name
        __props__.__dict__["x_delayed_type"] = x_delayed_type
        return Exchange(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alternateExchange")
    def alternate_exchange(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The alternate exchange. An alternate exchange is used to receive messages that fail to be routed to queues from the current exchange.
        """
        return pulumi.get(self, "alternate_exchange")

    @_builtins.property
    @pulumi.getter(name="autoDeleteState")
    def auto_delete_state(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to automatically delete the exchange. Valid values:
        """
        return pulumi.get(self, "auto_delete_state")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        CreateTime
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="exchangeName")
    def exchange_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the exchange that you want to create. The exchange name must meet the following conventions:

        - The name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (\\_), periods (.), number signs (#), forward slashes (/), and at signs (@).
        - After the exchange is created, you cannot change its name. If you want to change its name, delete the exchange and create another exchange.
        """
        return pulumi.get(self, "exchange_name")

    @_builtins.property
    @pulumi.getter(name="exchangeType")
    def exchange_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Exchange type. Value:
        - `DIRECT`: This type of Routing rule routes messages to a Queue whose Binding Key matches the Routing Key.
        - `TOPIC`: This type is similar to the DIRECT type. It uses Routing Key pattern matching and string comparison to route messages to the bound Queue.
        - `FANOUT`: This type of routing rule is very simple. It routes all messages sent to the Exchange to all queues bound to it, which is equivalent to the broadcast function.
        - `HEADERS`: This type is similar to the DIRECT type. Headers Exchange uses the Headers attribute instead of Routing Key for route matching. When binding Headers Exchange and Queue, the Key-value pair of the bound attribute is set. When sending a message to Headers Exchange, the Headers attribute Key-value pair of the message is set, and the message is routed to the bound Queue by comparing the Headers attribute Key-value pair with the bound attribute Key-value pair.
        - `X_delayed_message`: By declaring this type of Exchange, you can customize the Header attribute x-delay of the message to specify the delivery delay time period, in milliseconds. Messages will be delivered to the corresponding Queue after the time period defined in the x-delay according to the routing rules. The routing rule depends on the Exchange route type specified in the x-delayed-type.
        - `X_CONSISTENT_HASH`: The x-consistent-hash Exchange allows you to Hash the Routing Key or Header value and use the consistent hashing algorithm to route messages to different queues.
        """
        return pulumi.get(self, "exchange_type")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the ApsaraMQ for RabbitMQ instance whose exchange you want to delete.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def internal(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether the exchange is an internal exchange. Valid values:
        """
        return pulumi.get(self, "internal")

    @_builtins.property
    @pulumi.getter(name="virtualHostName")
    def virtual_host_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the vhost to which the exchange that you want to create belongs.
        """
        return pulumi.get(self, "virtual_host_name")

    @_builtins.property
    @pulumi.getter(name="xDelayedType")
    def x_delayed_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        RabbitMQ supports the x-delayed-message Exchange. By declaring this type of Exchange, you can customize the x-delay header attribute to specify the delay period for message delivery, measured in milliseconds. The message will be delivered to the corresponding Queue after the period defined in x-delay. The routing rules are determined by the type of Exchange specified in x-delayed-type.
        """
        return pulumi.get(self, "x_delayed_type")

