# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DispatchRuleArgs', 'DispatchRule']

@pulumi.input_type
class DispatchRuleArgs:
    def __init__(__self__, *,
                 dispatch_rule_name: pulumi.Input[_builtins.str],
                 group_rules: pulumi.Input[Sequence[pulumi.Input['DispatchRuleGroupRuleArgs']]],
                 label_match_expression_grids: pulumi.Input[Sequence[pulumi.Input['DispatchRuleLabelMatchExpressionGridArgs']]],
                 notify_rules: pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyRuleArgs']]],
                 dispatch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_recover: Optional[pulumi.Input[_builtins.bool]] = None,
                 notify_templates: Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyTemplateArgs']]]] = None):
        """
        The set of arguments for constructing a DispatchRule resource.
        :param pulumi.Input[_builtins.str] dispatch_rule_name: The name of the dispatch policy.
        :param pulumi.Input[Sequence[pulumi.Input['DispatchRuleGroupRuleArgs']]] group_rules: Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        :param pulumi.Input[Sequence[pulumi.Input['DispatchRuleLabelMatchExpressionGridArgs']]] label_match_expression_grids: Sets the dispatch rule. See `label_match_expression_grid` below.
        :param pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyRuleArgs']]] notify_rules: Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        :param pulumi.Input[_builtins.str] dispatch_type: The alert handling method. Valid values: CREATE_ALERT: generates an alert. DISCARD_ALERT: discards the alert event and generates no alert.
        :param pulumi.Input[_builtins.bool] is_recover: Specifies whether to send the restored alert. Valid values: true: sends the alert. false: does not send the alert.
        :param pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyTemplateArgs']]] notify_templates: Sets the notification template. See `notify_template` below.
        """
        pulumi.set(__self__, "dispatch_rule_name", dispatch_rule_name)
        pulumi.set(__self__, "group_rules", group_rules)
        pulumi.set(__self__, "label_match_expression_grids", label_match_expression_grids)
        pulumi.set(__self__, "notify_rules", notify_rules)
        if dispatch_type is not None:
            pulumi.set(__self__, "dispatch_type", dispatch_type)
        if is_recover is not None:
            pulumi.set(__self__, "is_recover", is_recover)
        if notify_templates is not None:
            pulumi.set(__self__, "notify_templates", notify_templates)

    @_builtins.property
    @pulumi.getter(name="dispatchRuleName")
    def dispatch_rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the dispatch policy.
        """
        return pulumi.get(self, "dispatch_rule_name")

    @dispatch_rule_name.setter
    def dispatch_rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dispatch_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="groupRules")
    def group_rules(self) -> pulumi.Input[Sequence[pulumi.Input['DispatchRuleGroupRuleArgs']]]:
        """
        Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        """
        return pulumi.get(self, "group_rules")

    @group_rules.setter
    def group_rules(self, value: pulumi.Input[Sequence[pulumi.Input['DispatchRuleGroupRuleArgs']]]):
        pulumi.set(self, "group_rules", value)

    @_builtins.property
    @pulumi.getter(name="labelMatchExpressionGrids")
    def label_match_expression_grids(self) -> pulumi.Input[Sequence[pulumi.Input['DispatchRuleLabelMatchExpressionGridArgs']]]:
        """
        Sets the dispatch rule. See `label_match_expression_grid` below.
        """
        return pulumi.get(self, "label_match_expression_grids")

    @label_match_expression_grids.setter
    def label_match_expression_grids(self, value: pulumi.Input[Sequence[pulumi.Input['DispatchRuleLabelMatchExpressionGridArgs']]]):
        pulumi.set(self, "label_match_expression_grids", value)

    @_builtins.property
    @pulumi.getter(name="notifyRules")
    def notify_rules(self) -> pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyRuleArgs']]]:
        """
        Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        """
        return pulumi.get(self, "notify_rules")

    @notify_rules.setter
    def notify_rules(self, value: pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyRuleArgs']]]):
        pulumi.set(self, "notify_rules", value)

    @_builtins.property
    @pulumi.getter(name="dispatchType")
    def dispatch_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alert handling method. Valid values: CREATE_ALERT: generates an alert. DISCARD_ALERT: discards the alert event and generates no alert.
        """
        return pulumi.get(self, "dispatch_type")

    @dispatch_type.setter
    def dispatch_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dispatch_type", value)

    @_builtins.property
    @pulumi.getter(name="isRecover")
    def is_recover(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to send the restored alert. Valid values: true: sends the alert. false: does not send the alert.
        """
        return pulumi.get(self, "is_recover")

    @is_recover.setter
    def is_recover(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_recover", value)

    @_builtins.property
    @pulumi.getter(name="notifyTemplates")
    def notify_templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyTemplateArgs']]]]:
        """
        Sets the notification template. See `notify_template` below.
        """
        return pulumi.get(self, "notify_templates")

    @notify_templates.setter
    def notify_templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyTemplateArgs']]]]):
        pulumi.set(self, "notify_templates", value)


@pulumi.input_type
class _DispatchRuleState:
    def __init__(__self__, *,
                 dispatch_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dispatch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 group_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleGroupRuleArgs']]]] = None,
                 is_recover: Optional[pulumi.Input[_builtins.bool]] = None,
                 label_match_expression_grids: Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleLabelMatchExpressionGridArgs']]]] = None,
                 notify_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyRuleArgs']]]] = None,
                 notify_templates: Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyTemplateArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DispatchRule resources.
        :param pulumi.Input[_builtins.str] dispatch_rule_name: The name of the dispatch policy.
        :param pulumi.Input[_builtins.str] dispatch_type: The alert handling method. Valid values: CREATE_ALERT: generates an alert. DISCARD_ALERT: discards the alert event and generates no alert.
        :param pulumi.Input[Sequence[pulumi.Input['DispatchRuleGroupRuleArgs']]] group_rules: Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        :param pulumi.Input[_builtins.bool] is_recover: Specifies whether to send the restored alert. Valid values: true: sends the alert. false: does not send the alert.
        :param pulumi.Input[Sequence[pulumi.Input['DispatchRuleLabelMatchExpressionGridArgs']]] label_match_expression_grids: Sets the dispatch rule. See `label_match_expression_grid` below.
        :param pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyRuleArgs']]] notify_rules: Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        :param pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyTemplateArgs']]] notify_templates: Sets the notification template. See `notify_template` below.
        :param pulumi.Input[_builtins.str] status: The resource status of Alert Dispatch Rule.
        """
        if dispatch_rule_name is not None:
            pulumi.set(__self__, "dispatch_rule_name", dispatch_rule_name)
        if dispatch_type is not None:
            pulumi.set(__self__, "dispatch_type", dispatch_type)
        if group_rules is not None:
            pulumi.set(__self__, "group_rules", group_rules)
        if is_recover is not None:
            pulumi.set(__self__, "is_recover", is_recover)
        if label_match_expression_grids is not None:
            pulumi.set(__self__, "label_match_expression_grids", label_match_expression_grids)
        if notify_rules is not None:
            pulumi.set(__self__, "notify_rules", notify_rules)
        if notify_templates is not None:
            pulumi.set(__self__, "notify_templates", notify_templates)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="dispatchRuleName")
    def dispatch_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the dispatch policy.
        """
        return pulumi.get(self, "dispatch_rule_name")

    @dispatch_rule_name.setter
    def dispatch_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dispatch_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="dispatchType")
    def dispatch_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alert handling method. Valid values: CREATE_ALERT: generates an alert. DISCARD_ALERT: discards the alert event and generates no alert.
        """
        return pulumi.get(self, "dispatch_type")

    @dispatch_type.setter
    def dispatch_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dispatch_type", value)

    @_builtins.property
    @pulumi.getter(name="groupRules")
    def group_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleGroupRuleArgs']]]]:
        """
        Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        """
        return pulumi.get(self, "group_rules")

    @group_rules.setter
    def group_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleGroupRuleArgs']]]]):
        pulumi.set(self, "group_rules", value)

    @_builtins.property
    @pulumi.getter(name="isRecover")
    def is_recover(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to send the restored alert. Valid values: true: sends the alert. false: does not send the alert.
        """
        return pulumi.get(self, "is_recover")

    @is_recover.setter
    def is_recover(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_recover", value)

    @_builtins.property
    @pulumi.getter(name="labelMatchExpressionGrids")
    def label_match_expression_grids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleLabelMatchExpressionGridArgs']]]]:
        """
        Sets the dispatch rule. See `label_match_expression_grid` below.
        """
        return pulumi.get(self, "label_match_expression_grids")

    @label_match_expression_grids.setter
    def label_match_expression_grids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleLabelMatchExpressionGridArgs']]]]):
        pulumi.set(self, "label_match_expression_grids", value)

    @_builtins.property
    @pulumi.getter(name="notifyRules")
    def notify_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyRuleArgs']]]]:
        """
        Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        """
        return pulumi.get(self, "notify_rules")

    @notify_rules.setter
    def notify_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyRuleArgs']]]]):
        pulumi.set(self, "notify_rules", value)

    @_builtins.property
    @pulumi.getter(name="notifyTemplates")
    def notify_templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyTemplateArgs']]]]:
        """
        Sets the notification template. See `notify_template` below.
        """
        return pulumi.get(self, "notify_templates")

    @notify_templates.setter
    def notify_templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DispatchRuleNotifyTemplateArgs']]]]):
        pulumi.set(self, "notify_templates", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource status of Alert Dispatch Rule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:arms/dispatchRule:DispatchRule")
class DispatchRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dispatch_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dispatch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 group_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleGroupRuleArgs', 'DispatchRuleGroupRuleArgsDict']]]]] = None,
                 is_recover: Optional[pulumi.Input[_builtins.bool]] = None,
                 label_match_expression_grids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleLabelMatchExpressionGridArgs', 'DispatchRuleLabelMatchExpressionGridArgsDict']]]]] = None,
                 notify_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleNotifyRuleArgs', 'DispatchRuleNotifyRuleArgsDict']]]]] = None,
                 notify_templates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleNotifyTemplateArgs', 'DispatchRuleNotifyTemplateArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Application Real-Time Monitoring Service (ARMS) Alert Dispatch Rule resource.

        For information about Application Real-Time Monitoring Service (ARMS) Alert Dispatch Rule and how to use it, see [What is Alert Dispatch_Rule](https://next.api.alibabacloud.com/document/ARMS/2019-08-08/CreateDispatchRule).

        > **NOTE:** Available since v1.136.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.arms.AlertContact("default",
            alert_contact_name="example_value",
            email="example_value@aaa.com")
        default_alert_contact_group = alicloud.arms.AlertContactGroup("default",
            alert_contact_group_name="example_value",
            contact_ids=[default.id])
        default_dispatch_rule = alicloud.arms.DispatchRule("default",
            dispatch_rule_name="example_value",
            dispatch_type="CREATE_ALERT",
            group_rules=[{
                "group_wait_time": 5,
                "group_interval": 15,
                "repeat_interval": 100,
                "grouping_fields": ["alertname"],
            }],
            label_match_expression_grids=[{
                "label_match_expression_groups": [{
                    "label_match_expressions": [{
                        "key": "_aliyun_arms_involvedObject_kind",
                        "value": "app",
                        "operator": "eq",
                    }],
                }],
            }],
            notify_rules=[{
                "notify_objects": [
                    {
                        "notify_object_id": default.id,
                        "notify_type": "ARMS_CONTACT",
                        "name": "example_value",
                    },
                    {
                        "notify_object_id": default_alert_contact_group.id,
                        "notify_type": "ARMS_CONTACT_GROUP",
                        "name": "example_value",
                    },
                ],
                "notify_channels": [
                    "dingTalk",
                    "wechat",
                ],
                "notify_start_time": "10:00",
                "notify_end_time": "23:00",
            }],
            notify_templates=[{
                "email_title": "example_email_title",
                "email_content": "example_email_content",
                "email_recover_title": "example_email_recover_title",
                "email_recover_content": "example_email_recover_content",
                "sms_content": "example_sms_content",
                "sms_recover_content": "example_sms_recover_content",
                "tts_content": "example_tts_content",
                "tts_recover_content": "example_tts_recover_content",
                "robot_content": "example_robot_content",
            }])
        ```

        ## Import

        Application Real-Time Monitoring Service (ARMS) Alert Contact can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/dispatchRule:DispatchRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dispatch_rule_name: The name of the dispatch policy.
        :param pulumi.Input[_builtins.str] dispatch_type: The alert handling method. Valid values: CREATE_ALERT: generates an alert. DISCARD_ALERT: discards the alert event and generates no alert.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleGroupRuleArgs', 'DispatchRuleGroupRuleArgsDict']]]] group_rules: Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        :param pulumi.Input[_builtins.bool] is_recover: Specifies whether to send the restored alert. Valid values: true: sends the alert. false: does not send the alert.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleLabelMatchExpressionGridArgs', 'DispatchRuleLabelMatchExpressionGridArgsDict']]]] label_match_expression_grids: Sets the dispatch rule. See `label_match_expression_grid` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleNotifyRuleArgs', 'DispatchRuleNotifyRuleArgsDict']]]] notify_rules: Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleNotifyTemplateArgs', 'DispatchRuleNotifyTemplateArgsDict']]]] notify_templates: Sets the notification template. See `notify_template` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DispatchRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Real-Time Monitoring Service (ARMS) Alert Dispatch Rule resource.

        For information about Application Real-Time Monitoring Service (ARMS) Alert Dispatch Rule and how to use it, see [What is Alert Dispatch_Rule](https://next.api.alibabacloud.com/document/ARMS/2019-08-08/CreateDispatchRule).

        > **NOTE:** Available since v1.136.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.arms.AlertContact("default",
            alert_contact_name="example_value",
            email="example_value@aaa.com")
        default_alert_contact_group = alicloud.arms.AlertContactGroup("default",
            alert_contact_group_name="example_value",
            contact_ids=[default.id])
        default_dispatch_rule = alicloud.arms.DispatchRule("default",
            dispatch_rule_name="example_value",
            dispatch_type="CREATE_ALERT",
            group_rules=[{
                "group_wait_time": 5,
                "group_interval": 15,
                "repeat_interval": 100,
                "grouping_fields": ["alertname"],
            }],
            label_match_expression_grids=[{
                "label_match_expression_groups": [{
                    "label_match_expressions": [{
                        "key": "_aliyun_arms_involvedObject_kind",
                        "value": "app",
                        "operator": "eq",
                    }],
                }],
            }],
            notify_rules=[{
                "notify_objects": [
                    {
                        "notify_object_id": default.id,
                        "notify_type": "ARMS_CONTACT",
                        "name": "example_value",
                    },
                    {
                        "notify_object_id": default_alert_contact_group.id,
                        "notify_type": "ARMS_CONTACT_GROUP",
                        "name": "example_value",
                    },
                ],
                "notify_channels": [
                    "dingTalk",
                    "wechat",
                ],
                "notify_start_time": "10:00",
                "notify_end_time": "23:00",
            }],
            notify_templates=[{
                "email_title": "example_email_title",
                "email_content": "example_email_content",
                "email_recover_title": "example_email_recover_title",
                "email_recover_content": "example_email_recover_content",
                "sms_content": "example_sms_content",
                "sms_recover_content": "example_sms_recover_content",
                "tts_content": "example_tts_content",
                "tts_recover_content": "example_tts_recover_content",
                "robot_content": "example_robot_content",
            }])
        ```

        ## Import

        Application Real-Time Monitoring Service (ARMS) Alert Contact can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/dispatchRule:DispatchRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DispatchRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DispatchRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dispatch_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dispatch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 group_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleGroupRuleArgs', 'DispatchRuleGroupRuleArgsDict']]]]] = None,
                 is_recover: Optional[pulumi.Input[_builtins.bool]] = None,
                 label_match_expression_grids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleLabelMatchExpressionGridArgs', 'DispatchRuleLabelMatchExpressionGridArgsDict']]]]] = None,
                 notify_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleNotifyRuleArgs', 'DispatchRuleNotifyRuleArgsDict']]]]] = None,
                 notify_templates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleNotifyTemplateArgs', 'DispatchRuleNotifyTemplateArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DispatchRuleArgs.__new__(DispatchRuleArgs)

            if dispatch_rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'dispatch_rule_name'")
            __props__.__dict__["dispatch_rule_name"] = dispatch_rule_name
            __props__.__dict__["dispatch_type"] = dispatch_type
            if group_rules is None and not opts.urn:
                raise TypeError("Missing required property 'group_rules'")
            __props__.__dict__["group_rules"] = group_rules
            __props__.__dict__["is_recover"] = is_recover
            if label_match_expression_grids is None and not opts.urn:
                raise TypeError("Missing required property 'label_match_expression_grids'")
            __props__.__dict__["label_match_expression_grids"] = label_match_expression_grids
            if notify_rules is None and not opts.urn:
                raise TypeError("Missing required property 'notify_rules'")
            __props__.__dict__["notify_rules"] = notify_rules
            __props__.__dict__["notify_templates"] = notify_templates
            __props__.__dict__["status"] = None
        super(DispatchRule, __self__).__init__(
            'alicloud:arms/dispatchRule:DispatchRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dispatch_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            dispatch_type: Optional[pulumi.Input[_builtins.str]] = None,
            group_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleGroupRuleArgs', 'DispatchRuleGroupRuleArgsDict']]]]] = None,
            is_recover: Optional[pulumi.Input[_builtins.bool]] = None,
            label_match_expression_grids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleLabelMatchExpressionGridArgs', 'DispatchRuleLabelMatchExpressionGridArgsDict']]]]] = None,
            notify_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleNotifyRuleArgs', 'DispatchRuleNotifyRuleArgsDict']]]]] = None,
            notify_templates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleNotifyTemplateArgs', 'DispatchRuleNotifyTemplateArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'DispatchRule':
        """
        Get an existing DispatchRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dispatch_rule_name: The name of the dispatch policy.
        :param pulumi.Input[_builtins.str] dispatch_type: The alert handling method. Valid values: CREATE_ALERT: generates an alert. DISCARD_ALERT: discards the alert event and generates no alert.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleGroupRuleArgs', 'DispatchRuleGroupRuleArgsDict']]]] group_rules: Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        :param pulumi.Input[_builtins.bool] is_recover: Specifies whether to send the restored alert. Valid values: true: sends the alert. false: does not send the alert.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleLabelMatchExpressionGridArgs', 'DispatchRuleLabelMatchExpressionGridArgsDict']]]] label_match_expression_grids: Sets the dispatch rule. See `label_match_expression_grid` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleNotifyRuleArgs', 'DispatchRuleNotifyRuleArgsDict']]]] notify_rules: Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DispatchRuleNotifyTemplateArgs', 'DispatchRuleNotifyTemplateArgsDict']]]] notify_templates: Sets the notification template. See `notify_template` below.
        :param pulumi.Input[_builtins.str] status: The resource status of Alert Dispatch Rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DispatchRuleState.__new__(_DispatchRuleState)

        __props__.__dict__["dispatch_rule_name"] = dispatch_rule_name
        __props__.__dict__["dispatch_type"] = dispatch_type
        __props__.__dict__["group_rules"] = group_rules
        __props__.__dict__["is_recover"] = is_recover
        __props__.__dict__["label_match_expression_grids"] = label_match_expression_grids
        __props__.__dict__["notify_rules"] = notify_rules
        __props__.__dict__["notify_templates"] = notify_templates
        __props__.__dict__["status"] = status
        return DispatchRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dispatchRuleName")
    def dispatch_rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the dispatch policy.
        """
        return pulumi.get(self, "dispatch_rule_name")

    @_builtins.property
    @pulumi.getter(name="dispatchType")
    def dispatch_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The alert handling method. Valid values: CREATE_ALERT: generates an alert. DISCARD_ALERT: discards the alert event and generates no alert.
        """
        return pulumi.get(self, "dispatch_type")

    @_builtins.property
    @pulumi.getter(name="groupRules")
    def group_rules(self) -> pulumi.Output[Sequence['outputs.DispatchRuleGroupRule']]:
        """
        Sets the event group. See `group_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        """
        return pulumi.get(self, "group_rules")

    @_builtins.property
    @pulumi.getter(name="isRecover")
    def is_recover(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to send the restored alert. Valid values: true: sends the alert. false: does not send the alert.
        """
        return pulumi.get(self, "is_recover")

    @_builtins.property
    @pulumi.getter(name="labelMatchExpressionGrids")
    def label_match_expression_grids(self) -> pulumi.Output[Sequence['outputs.DispatchRuleLabelMatchExpressionGrid']]:
        """
        Sets the dispatch rule. See `label_match_expression_grid` below.
        """
        return pulumi.get(self, "label_match_expression_grids")

    @_builtins.property
    @pulumi.getter(name="notifyRules")
    def notify_rules(self) -> pulumi.Output[Sequence['outputs.DispatchRuleNotifyRule']]:
        """
        Sets the notification rule. See `notify_rules` below. It will be ignored  when `dispatch_type = "DISCARD_ALERT"`.
        """
        return pulumi.get(self, "notify_rules")

    @_builtins.property
    @pulumi.getter(name="notifyTemplates")
    def notify_templates(self) -> pulumi.Output[Optional[Sequence['outputs.DispatchRuleNotifyTemplate']]]:
        """
        Sets the notification template. See `notify_template` below.
        """
        return pulumi.get(self, "notify_templates")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The resource status of Alert Dispatch Rule.
        """
        return pulumi.get(self, "status")

