# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SyntheticTaskArgs', 'SyntheticTask']

@pulumi.input_type
class SyntheticTaskArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input[_builtins.str],
                 monitor_category: pulumi.Input[_builtins.int],
                 monitor_conf: pulumi.Input['SyntheticTaskMonitorConfArgs'],
                 monitors: pulumi.Input[Sequence[pulumi.Input['SyntheticTaskMonitorArgs']]],
                 synthetic_task_name: pulumi.Input[_builtins.str],
                 task_type: pulumi.Input[_builtins.int],
                 available_assertions: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticTaskAvailableAssertionArgs']]]] = None,
                 common_setting: Optional[pulumi.Input['SyntheticTaskCommonSettingArgs']] = None,
                 custom_period: Optional[pulumi.Input['SyntheticTaskCustomPeriodArgs']] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SyntheticTask resource.
        :param pulumi.Input[_builtins.str] frequency: Frequency.
        :param pulumi.Input[_builtins.int] monitor_category: Classification of selected monitors.
        :param pulumi.Input['SyntheticTaskMonitorConfArgs'] monitor_conf: Monitoring configuration. See `monitor_conf` below.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticTaskMonitorArgs']]] monitors: List of selected monitors. See `monitors` below.
        :param pulumi.Input[_builtins.str] synthetic_task_name: The name of synthetic task.
        :param pulumi.Input[_builtins.int] task_type: The type of synthetic task.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticTaskAvailableAssertionArgs']]] available_assertions: Assertion List. See `available_assertions` below.
        :param pulumi.Input['SyntheticTaskCommonSettingArgs'] common_setting: Common settings. See `common_setting` below.
        :param pulumi.Input['SyntheticTaskCustomPeriodArgs'] custom_period: Custom Cycle. See `custom_period` below.
        :param pulumi.Input[_builtins.str] resource_group_id: Describes which resource group the resource belongs.
        :param pulumi.Input[_builtins.str] status: task status.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags.
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "monitor_category", monitor_category)
        pulumi.set(__self__, "monitor_conf", monitor_conf)
        pulumi.set(__self__, "monitors", monitors)
        pulumi.set(__self__, "synthetic_task_name", synthetic_task_name)
        pulumi.set(__self__, "task_type", task_type)
        if available_assertions is not None:
            pulumi.set(__self__, "available_assertions", available_assertions)
        if common_setting is not None:
            pulumi.set(__self__, "common_setting", common_setting)
        if custom_period is not None:
            pulumi.set(__self__, "custom_period", custom_period)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[_builtins.str]:
        """
        Frequency.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter(name="monitorCategory")
    def monitor_category(self) -> pulumi.Input[_builtins.int]:
        """
        Classification of selected monitors.
        """
        return pulumi.get(self, "monitor_category")

    @monitor_category.setter
    def monitor_category(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "monitor_category", value)

    @_builtins.property
    @pulumi.getter(name="monitorConf")
    def monitor_conf(self) -> pulumi.Input['SyntheticTaskMonitorConfArgs']:
        """
        Monitoring configuration. See `monitor_conf` below.
        """
        return pulumi.get(self, "monitor_conf")

    @monitor_conf.setter
    def monitor_conf(self, value: pulumi.Input['SyntheticTaskMonitorConfArgs']):
        pulumi.set(self, "monitor_conf", value)

    @_builtins.property
    @pulumi.getter
    def monitors(self) -> pulumi.Input[Sequence[pulumi.Input['SyntheticTaskMonitorArgs']]]:
        """
        List of selected monitors. See `monitors` below.
        """
        return pulumi.get(self, "monitors")

    @monitors.setter
    def monitors(self, value: pulumi.Input[Sequence[pulumi.Input['SyntheticTaskMonitorArgs']]]):
        pulumi.set(self, "monitors", value)

    @_builtins.property
    @pulumi.getter(name="syntheticTaskName")
    def synthetic_task_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of synthetic task.
        """
        return pulumi.get(self, "synthetic_task_name")

    @synthetic_task_name.setter
    def synthetic_task_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "synthetic_task_name", value)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[_builtins.int]:
        """
        The type of synthetic task.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "task_type", value)

    @_builtins.property
    @pulumi.getter(name="availableAssertions")
    def available_assertions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticTaskAvailableAssertionArgs']]]]:
        """
        Assertion List. See `available_assertions` below.
        """
        return pulumi.get(self, "available_assertions")

    @available_assertions.setter
    def available_assertions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticTaskAvailableAssertionArgs']]]]):
        pulumi.set(self, "available_assertions", value)

    @_builtins.property
    @pulumi.getter(name="commonSetting")
    def common_setting(self) -> Optional[pulumi.Input['SyntheticTaskCommonSettingArgs']]:
        """
        Common settings. See `common_setting` below.
        """
        return pulumi.get(self, "common_setting")

    @common_setting.setter
    def common_setting(self, value: Optional[pulumi.Input['SyntheticTaskCommonSettingArgs']]):
        pulumi.set(self, "common_setting", value)

    @_builtins.property
    @pulumi.getter(name="customPeriod")
    def custom_period(self) -> Optional[pulumi.Input['SyntheticTaskCustomPeriodArgs']]:
        """
        Custom Cycle. See `custom_period` below.
        """
        return pulumi.get(self, "custom_period")

    @custom_period.setter
    def custom_period(self, value: Optional[pulumi.Input['SyntheticTaskCustomPeriodArgs']]):
        pulumi.set(self, "custom_period", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes which resource group the resource belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        task status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SyntheticTaskState:
    def __init__(__self__, *,
                 available_assertions: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticTaskAvailableAssertionArgs']]]] = None,
                 common_setting: Optional[pulumi.Input['SyntheticTaskCommonSettingArgs']] = None,
                 custom_period: Optional[pulumi.Input['SyntheticTaskCustomPeriodArgs']] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_category: Optional[pulumi.Input[_builtins.int]] = None,
                 monitor_conf: Optional[pulumi.Input['SyntheticTaskMonitorConfArgs']] = None,
                 monitors: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticTaskMonitorArgs']]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 synthetic_task_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_type: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering SyntheticTask resources.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticTaskAvailableAssertionArgs']]] available_assertions: Assertion List. See `available_assertions` below.
        :param pulumi.Input['SyntheticTaskCommonSettingArgs'] common_setting: Common settings. See `common_setting` below.
        :param pulumi.Input['SyntheticTaskCustomPeriodArgs'] custom_period: Custom Cycle. See `custom_period` below.
        :param pulumi.Input[_builtins.str] frequency: Frequency.
        :param pulumi.Input[_builtins.int] monitor_category: Classification of selected monitors.
        :param pulumi.Input['SyntheticTaskMonitorConfArgs'] monitor_conf: Monitoring configuration. See `monitor_conf` below.
        :param pulumi.Input[Sequence[pulumi.Input['SyntheticTaskMonitorArgs']]] monitors: List of selected monitors. See `monitors` below.
        :param pulumi.Input[_builtins.str] resource_group_id: Describes which resource group the resource belongs.
        :param pulumi.Input[_builtins.str] status: task status.
        :param pulumi.Input[_builtins.str] synthetic_task_name: The name of synthetic task.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags.
        :param pulumi.Input[_builtins.int] task_type: The type of synthetic task.
        """
        if available_assertions is not None:
            pulumi.set(__self__, "available_assertions", available_assertions)
        if common_setting is not None:
            pulumi.set(__self__, "common_setting", common_setting)
        if custom_period is not None:
            pulumi.set(__self__, "custom_period", custom_period)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if monitor_category is not None:
            pulumi.set(__self__, "monitor_category", monitor_category)
        if monitor_conf is not None:
            pulumi.set(__self__, "monitor_conf", monitor_conf)
        if monitors is not None:
            pulumi.set(__self__, "monitors", monitors)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if synthetic_task_name is not None:
            pulumi.set(__self__, "synthetic_task_name", synthetic_task_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_type is not None:
            pulumi.set(__self__, "task_type", task_type)

    @_builtins.property
    @pulumi.getter(name="availableAssertions")
    def available_assertions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticTaskAvailableAssertionArgs']]]]:
        """
        Assertion List. See `available_assertions` below.
        """
        return pulumi.get(self, "available_assertions")

    @available_assertions.setter
    def available_assertions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticTaskAvailableAssertionArgs']]]]):
        pulumi.set(self, "available_assertions", value)

    @_builtins.property
    @pulumi.getter(name="commonSetting")
    def common_setting(self) -> Optional[pulumi.Input['SyntheticTaskCommonSettingArgs']]:
        """
        Common settings. See `common_setting` below.
        """
        return pulumi.get(self, "common_setting")

    @common_setting.setter
    def common_setting(self, value: Optional[pulumi.Input['SyntheticTaskCommonSettingArgs']]):
        pulumi.set(self, "common_setting", value)

    @_builtins.property
    @pulumi.getter(name="customPeriod")
    def custom_period(self) -> Optional[pulumi.Input['SyntheticTaskCustomPeriodArgs']]:
        """
        Custom Cycle. See `custom_period` below.
        """
        return pulumi.get(self, "custom_period")

    @custom_period.setter
    def custom_period(self, value: Optional[pulumi.Input['SyntheticTaskCustomPeriodArgs']]):
        pulumi.set(self, "custom_period", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Frequency.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter(name="monitorCategory")
    def monitor_category(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Classification of selected monitors.
        """
        return pulumi.get(self, "monitor_category")

    @monitor_category.setter
    def monitor_category(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "monitor_category", value)

    @_builtins.property
    @pulumi.getter(name="monitorConf")
    def monitor_conf(self) -> Optional[pulumi.Input['SyntheticTaskMonitorConfArgs']]:
        """
        Monitoring configuration. See `monitor_conf` below.
        """
        return pulumi.get(self, "monitor_conf")

    @monitor_conf.setter
    def monitor_conf(self, value: Optional[pulumi.Input['SyntheticTaskMonitorConfArgs']]):
        pulumi.set(self, "monitor_conf", value)

    @_builtins.property
    @pulumi.getter
    def monitors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticTaskMonitorArgs']]]]:
        """
        List of selected monitors. See `monitors` below.
        """
        return pulumi.get(self, "monitors")

    @monitors.setter
    def monitors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyntheticTaskMonitorArgs']]]]):
        pulumi.set(self, "monitors", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes which resource group the resource belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        task status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="syntheticTaskName")
    def synthetic_task_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of synthetic task.
        """
        return pulumi.get(self, "synthetic_task_name")

    @synthetic_task_name.setter
    def synthetic_task_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "synthetic_task_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The type of synthetic task.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "task_type", value)


@pulumi.type_token("alicloud:arms/syntheticTask:SyntheticTask")
class SyntheticTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_assertions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticTaskAvailableAssertionArgs', 'SyntheticTaskAvailableAssertionArgsDict']]]]] = None,
                 common_setting: Optional[pulumi.Input[Union['SyntheticTaskCommonSettingArgs', 'SyntheticTaskCommonSettingArgsDict']]] = None,
                 custom_period: Optional[pulumi.Input[Union['SyntheticTaskCustomPeriodArgs', 'SyntheticTaskCustomPeriodArgsDict']]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_category: Optional[pulumi.Input[_builtins.int]] = None,
                 monitor_conf: Optional[pulumi.Input[Union['SyntheticTaskMonitorConfArgs', 'SyntheticTaskMonitorConfArgsDict']]] = None,
                 monitors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticTaskMonitorArgs', 'SyntheticTaskMonitorArgsDict']]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 synthetic_task_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ARMS Synthetic Task resource. Cloud Synthetic task resources.

        For information about ARMS Synthetic Task and how to use it, see [What is Synthetic Task](https://next.api.alibabacloud.com/document/ARMS/2019-08-08/CreateTimingSyntheticTask).

        > **NOTE:** Available since v1.215.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_synthetic_task = alicloud.arms.SyntheticTask("default",
            monitors=[{
                "city_code": "1200101",
                "operator_code": "246",
                "client_type": 4,
            }],
            synthetic_task_name=name,
            custom_period={
                "end_hour": 12,
                "start_hour": 11,
            },
            available_assertions=[
                {
                    "type": "IcmpPackLoss",
                    "operator": "neq",
                    "expect": "200",
                    "target": "example",
                },
                {
                    "type": "IcmpPackAvgLatency",
                    "operator": "lte",
                    "expect": "1000",
                },
                {
                    "type": "IcmpPackMaxLatency",
                    "operator": "lte",
                    "expect": "10000",
                },
            ],
            tags={
                "Created": "TF",
                "For": "example",
            },
            status="RUNNING",
            monitor_conf={
                "net_tcp": {
                    "tracert_timeout": 1050,
                    "target_url": "www.aliyun.com",
                    "connect_times": 6,
                    "interval": 300,
                    "timeout": 3000,
                    "tracert_num_max": 2,
                },
                "net_dns": {
                    "query_method": 1,
                    "timeout": 5050,
                    "target_url": "www.aliyun.com",
                    "dns_server_ip_type": 1,
                    "ns_server": "61.128.114.167",
                },
                "api_http": {
                    "timeout": 10050,
                    "target_url": "https://www.aliyun.com",
                    "method": "POST",
                    "request_headers": {
                        "key1": "value1",
                    },
                    "request_body": {
                        "content": "example2",
                        "type": "text/html",
                    },
                    "connect_timeout": 6000,
                },
                "website": {
                    "slow_element_threshold": 5005,
                    "verify_string_blacklist": "Failed",
                    "element_blacklist": "a.jpg",
                    "disable_compression": 1,
                    "ignore_certificate_error": 0,
                    "monitor_timeout": 20000,
                    "redirection": 0,
                    "dns_hijack_whitelist": "www.aliyun.com:203.0.3.55",
                    "page_tamper": "www.aliyun.com:|/cc/bb/a.gif",
                    "flow_hijack_jump_times": 10,
                    "custom_header": 1,
                    "disable_cache": 1,
                    "verify_string_whitelist": "Senyuan",
                    "target_url": "http://www.aliyun.com",
                    "automatic_scrolling": 1,
                    "wait_completion_time": 5005,
                    "flow_hijack_logo": "senyuan1",
                    "custom_header_content": {
                        "key1": "value1",
                    },
                    "filter_invalid_ip": 0,
                },
                "file_download": {
                    "white_list": "www.aliyun.com:203.0.3.55",
                    "monitor_timeout": 1050,
                    "ignore_certificate_untrustworthy_error": 0,
                    "redirection": 0,
                    "ignore_certificate_canceled_error": 0,
                    "ignore_certificate_auth_error": 0,
                    "ignore_certificate_out_of_date_error": 0,
                    "ignore_certificate_using_error": 0,
                    "connection_timeout": 6090,
                    "ignore_invalid_host_error": 0,
                    "verify_way": 0,
                    "custom_header_content": {
                        "key1": "value1",
                    },
                    "target_url": "https://www.aliyun.com",
                    "download_kernel": 0,
                    "quick_protocol": 2,
                    "ignore_certificate_status_error": 1,
                    "transmission_size": 128,
                    "validate_keywords": "senyuan1",
                },
                "stream": {
                    "stream_monitor_timeout": 10,
                    "stream_address_type": 0,
                    "player_type": 2,
                    "custom_header_content": {
                        "key1": "value1",
                    },
                    "white_list": "www.aliyun.com:203.0.3.55",
                    "target_url": "https://acd-assets.alicdn.com:443/2021productweek/week1_s.mp4",
                    "stream_type": 1,
                },
                "net_icmp": {
                    "target_url": "www.aliyun.com",
                    "interval": 200,
                    "package_num": 36,
                    "package_size": 512,
                    "timeout": 1000,
                    "tracert_enable": True,
                    "tracert_num_max": 1,
                    "tracert_timeout": 1200,
                },
            },
            task_type=1,
            frequency="1h",
            monitor_category=1,
            common_setting={
                "xtrace_region": "cn-beijing",
                "custom_host": {
                    "hosts": [
                        {
                            "domain": "www.a.aliyun.com",
                            "ips": ["153.3.238.102"],
                            "ip_type": 0,
                        },
                        {
                            "domain": "www.shifen.com",
                            "ips": [
                                "153.3.238.110",
                                "114.114.114.114",
                                "127.0.0.1",
                            ],
                            "ip_type": 1,
                        },
                        {
                            "domain": "www.aliyun.com",
                            "ips": [
                                "153.3.238.110",
                                "180.101.50.242",
                                "180.101.50.188",
                            ],
                            "ip_type": 0,
                        },
                    ],
                    "select_type": 1,
                },
                "monitor_samples": 1,
                "ip_type": 1,
                "is_open_trace": True,
                "trace_client_type": 1,
            },
            resource_group_id=default.ids[0])
        ```

        ## Import

        ARMS Synthetic Task can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/syntheticTask:SyntheticTask example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticTaskAvailableAssertionArgs', 'SyntheticTaskAvailableAssertionArgsDict']]]] available_assertions: Assertion List. See `available_assertions` below.
        :param pulumi.Input[Union['SyntheticTaskCommonSettingArgs', 'SyntheticTaskCommonSettingArgsDict']] common_setting: Common settings. See `common_setting` below.
        :param pulumi.Input[Union['SyntheticTaskCustomPeriodArgs', 'SyntheticTaskCustomPeriodArgsDict']] custom_period: Custom Cycle. See `custom_period` below.
        :param pulumi.Input[_builtins.str] frequency: Frequency.
        :param pulumi.Input[_builtins.int] monitor_category: Classification of selected monitors.
        :param pulumi.Input[Union['SyntheticTaskMonitorConfArgs', 'SyntheticTaskMonitorConfArgsDict']] monitor_conf: Monitoring configuration. See `monitor_conf` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticTaskMonitorArgs', 'SyntheticTaskMonitorArgsDict']]]] monitors: List of selected monitors. See `monitors` below.
        :param pulumi.Input[_builtins.str] resource_group_id: Describes which resource group the resource belongs.
        :param pulumi.Input[_builtins.str] status: task status.
        :param pulumi.Input[_builtins.str] synthetic_task_name: The name of synthetic task.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags.
        :param pulumi.Input[_builtins.int] task_type: The type of synthetic task.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyntheticTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ARMS Synthetic Task resource. Cloud Synthetic task resources.

        For information about ARMS Synthetic Task and how to use it, see [What is Synthetic Task](https://next.api.alibabacloud.com/document/ARMS/2019-08-08/CreateTimingSyntheticTask).

        > **NOTE:** Available since v1.215.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_synthetic_task = alicloud.arms.SyntheticTask("default",
            monitors=[{
                "city_code": "1200101",
                "operator_code": "246",
                "client_type": 4,
            }],
            synthetic_task_name=name,
            custom_period={
                "end_hour": 12,
                "start_hour": 11,
            },
            available_assertions=[
                {
                    "type": "IcmpPackLoss",
                    "operator": "neq",
                    "expect": "200",
                    "target": "example",
                },
                {
                    "type": "IcmpPackAvgLatency",
                    "operator": "lte",
                    "expect": "1000",
                },
                {
                    "type": "IcmpPackMaxLatency",
                    "operator": "lte",
                    "expect": "10000",
                },
            ],
            tags={
                "Created": "TF",
                "For": "example",
            },
            status="RUNNING",
            monitor_conf={
                "net_tcp": {
                    "tracert_timeout": 1050,
                    "target_url": "www.aliyun.com",
                    "connect_times": 6,
                    "interval": 300,
                    "timeout": 3000,
                    "tracert_num_max": 2,
                },
                "net_dns": {
                    "query_method": 1,
                    "timeout": 5050,
                    "target_url": "www.aliyun.com",
                    "dns_server_ip_type": 1,
                    "ns_server": "61.128.114.167",
                },
                "api_http": {
                    "timeout": 10050,
                    "target_url": "https://www.aliyun.com",
                    "method": "POST",
                    "request_headers": {
                        "key1": "value1",
                    },
                    "request_body": {
                        "content": "example2",
                        "type": "text/html",
                    },
                    "connect_timeout": 6000,
                },
                "website": {
                    "slow_element_threshold": 5005,
                    "verify_string_blacklist": "Failed",
                    "element_blacklist": "a.jpg",
                    "disable_compression": 1,
                    "ignore_certificate_error": 0,
                    "monitor_timeout": 20000,
                    "redirection": 0,
                    "dns_hijack_whitelist": "www.aliyun.com:203.0.3.55",
                    "page_tamper": "www.aliyun.com:|/cc/bb/a.gif",
                    "flow_hijack_jump_times": 10,
                    "custom_header": 1,
                    "disable_cache": 1,
                    "verify_string_whitelist": "Senyuan",
                    "target_url": "http://www.aliyun.com",
                    "automatic_scrolling": 1,
                    "wait_completion_time": 5005,
                    "flow_hijack_logo": "senyuan1",
                    "custom_header_content": {
                        "key1": "value1",
                    },
                    "filter_invalid_ip": 0,
                },
                "file_download": {
                    "white_list": "www.aliyun.com:203.0.3.55",
                    "monitor_timeout": 1050,
                    "ignore_certificate_untrustworthy_error": 0,
                    "redirection": 0,
                    "ignore_certificate_canceled_error": 0,
                    "ignore_certificate_auth_error": 0,
                    "ignore_certificate_out_of_date_error": 0,
                    "ignore_certificate_using_error": 0,
                    "connection_timeout": 6090,
                    "ignore_invalid_host_error": 0,
                    "verify_way": 0,
                    "custom_header_content": {
                        "key1": "value1",
                    },
                    "target_url": "https://www.aliyun.com",
                    "download_kernel": 0,
                    "quick_protocol": 2,
                    "ignore_certificate_status_error": 1,
                    "transmission_size": 128,
                    "validate_keywords": "senyuan1",
                },
                "stream": {
                    "stream_monitor_timeout": 10,
                    "stream_address_type": 0,
                    "player_type": 2,
                    "custom_header_content": {
                        "key1": "value1",
                    },
                    "white_list": "www.aliyun.com:203.0.3.55",
                    "target_url": "https://acd-assets.alicdn.com:443/2021productweek/week1_s.mp4",
                    "stream_type": 1,
                },
                "net_icmp": {
                    "target_url": "www.aliyun.com",
                    "interval": 200,
                    "package_num": 36,
                    "package_size": 512,
                    "timeout": 1000,
                    "tracert_enable": True,
                    "tracert_num_max": 1,
                    "tracert_timeout": 1200,
                },
            },
            task_type=1,
            frequency="1h",
            monitor_category=1,
            common_setting={
                "xtrace_region": "cn-beijing",
                "custom_host": {
                    "hosts": [
                        {
                            "domain": "www.a.aliyun.com",
                            "ips": ["153.3.238.102"],
                            "ip_type": 0,
                        },
                        {
                            "domain": "www.shifen.com",
                            "ips": [
                                "153.3.238.110",
                                "114.114.114.114",
                                "127.0.0.1",
                            ],
                            "ip_type": 1,
                        },
                        {
                            "domain": "www.aliyun.com",
                            "ips": [
                                "153.3.238.110",
                                "180.101.50.242",
                                "180.101.50.188",
                            ],
                            "ip_type": 0,
                        },
                    ],
                    "select_type": 1,
                },
                "monitor_samples": 1,
                "ip_type": 1,
                "is_open_trace": True,
                "trace_client_type": 1,
            },
            resource_group_id=default.ids[0])
        ```

        ## Import

        ARMS Synthetic Task can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/syntheticTask:SyntheticTask example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SyntheticTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyntheticTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_assertions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticTaskAvailableAssertionArgs', 'SyntheticTaskAvailableAssertionArgsDict']]]]] = None,
                 common_setting: Optional[pulumi.Input[Union['SyntheticTaskCommonSettingArgs', 'SyntheticTaskCommonSettingArgsDict']]] = None,
                 custom_period: Optional[pulumi.Input[Union['SyntheticTaskCustomPeriodArgs', 'SyntheticTaskCustomPeriodArgsDict']]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_category: Optional[pulumi.Input[_builtins.int]] = None,
                 monitor_conf: Optional[pulumi.Input[Union['SyntheticTaskMonitorConfArgs', 'SyntheticTaskMonitorConfArgsDict']]] = None,
                 monitors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticTaskMonitorArgs', 'SyntheticTaskMonitorArgsDict']]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 synthetic_task_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyntheticTaskArgs.__new__(SyntheticTaskArgs)

            __props__.__dict__["available_assertions"] = available_assertions
            __props__.__dict__["common_setting"] = common_setting
            __props__.__dict__["custom_period"] = custom_period
            if frequency is None and not opts.urn:
                raise TypeError("Missing required property 'frequency'")
            __props__.__dict__["frequency"] = frequency
            if monitor_category is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_category'")
            __props__.__dict__["monitor_category"] = monitor_category
            if monitor_conf is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_conf'")
            __props__.__dict__["monitor_conf"] = monitor_conf
            if monitors is None and not opts.urn:
                raise TypeError("Missing required property 'monitors'")
            __props__.__dict__["monitors"] = monitors
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["status"] = status
            if synthetic_task_name is None and not opts.urn:
                raise TypeError("Missing required property 'synthetic_task_name'")
            __props__.__dict__["synthetic_task_name"] = synthetic_task_name
            __props__.__dict__["tags"] = tags
            if task_type is None and not opts.urn:
                raise TypeError("Missing required property 'task_type'")
            __props__.__dict__["task_type"] = task_type
        super(SyntheticTask, __self__).__init__(
            'alicloud:arms/syntheticTask:SyntheticTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            available_assertions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticTaskAvailableAssertionArgs', 'SyntheticTaskAvailableAssertionArgsDict']]]]] = None,
            common_setting: Optional[pulumi.Input[Union['SyntheticTaskCommonSettingArgs', 'SyntheticTaskCommonSettingArgsDict']]] = None,
            custom_period: Optional[pulumi.Input[Union['SyntheticTaskCustomPeriodArgs', 'SyntheticTaskCustomPeriodArgsDict']]] = None,
            frequency: Optional[pulumi.Input[_builtins.str]] = None,
            monitor_category: Optional[pulumi.Input[_builtins.int]] = None,
            monitor_conf: Optional[pulumi.Input[Union['SyntheticTaskMonitorConfArgs', 'SyntheticTaskMonitorConfArgsDict']]] = None,
            monitors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyntheticTaskMonitorArgs', 'SyntheticTaskMonitorArgsDict']]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            synthetic_task_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            task_type: Optional[pulumi.Input[_builtins.int]] = None) -> 'SyntheticTask':
        """
        Get an existing SyntheticTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticTaskAvailableAssertionArgs', 'SyntheticTaskAvailableAssertionArgsDict']]]] available_assertions: Assertion List. See `available_assertions` below.
        :param pulumi.Input[Union['SyntheticTaskCommonSettingArgs', 'SyntheticTaskCommonSettingArgsDict']] common_setting: Common settings. See `common_setting` below.
        :param pulumi.Input[Union['SyntheticTaskCustomPeriodArgs', 'SyntheticTaskCustomPeriodArgsDict']] custom_period: Custom Cycle. See `custom_period` below.
        :param pulumi.Input[_builtins.str] frequency: Frequency.
        :param pulumi.Input[_builtins.int] monitor_category: Classification of selected monitors.
        :param pulumi.Input[Union['SyntheticTaskMonitorConfArgs', 'SyntheticTaskMonitorConfArgsDict']] monitor_conf: Monitoring configuration. See `monitor_conf` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyntheticTaskMonitorArgs', 'SyntheticTaskMonitorArgsDict']]]] monitors: List of selected monitors. See `monitors` below.
        :param pulumi.Input[_builtins.str] resource_group_id: Describes which resource group the resource belongs.
        :param pulumi.Input[_builtins.str] status: task status.
        :param pulumi.Input[_builtins.str] synthetic_task_name: The name of synthetic task.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags.
        :param pulumi.Input[_builtins.int] task_type: The type of synthetic task.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyntheticTaskState.__new__(_SyntheticTaskState)

        __props__.__dict__["available_assertions"] = available_assertions
        __props__.__dict__["common_setting"] = common_setting
        __props__.__dict__["custom_period"] = custom_period
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["monitor_category"] = monitor_category
        __props__.__dict__["monitor_conf"] = monitor_conf
        __props__.__dict__["monitors"] = monitors
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["synthetic_task_name"] = synthetic_task_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["task_type"] = task_type
        return SyntheticTask(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availableAssertions")
    def available_assertions(self) -> pulumi.Output[Optional[Sequence['outputs.SyntheticTaskAvailableAssertion']]]:
        """
        Assertion List. See `available_assertions` below.
        """
        return pulumi.get(self, "available_assertions")

    @_builtins.property
    @pulumi.getter(name="commonSetting")
    def common_setting(self) -> pulumi.Output['outputs.SyntheticTaskCommonSetting']:
        """
        Common settings. See `common_setting` below.
        """
        return pulumi.get(self, "common_setting")

    @_builtins.property
    @pulumi.getter(name="customPeriod")
    def custom_period(self) -> pulumi.Output[Optional['outputs.SyntheticTaskCustomPeriod']]:
        """
        Custom Cycle. See `custom_period` below.
        """
        return pulumi.get(self, "custom_period")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[_builtins.str]:
        """
        Frequency.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter(name="monitorCategory")
    def monitor_category(self) -> pulumi.Output[_builtins.int]:
        """
        Classification of selected monitors.
        """
        return pulumi.get(self, "monitor_category")

    @_builtins.property
    @pulumi.getter(name="monitorConf")
    def monitor_conf(self) -> pulumi.Output['outputs.SyntheticTaskMonitorConf']:
        """
        Monitoring configuration. See `monitor_conf` below.
        """
        return pulumi.get(self, "monitor_conf")

    @_builtins.property
    @pulumi.getter
    def monitors(self) -> pulumi.Output[Sequence['outputs.SyntheticTaskMonitor']]:
        """
        List of selected monitors. See `monitors` below.
        """
        return pulumi.get(self, "monitors")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Describes which resource group the resource belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        task status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="syntheticTaskName")
    def synthetic_task_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of synthetic task.
        """
        return pulumi.get(self, "synthetic_task_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The list of tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Output[_builtins.int]:
        """
        The type of synthetic task.
        """
        return pulumi.get(self, "task_type")

