# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceAdAuthServer',
    'InstanceLdapAuthServer',
    'GetHostAccountsAccountResult',
    'GetHostGroupsGroupResult',
    'GetHostShareKeysKeyResult',
    'GetHostsHostResult',
    'GetHostsHostProtocolResult',
    'GetInstancesInstanceResult',
    'GetUserGroupsGroupResult',
    'GetUsersUserResult',
]

@pulumi.output_type
class InstanceAdAuthServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseDn":
            suggest = "base_dn"
        elif key == "isSsl":
            suggest = "is_ssl"
        elif key == "emailMapping":
            suggest = "email_mapping"
        elif key == "mobileMapping":
            suggest = "mobile_mapping"
        elif key == "nameMapping":
            suggest = "name_mapping"
        elif key == "standbyServer":
            suggest = "standby_server"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAdAuthServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAdAuthServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAdAuthServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account: _builtins.str,
                 base_dn: _builtins.str,
                 domain: _builtins.str,
                 is_ssl: _builtins.bool,
                 port: _builtins.int,
                 server: _builtins.str,
                 email_mapping: Optional[_builtins.str] = None,
                 filter: Optional[_builtins.str] = None,
                 mobile_mapping: Optional[_builtins.str] = None,
                 name_mapping: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 standby_server: Optional[_builtins.str] = None):
        """
        :param _builtins.str account: The username of the account that is used for the AD server.
        :param _builtins.str base_dn: The Base distinguished name (DN).
        :param _builtins.str domain: The domain on the AD server.
        :param _builtins.bool is_ssl: Specifies whether to support SSL.
        :param _builtins.int port: The port that is used to access the AD server.
        :param _builtins.str server: The address of the AD server.
        :param _builtins.str email_mapping: The field that is used to indicate the email address of a user on the AD server.
        :param _builtins.str filter: The condition that is used to filter users.
        :param _builtins.str mobile_mapping: The field that is used to indicate the mobile phone number of a user on the AD server.
        :param _builtins.str name_mapping: The field that is used to indicate the name of a user on the AD server.
        :param _builtins.str password: The password of the account that is used for the AD server.
        :param _builtins.str standby_server: The address of the secondary AD server.
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "base_dn", base_dn)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "is_ssl", is_ssl)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server", server)
        if email_mapping is not None:
            pulumi.set(__self__, "email_mapping", email_mapping)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if mobile_mapping is not None:
            pulumi.set(__self__, "mobile_mapping", mobile_mapping)
        if name_mapping is not None:
            pulumi.set(__self__, "name_mapping", name_mapping)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if standby_server is not None:
            pulumi.set(__self__, "standby_server", standby_server)

    @_builtins.property
    @pulumi.getter
    def account(self) -> _builtins.str:
        """
        The username of the account that is used for the AD server.
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter(name="baseDn")
    def base_dn(self) -> _builtins.str:
        """
        The Base distinguished name (DN).
        """
        return pulumi.get(self, "base_dn")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain on the AD server.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="isSsl")
    def is_ssl(self) -> _builtins.bool:
        """
        Specifies whether to support SSL.
        """
        return pulumi.get(self, "is_ssl")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port that is used to access the AD server.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The address of the AD server.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="emailMapping")
    def email_mapping(self) -> Optional[_builtins.str]:
        """
        The field that is used to indicate the email address of a user on the AD server.
        """
        return pulumi.get(self, "email_mapping")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        """
        The condition that is used to filter users.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="mobileMapping")
    def mobile_mapping(self) -> Optional[_builtins.str]:
        """
        The field that is used to indicate the mobile phone number of a user on the AD server.
        """
        return pulumi.get(self, "mobile_mapping")

    @_builtins.property
    @pulumi.getter(name="nameMapping")
    def name_mapping(self) -> Optional[_builtins.str]:
        """
        The field that is used to indicate the name of a user on the AD server.
        """
        return pulumi.get(self, "name_mapping")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password of the account that is used for the AD server.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="standbyServer")
    def standby_server(self) -> Optional[_builtins.str]:
        """
        The address of the secondary AD server.
        """
        return pulumi.get(self, "standby_server")


@pulumi.output_type
class InstanceLdapAuthServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseDn":
            suggest = "base_dn"
        elif key == "emailMapping":
            suggest = "email_mapping"
        elif key == "isSsl":
            suggest = "is_ssl"
        elif key == "loginNameMapping":
            suggest = "login_name_mapping"
        elif key == "mobileMapping":
            suggest = "mobile_mapping"
        elif key == "nameMapping":
            suggest = "name_mapping"
        elif key == "standbyServer":
            suggest = "standby_server"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceLdapAuthServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceLdapAuthServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceLdapAuthServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account: _builtins.str,
                 base_dn: _builtins.str,
                 port: _builtins.int,
                 server: _builtins.str,
                 email_mapping: Optional[_builtins.str] = None,
                 filter: Optional[_builtins.str] = None,
                 is_ssl: Optional[_builtins.bool] = None,
                 login_name_mapping: Optional[_builtins.str] = None,
                 mobile_mapping: Optional[_builtins.str] = None,
                 name_mapping: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 standby_server: Optional[_builtins.str] = None):
        """
        :param _builtins.str account: The username of the account that is used for the LDAP server.
        :param _builtins.str base_dn: The Base distinguished name (DN).
        :param _builtins.int port: The port that is used to access the LDAP server.
        :param _builtins.str server: The address of the LDAP server.
        :param _builtins.str email_mapping: The field that is used to indicate the email address of a user on the LDAP server.
        :param _builtins.str filter: The condition that is used to filter users.
        :param _builtins.bool is_ssl: Specifies whether to support SSL.
        :param _builtins.str login_name_mapping: The field that is used to indicate the logon name of a user on the LDAP server.
        :param _builtins.str mobile_mapping: The field that is used to indicate the mobile phone number of a user on the LDAP server.
        :param _builtins.str name_mapping: The field that is used to indicate the name of a user on the LDAP server.
        :param _builtins.str password: The password of the account that is used for the LDAP server.
        :param _builtins.str standby_server: The address of the secondary LDAP server.
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "base_dn", base_dn)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server", server)
        if email_mapping is not None:
            pulumi.set(__self__, "email_mapping", email_mapping)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if is_ssl is not None:
            pulumi.set(__self__, "is_ssl", is_ssl)
        if login_name_mapping is not None:
            pulumi.set(__self__, "login_name_mapping", login_name_mapping)
        if mobile_mapping is not None:
            pulumi.set(__self__, "mobile_mapping", mobile_mapping)
        if name_mapping is not None:
            pulumi.set(__self__, "name_mapping", name_mapping)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if standby_server is not None:
            pulumi.set(__self__, "standby_server", standby_server)

    @_builtins.property
    @pulumi.getter
    def account(self) -> _builtins.str:
        """
        The username of the account that is used for the LDAP server.
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter(name="baseDn")
    def base_dn(self) -> _builtins.str:
        """
        The Base distinguished name (DN).
        """
        return pulumi.get(self, "base_dn")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port that is used to access the LDAP server.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The address of the LDAP server.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="emailMapping")
    def email_mapping(self) -> Optional[_builtins.str]:
        """
        The field that is used to indicate the email address of a user on the LDAP server.
        """
        return pulumi.get(self, "email_mapping")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        """
        The condition that is used to filter users.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="isSsl")
    def is_ssl(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to support SSL.
        """
        return pulumi.get(self, "is_ssl")

    @_builtins.property
    @pulumi.getter(name="loginNameMapping")
    def login_name_mapping(self) -> Optional[_builtins.str]:
        """
        The field that is used to indicate the logon name of a user on the LDAP server.
        """
        return pulumi.get(self, "login_name_mapping")

    @_builtins.property
    @pulumi.getter(name="mobileMapping")
    def mobile_mapping(self) -> Optional[_builtins.str]:
        """
        The field that is used to indicate the mobile phone number of a user on the LDAP server.
        """
        return pulumi.get(self, "mobile_mapping")

    @_builtins.property
    @pulumi.getter(name="nameMapping")
    def name_mapping(self) -> Optional[_builtins.str]:
        """
        The field that is used to indicate the name of a user on the LDAP server.
        """
        return pulumi.get(self, "name_mapping")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password of the account that is used for the LDAP server.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="standbyServer")
    def standby_server(self) -> Optional[_builtins.str]:
        """
        The address of the secondary LDAP server.
        """
        return pulumi.get(self, "standby_server")


@pulumi.output_type
class GetHostAccountsAccountResult(dict):
    def __init__(__self__, *,
                 has_password: _builtins.bool,
                 host_account_id: _builtins.str,
                 host_account_name: _builtins.str,
                 host_id: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 private_key_fingerprint: _builtins.str,
                 protocol_name: _builtins.str):
        """
        :param _builtins.bool has_password: Whether to set a new password.
        :param _builtins.str host_account_id: Hosting account ID.
        :param _builtins.str host_account_name: Specify the new hosting account's name, support the longest 128 characters.
        :param _builtins.str host_id: Specifies the database where you want to create your hosting account's host ID.
        :param _builtins.str id: The ID of the Host Account.
        :param _builtins.str instance_id: Specifies the database where you want to create your hosting account's host bastion host ID of.
        :param _builtins.str private_key_fingerprint: The situation where the private keys of the fingerprint information.
        :param _builtins.str protocol_name: Specify the new hosting account of the agreement name. Valid values: USING SSH and RDP.
        """
        pulumi.set(__self__, "has_password", has_password)
        pulumi.set(__self__, "host_account_id", host_account_id)
        pulumi.set(__self__, "host_account_name", host_account_name)
        pulumi.set(__self__, "host_id", host_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "private_key_fingerprint", private_key_fingerprint)
        pulumi.set(__self__, "protocol_name", protocol_name)

    @_builtins.property
    @pulumi.getter(name="hasPassword")
    def has_password(self) -> _builtins.bool:
        """
        Whether to set a new password.
        """
        return pulumi.get(self, "has_password")

    @_builtins.property
    @pulumi.getter(name="hostAccountId")
    def host_account_id(self) -> _builtins.str:
        """
        Hosting account ID.
        """
        return pulumi.get(self, "host_account_id")

    @_builtins.property
    @pulumi.getter(name="hostAccountName")
    def host_account_name(self) -> _builtins.str:
        """
        Specify the new hosting account's name, support the longest 128 characters.
        """
        return pulumi.get(self, "host_account_name")

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> _builtins.str:
        """
        Specifies the database where you want to create your hosting account's host ID.
        """
        return pulumi.get(self, "host_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Host Account.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Specifies the database where you want to create your hosting account's host bastion host ID of.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="privateKeyFingerprint")
    def private_key_fingerprint(self) -> _builtins.str:
        """
        The situation where the private keys of the fingerprint information.
        """
        return pulumi.get(self, "private_key_fingerprint")

    @_builtins.property
    @pulumi.getter(name="protocolName")
    def protocol_name(self) -> _builtins.str:
        """
        Specify the new hosting account of the agreement name. Valid values: USING SSH and RDP.
        """
        return pulumi.get(self, "protocol_name")


@pulumi.output_type
class GetHostGroupsGroupResult(dict):
    def __init__(__self__, *,
                 comment: _builtins.str,
                 host_group_id: _builtins.str,
                 host_group_name: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str):
        """
        :param _builtins.str comment: Specify the New Host Group of Notes, Supports up to 500 Characters.
        :param _builtins.str host_group_id: Host Group ID.
        :param _builtins.str host_group_name: Specify the New Host Group Name, Supports up to 128 Characters.
        :param _builtins.str id: The ID of the Host Group.
        :param _builtins.str instance_id: Specify the New Host Group Where the Bastion Host ID of.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "host_group_id", host_group_id)
        pulumi.set(__self__, "host_group_name", host_group_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Specify the New Host Group of Notes, Supports up to 500 Characters.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> _builtins.str:
        """
        Host Group ID.
        """
        return pulumi.get(self, "host_group_id")

    @_builtins.property
    @pulumi.getter(name="hostGroupName")
    def host_group_name(self) -> _builtins.str:
        """
        Specify the New Host Group Name, Supports up to 128 Characters.
        """
        return pulumi.get(self, "host_group_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Host Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Specify the New Host Group Where the Bastion Host ID of.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class GetHostShareKeysKeyResult(dict):
    def __init__(__self__, *,
                 host_share_key_id: _builtins.str,
                 host_share_key_name: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 private_key_finger_print: _builtins.str):
        """
        :param _builtins.str host_share_key_id: The first ID of the resource.
        :param _builtins.str host_share_key_name: The name of the host shared key.
        :param _builtins.str id: The ID of the Host Share Key.
        :param _builtins.str instance_id: The ID of the Bastion instance.
        :param _builtins.str private_key_finger_print: The fingerprint of the private key.
        """
        pulumi.set(__self__, "host_share_key_id", host_share_key_id)
        pulumi.set(__self__, "host_share_key_name", host_share_key_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "private_key_finger_print", private_key_finger_print)

    @_builtins.property
    @pulumi.getter(name="hostShareKeyId")
    def host_share_key_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "host_share_key_id")

    @_builtins.property
    @pulumi.getter(name="hostShareKeyName")
    def host_share_key_name(self) -> _builtins.str:
        """
        The name of the host shared key.
        """
        return pulumi.get(self, "host_share_key_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Host Share Key.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the Bastion instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="privateKeyFingerPrint")
    def private_key_finger_print(self) -> _builtins.str:
        """
        The fingerprint of the private key.
        """
        return pulumi.get(self, "private_key_finger_print")


@pulumi.output_type
class GetHostsHostResult(dict):
    def __init__(__self__, *,
                 active_address_type: _builtins.str,
                 comment: _builtins.str,
                 host_id: _builtins.str,
                 host_name: _builtins.str,
                 host_private_address: _builtins.str,
                 host_public_address: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 os_type: _builtins.str,
                 protocols: Sequence['outputs.GetHostsHostProtocolResult'],
                 source: _builtins.str,
                 source_instance_id: _builtins.str):
        """
        :param _builtins.str active_address_type: Specify the new create a host of address types. Valid values: Public: the IP address of a Public network Private: Private network address.
        :param _builtins.str comment: Specify a host of notes, supports up to 500 characters.
        :param _builtins.str host_id: The host ID.
        :param _builtins.str host_name: Specify the new create a host name of the supports up to 128 characters.
        :param _builtins.str host_private_address: Specify the new create a host of the private network address, it is possible to use the domain name or IP ADDRESS.
        :param _builtins.str host_public_address: Specify the new create a host of the IP address of a public network, it is possible to use the domain name or IP ADDRESS.
        :param _builtins.str id: The ID of the Host.
        :param _builtins.str instance_id: Specify the new create a host where the Bastion host ID of.
        :param _builtins.str os_type: Specify the new create the host's operating system. Valid values: Linux Windows.
        :param Sequence['GetHostsHostProtocolArgs'] protocols: The host of the protocol information.
        :param _builtins.str source: Specify the new create a host of source. Valid values: Local: localhost Ecs:ECS instance Rds:RDS exclusive cluster host.
        :param _builtins.str source_instance_id: Specify the newly created ECS instance ID or dedicated cluster host ID.
        """
        pulumi.set(__self__, "active_address_type", active_address_type)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "host_id", host_id)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "host_private_address", host_private_address)
        pulumi.set(__self__, "host_public_address", host_public_address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_instance_id", source_instance_id)

    @_builtins.property
    @pulumi.getter(name="activeAddressType")
    def active_address_type(self) -> _builtins.str:
        """
        Specify the new create a host of address types. Valid values: Public: the IP address of a Public network Private: Private network address.
        """
        return pulumi.get(self, "active_address_type")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Specify a host of notes, supports up to 500 characters.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> _builtins.str:
        """
        The host ID.
        """
        return pulumi.get(self, "host_id")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        Specify the new create a host name of the supports up to 128 characters.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="hostPrivateAddress")
    def host_private_address(self) -> _builtins.str:
        """
        Specify the new create a host of the private network address, it is possible to use the domain name or IP ADDRESS.
        """
        return pulumi.get(self, "host_private_address")

    @_builtins.property
    @pulumi.getter(name="hostPublicAddress")
    def host_public_address(self) -> _builtins.str:
        """
        Specify the new create a host of the IP address of a public network, it is possible to use the domain name or IP ADDRESS.
        """
        return pulumi.get(self, "host_public_address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Host.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Specify the new create a host where the Bastion host ID of.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> _builtins.str:
        """
        Specify the new create the host's operating system. Valid values: Linux Windows.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Sequence['outputs.GetHostsHostProtocolResult']:
        """
        The host of the protocol information.
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        Specify the new create a host of source. Valid values: Local: localhost Ecs:ECS instance Rds:RDS exclusive cluster host.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceInstanceId")
    def source_instance_id(self) -> _builtins.str:
        """
        Specify the newly created ECS instance ID or dedicated cluster host ID.
        """
        return pulumi.get(self, "source_instance_id")


@pulumi.output_type
class GetHostsHostProtocolResult(dict):
    def __init__(__self__, *,
                 host_finger_print: _builtins.str,
                 port: _builtins.int,
                 protocol_name: _builtins.str):
        """
        :param _builtins.str host_finger_print: Host fingerprint information, it is possible to uniquely identify a host.
        :param _builtins.int port: Host the service port of the RDS.
        :param _builtins.str protocol_name: The host uses the protocol name.
        """
        pulumi.set(__self__, "host_finger_print", host_finger_print)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol_name", protocol_name)

    @_builtins.property
    @pulumi.getter(name="hostFingerPrint")
    def host_finger_print(self) -> _builtins.str:
        """
        Host fingerprint information, it is possible to uniquely identify a host.
        """
        return pulumi.get(self, "host_finger_print")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Host the service port of the RDS.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="protocolName")
    def protocol_name(self) -> _builtins.str:
        """
        The host uses the protocol name.
        """
        return pulumi.get(self, "protocol_name")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 instance_status: _builtins.str,
                 license_code: _builtins.str,
                 private_domain: _builtins.str,
                 public_domain: _builtins.str,
                 public_network_access: _builtins.bool,
                 security_group_ids: Sequence[_builtins.str],
                 storage: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 user_vswitch_id: _builtins.str):
        """
        :param _builtins.str bandwidth: The bandwidth of Cloud Bastionhost instance.
        :param _builtins.str description: The instance's remark.
        :param _builtins.str id: The instance's id.
        :param _builtins.str instance_status: The instance's status.
        :param _builtins.str license_code: The instance's license code.
        :param _builtins.str private_domain: The instance's private domain name.
        :param _builtins.str public_domain: The instance's public domain name.
        :param _builtins.bool public_network_access: The instance's public network access configuration.
        :param Sequence[_builtins.str] security_group_ids: The instance's security group configuration.
        :param _builtins.str storage: The storage of Cloud Bastionhost instance in TB.
        :param Mapping[str, _builtins.str] tags: A map of tags assigned to the bastionhost instance.
        :param _builtins.str user_vswitch_id: The instance's vSwitch ID.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_status", instance_status)
        pulumi.set(__self__, "license_code", license_code)
        pulumi.set(__self__, "private_domain", private_domain)
        pulumi.set(__self__, "public_domain", public_domain)
        pulumi.set(__self__, "public_network_access", public_network_access)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "storage", storage)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "user_vswitch_id", user_vswitch_id)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.str:
        """
        The bandwidth of Cloud Bastionhost instance.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The instance's remark.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The instance's id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> _builtins.str:
        """
        The instance's status.
        """
        return pulumi.get(self, "instance_status")

    @_builtins.property
    @pulumi.getter(name="licenseCode")
    def license_code(self) -> _builtins.str:
        """
        The instance's license code.
        """
        return pulumi.get(self, "license_code")

    @_builtins.property
    @pulumi.getter(name="privateDomain")
    def private_domain(self) -> _builtins.str:
        """
        The instance's private domain name.
        """
        return pulumi.get(self, "private_domain")

    @_builtins.property
    @pulumi.getter(name="publicDomain")
    def public_domain(self) -> _builtins.str:
        """
        The instance's public domain name.
        """
        return pulumi.get(self, "public_domain")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> _builtins.bool:
        """
        The instance's public network access configuration.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        The instance's security group configuration.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> _builtins.str:
        """
        The storage of Cloud Bastionhost instance in TB.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the bastionhost instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userVswitchId")
    def user_vswitch_id(self) -> _builtins.str:
        """
        The instance's vSwitch ID.
        """
        return pulumi.get(self, "user_vswitch_id")


@pulumi.output_type
class GetUserGroupsGroupResult(dict):
    def __init__(__self__, *,
                 comment: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 user_group_id: _builtins.str,
                 user_group_name: _builtins.str):
        """
        :param _builtins.str comment: Specify the New Group of Remark Information. Supports up to 500 Characters.
        :param _builtins.str id: The ID of the User Group.
        :param _builtins.str instance_id: Specify the New Group of the Bastion Host of Instance Id.
        :param _builtins.str user_group_id: The User Group ID.
        :param _builtins.str user_group_name: Specify the New Group Name. Supports up to 128 Characters.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "user_group_id", user_group_id)
        pulumi.set(__self__, "user_group_name", user_group_name)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Specify the New Group of Remark Information. Supports up to 500 Characters.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the User Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Specify the New Group of the Bastion Host of Instance Id.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> _builtins.str:
        """
        The User Group ID.
        """
        return pulumi.get(self, "user_group_id")

    @_builtins.property
    @pulumi.getter(name="userGroupName")
    def user_group_name(self) -> _builtins.str:
        """
        Specify the New Group Name. Supports up to 128 Characters.
        """
        return pulumi.get(self, "user_group_name")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 comment: _builtins.str,
                 display_name: _builtins.str,
                 email: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 mobile: _builtins.str,
                 mobile_country_code: _builtins.str,
                 source: _builtins.str,
                 source_user_id: _builtins.str,
                 status: _builtins.str,
                 user_id: _builtins.str,
                 user_name: _builtins.str):
        """
        :param _builtins.str comment: Specify the New of the User That Created the Remark Information. Supports up to 500 Characters.
        :param _builtins.str display_name: Specify the New Created the User's Display Name. Supports up to 128 Characters.
        :param _builtins.str email: Specify the New User's Mailbox.
        :param _builtins.str id: The ID of the User.
        :param _builtins.str instance_id: You Want to Query the User the Bastion Host ID of.
        :param _builtins.str mobile: Specify the New of the User That Created a Different Mobile Phone Number from Your.
        :param _builtins.str mobile_country_code: Specify the New Create User Mobile Phone Number of the International Domain Name. The Default Value Is the CN Value: CN: Mainland China (+86) HK: hong Kong, China (+852) Mo: Macau, China (+853) TW: Taiwan, China (+886) ru: Russian (+7) SG: Singapore (+65) My: malaysia (+60) ID: Indonesia (+62) De: Germany (+49) AU: Australia (+61) US: United States (+1) AE: dubai (+971) JP: Japan (+81) Introducing the Long-Range GB: United Kingdom (+44) in: India (+91) KR: South Korea (+82) Ph: philippines (+63) Ch: Switzerland (+41) Se: Sweden (+46).
        :param _builtins.str source: Specify the New of the User That Created the Source. Valid Values: Local: Local User RAM: Ram User.
        :param _builtins.str source_user_id: Specify the Newly Created User Is Uniquely Identified. Indicates That the Parameter Is a Bastion Host Corresponding to the User with the Ram User's Unique Identifier. The Newly Created User Source Grant Permission to a RAM User (That Is, Source Used as a Ram), this Parameter Is Required. You Can Call Access Control of Listusers Interface from the Return Data Userid to Obtain the Parameters.
        :param _builtins.str status: The status of the resource.
        :param _builtins.str user_id: The User ID.
        :param _builtins.str user_name: Specify the New User Name. This Parameter Is Only by Letters, Lowercase Letters, Numbers, and Underscores (_), Supports up to 128 Characters.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "mobile", mobile)
        pulumi.set(__self__, "mobile_country_code", mobile_country_code)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_user_id", source_user_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Specify the New of the User That Created the Remark Information. Supports up to 500 Characters.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Specify the New Created the User's Display Name. Supports up to 128 Characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Specify the New User's Mailbox.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the User.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        You Want to Query the User the Bastion Host ID of.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def mobile(self) -> _builtins.str:
        """
        Specify the New of the User That Created a Different Mobile Phone Number from Your.
        """
        return pulumi.get(self, "mobile")

    @_builtins.property
    @pulumi.getter(name="mobileCountryCode")
    def mobile_country_code(self) -> _builtins.str:
        """
        Specify the New Create User Mobile Phone Number of the International Domain Name. The Default Value Is the CN Value: CN: Mainland China (+86) HK: hong Kong, China (+852) Mo: Macau, China (+853) TW: Taiwan, China (+886) ru: Russian (+7) SG: Singapore (+65) My: malaysia (+60) ID: Indonesia (+62) De: Germany (+49) AU: Australia (+61) US: United States (+1) AE: dubai (+971) JP: Japan (+81) Introducing the Long-Range GB: United Kingdom (+44) in: India (+91) KR: South Korea (+82) Ph: philippines (+63) Ch: Switzerland (+41) Se: Sweden (+46).
        """
        return pulumi.get(self, "mobile_country_code")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        Specify the New of the User That Created the Source. Valid Values: Local: Local User RAM: Ram User.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceUserId")
    def source_user_id(self) -> _builtins.str:
        """
        Specify the Newly Created User Is Uniquely Identified. Indicates That the Parameter Is a Bastion Host Corresponding to the User with the Ram User's Unique Identifier. The Newly Created User Source Grant Permission to a RAM User (That Is, Source Used as a Ram), this Parameter Is Required. You Can Call Access Control of Listusers Interface from the Return Data Userid to Obtain the Parameters.
        """
        return pulumi.get(self, "source_user_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        The User ID.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        Specify the New User Name. This Parameter Is Only by Letters, Lowercase Letters, Numbers, and Underscores (_), Supports up to 128 Characters.
        """
        return pulumi.get(self, "user_name")


