# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[_builtins.str],
                 major_version: pulumi.Input[_builtins.str],
                 node_count: pulumi.Input[_builtins.int],
                 pay_type: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_center_name: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_white: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.str] major_version: Cassandra major version. Now only support version `3.11`.
        :param pulumi.Input[_builtins.int] node_count: The node count of Cassandra dataCenter-1 default to 2.
        :param pulumi.Input[_builtins.str] pay_type: The pay type of Cassandra dataCenter-1. Valid values are `Subscription`, `PayAsYouGo`,System default to `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch_id of dataCenter-1, can not empty.
        :param pulumi.Input[_builtins.bool] auto_renew: Auto renew of dataCenter-1,`true` or `false`. System default to `false`, valid when pay_type = PrePaid.
        :param pulumi.Input[_builtins.int] auto_renew_period: Period of dataCenter-1 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
        :param pulumi.Input[_builtins.str] cluster_name: Cassandra cluster name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        :param pulumi.Input[_builtins.str] data_center_name: Cassandra dataCenter-1 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        :param pulumi.Input[_builtins.int] disk_size: User-defined Cassandra dataCenter-1 one node's storage space.Unit: GB. Value range:
               - Custom storage space; value range: [160, 2000].
               - 80-GB increments.
        :param pulumi.Input[_builtins.str] disk_type: The disk type of Cassandra dataCenter-1. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
        :param pulumi.Input[_builtins.str] ip_white: Set the instance's IP whitelist in VPC network.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: A list of security group ids to associate with.
               
               > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the Cassandra cluster. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "major_version", major_version)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "pay_type", pay_type)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if data_center_name is not None:
            pulumi.set(__self__, "data_center_name", data_center_name)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if enable_public is not None:
            pulumi.set(__self__, "enable_public", enable_public)
        if ip_white is not None:
            pulumi.set(__self__, "ip_white", ip_white)
        if maintain_end_time is not None:
            pulumi.set(__self__, "maintain_end_time", maintain_end_time)
        if maintain_start_time is not None:
            pulumi.set(__self__, "maintain_start_time", maintain_start_time)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> pulumi.Input[_builtins.str]:
        """
        Cassandra major version. Now only support version `3.11`.
        """
        return pulumi.get(self, "major_version")

    @major_version.setter
    def major_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "major_version", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[_builtins.int]:
        """
        The node count of Cassandra dataCenter-1 default to 2.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> pulumi.Input[_builtins.str]:
        """
        The pay type of Cassandra dataCenter-1. Valid values are `Subscription`, `PayAsYouGo`,System default to `PayAsYouGo`.
        """
        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pay_type", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The vswitch_id of dataCenter-1, can not empty.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Auto renew of dataCenter-1,`true` or `false`. System default to `false`, valid when pay_type = PrePaid.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Period of dataCenter-1 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cassandra cluster name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="dataCenterName")
    def data_center_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cassandra dataCenter-1 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        """
        return pulumi.get(self, "data_center_name")

    @data_center_name.setter
    def data_center_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_center_name", value)

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        User-defined Cassandra dataCenter-1 one node's storage space.Unit: GB. Value range:
        - Custom storage space; value range: [160, 2000].
        - 80-GB increments.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The disk type of Cassandra dataCenter-1. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter(name="enablePublic")
    def enable_public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_public")

    @enable_public.setter
    def enable_public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public", value)

    @_builtins.property
    @pulumi.getter(name="ipWhite")
    def ip_white(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the instance's IP whitelist in VPC network.
        """
        return pulumi.get(self, "ip_white")

    @ip_white.setter
    def ip_white(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_white", value)

    @_builtins.property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_end_time")

    @maintain_end_time.setter
    def maintain_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end_time", value)

    @_builtins.property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_start_time")

    @maintain_start_time.setter
    def maintain_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_start_time", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of security group ids to associate with.

        > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to launch the Cassandra cluster. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_center_name: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_white: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 public_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.bool] auto_renew: Auto renew of dataCenter-1,`true` or `false`. System default to `false`, valid when pay_type = PrePaid.
        :param pulumi.Input[_builtins.int] auto_renew_period: Period of dataCenter-1 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
        :param pulumi.Input[_builtins.str] cluster_name: Cassandra cluster name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        :param pulumi.Input[_builtins.str] data_center_name: Cassandra dataCenter-1 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        :param pulumi.Input[_builtins.int] disk_size: User-defined Cassandra dataCenter-1 one node's storage space.Unit: GB. Value range:
               - Custom storage space; value range: [160, 2000].
               - 80-GB increments.
        :param pulumi.Input[_builtins.str] disk_type: The disk type of Cassandra dataCenter-1. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
        :param pulumi.Input[_builtins.str] instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.str] ip_white: Set the instance's IP whitelist in VPC network.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] major_version: Cassandra major version. Now only support version `3.11`.
        :param pulumi.Input[_builtins.int] node_count: The node count of Cassandra dataCenter-1 default to 2.
        :param pulumi.Input[_builtins.str] pay_type: The pay type of Cassandra dataCenter-1. Valid values are `Subscription`, `PayAsYouGo`,System default to `PayAsYouGo`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: A list of security group ids to associate with.
               
               > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch_id of dataCenter-1, can not empty.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the Cassandra cluster. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if data_center_name is not None:
            pulumi.set(__self__, "data_center_name", data_center_name)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if enable_public is not None:
            pulumi.set(__self__, "enable_public", enable_public)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ip_white is not None:
            pulumi.set(__self__, "ip_white", ip_white)
        if maintain_end_time is not None:
            pulumi.set(__self__, "maintain_end_time", maintain_end_time)
        if maintain_start_time is not None:
            pulumi.set(__self__, "maintain_start_time", maintain_start_time)
        if major_version is not None:
            pulumi.set(__self__, "major_version", major_version)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pay_type is not None:
            pulumi.set(__self__, "pay_type", pay_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if public_points is not None:
            pulumi.set(__self__, "public_points", public_points)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Auto renew of dataCenter-1,`true` or `false`. System default to `false`, valid when pay_type = PrePaid.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Period of dataCenter-1 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cassandra cluster name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="dataCenterName")
    def data_center_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cassandra dataCenter-1 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        """
        return pulumi.get(self, "data_center_name")

    @data_center_name.setter
    def data_center_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_center_name", value)

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        User-defined Cassandra dataCenter-1 one node's storage space.Unit: GB. Value range:
        - Custom storage space; value range: [160, 2000].
        - 80-GB increments.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The disk type of Cassandra dataCenter-1. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter(name="enablePublic")
    def enable_public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_public")

    @enable_public.setter
    def enable_public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipWhite")
    def ip_white(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the instance's IP whitelist in VPC network.
        """
        return pulumi.get(self, "ip_white")

    @ip_white.setter
    def ip_white(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_white", value)

    @_builtins.property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_end_time")

    @maintain_end_time.setter
    def maintain_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end_time", value)

    @_builtins.property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_start_time")

    @maintain_start_time.setter
    def maintain_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_start_time", value)

    @_builtins.property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cassandra major version. Now only support version `3.11`.
        """
        return pulumi.get(self, "major_version")

    @major_version.setter
    def major_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "major_version", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The node count of Cassandra dataCenter-1 default to 2.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pay type of Cassandra dataCenter-1. Valid values are `Subscription`, `PayAsYouGo`,System default to `PayAsYouGo`.
        """
        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pay_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="publicPoints")
    def public_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "public_points")

    @public_points.setter
    def public_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "public_points", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of security group ids to associate with.

        > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vswitch_id of dataCenter-1, can not empty.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to launch the Cassandra cluster. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:cassandra/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_center_name: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_white: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cassandra cluster resource supports replica set clusters only. The Cassandra provides stable, reliable, and automatic scalable database services.
        It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
        You can see detail product introduction [here](https://www.alibabacloud.com/help/product/49055.htm).

        > **NOTE:** Available since v1.88.0.

        > **NOTE:**  The following regions support create Vpc network Cassandra cluster.
        The official website mark more regions. Or you can call [DescribeRegions](https://help.aliyun.com/document_detail/157540.html).

        > **NOTE:**  Create Cassandra cluster or change cluster type and storage would cost 30 minutes. Please make full preparation.

        > **DEPRECATED:**  This resource has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.

        ## Example Usage

        ### Create a cassandra cluster

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.cassandra.Cluster("default",
            cluster_name="cassandra-cluster-name-tf",
            data_center_name="dc-1",
            auto_renew=False,
            instance_type="cassandra.c.large",
            major_version="3.11",
            node_count=2,
            pay_type="PayAsYouGo",
            vswitch_id="vsw-xxxx",
            disk_size=160,
            disk_type="cloud_ssd",
            maintain_start_time="18:00Z",
            maintain_end_time="20:00Z",
            ip_white="127.0.0.1")
        ```

        This is a example for class netType cluster. You can find more detail with the examples/cassandra_cluster dir.

        ## Import

        Cassandra cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cassandra/cluster:Cluster example cds-wz9sr400dd7xxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Auto renew of dataCenter-1,`true` or `false`. System default to `false`, valid when pay_type = PrePaid.
        :param pulumi.Input[_builtins.int] auto_renew_period: Period of dataCenter-1 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
        :param pulumi.Input[_builtins.str] cluster_name: Cassandra cluster name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        :param pulumi.Input[_builtins.str] data_center_name: Cassandra dataCenter-1 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        :param pulumi.Input[_builtins.int] disk_size: User-defined Cassandra dataCenter-1 one node's storage space.Unit: GB. Value range:
               - Custom storage space; value range: [160, 2000].
               - 80-GB increments.
        :param pulumi.Input[_builtins.str] disk_type: The disk type of Cassandra dataCenter-1. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
        :param pulumi.Input[_builtins.str] instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.str] ip_white: Set the instance's IP whitelist in VPC network.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] major_version: Cassandra major version. Now only support version `3.11`.
        :param pulumi.Input[_builtins.int] node_count: The node count of Cassandra dataCenter-1 default to 2.
        :param pulumi.Input[_builtins.str] pay_type: The pay type of Cassandra dataCenter-1. Valid values are `Subscription`, `PayAsYouGo`,System default to `PayAsYouGo`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: A list of security group ids to associate with.
               
               > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch_id of dataCenter-1, can not empty.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the Cassandra cluster. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cassandra cluster resource supports replica set clusters only. The Cassandra provides stable, reliable, and automatic scalable database services.
        It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
        You can see detail product introduction [here](https://www.alibabacloud.com/help/product/49055.htm).

        > **NOTE:** Available since v1.88.0.

        > **NOTE:**  The following regions support create Vpc network Cassandra cluster.
        The official website mark more regions. Or you can call [DescribeRegions](https://help.aliyun.com/document_detail/157540.html).

        > **NOTE:**  Create Cassandra cluster or change cluster type and storage would cost 30 minutes. Please make full preparation.

        > **DEPRECATED:**  This resource has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.

        ## Example Usage

        ### Create a cassandra cluster

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.cassandra.Cluster("default",
            cluster_name="cassandra-cluster-name-tf",
            data_center_name="dc-1",
            auto_renew=False,
            instance_type="cassandra.c.large",
            major_version="3.11",
            node_count=2,
            pay_type="PayAsYouGo",
            vswitch_id="vsw-xxxx",
            disk_size=160,
            disk_type="cloud_ssd",
            maintain_start_time="18:00Z",
            maintain_end_time="20:00Z",
            ip_white="127.0.0.1")
        ```

        This is a example for class netType cluster. You can find more detail with the examples/cassandra_cluster dir.

        ## Import

        Cassandra cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cassandra/cluster:Cluster example cds-wz9sr400dd7xxxxx
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_center_name: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_white: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["data_center_name"] = data_center_name
            __props__.__dict__["disk_size"] = disk_size
            __props__.__dict__["disk_type"] = disk_type
            __props__.__dict__["enable_public"] = enable_public
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["ip_white"] = ip_white
            __props__.__dict__["maintain_end_time"] = maintain_end_time
            __props__.__dict__["maintain_start_time"] = maintain_start_time
            if major_version is None and not opts.urn:
                raise TypeError("Missing required property 'major_version'")
            __props__.__dict__["major_version"] = major_version
            if node_count is None and not opts.urn:
                raise TypeError("Missing required property 'node_count'")
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if pay_type is None and not opts.urn:
                raise TypeError("Missing required property 'pay_type'")
            __props__.__dict__["pay_type"] = pay_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["tags"] = tags
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["public_points"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'alicloud:cassandra/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            data_center_name: Optional[pulumi.Input[_builtins.str]] = None,
            disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            disk_type: Optional[pulumi.Input[_builtins.str]] = None,
            enable_public: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            ip_white: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            major_version: Optional[pulumi.Input[_builtins.str]] = None,
            node_count: Optional[pulumi.Input[_builtins.int]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            pay_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            public_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Auto renew of dataCenter-1,`true` or `false`. System default to `false`, valid when pay_type = PrePaid.
        :param pulumi.Input[_builtins.int] auto_renew_period: Period of dataCenter-1 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
        :param pulumi.Input[_builtins.str] cluster_name: Cassandra cluster name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        :param pulumi.Input[_builtins.str] data_center_name: Cassandra dataCenter-1 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        :param pulumi.Input[_builtins.int] disk_size: User-defined Cassandra dataCenter-1 one node's storage space.Unit: GB. Value range:
               - Custom storage space; value range: [160, 2000].
               - 80-GB increments.
        :param pulumi.Input[_builtins.str] disk_type: The disk type of Cassandra dataCenter-1. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
        :param pulumi.Input[_builtins.str] instance_type: Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
        :param pulumi.Input[_builtins.str] ip_white: Set the instance's IP whitelist in VPC network.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] major_version: Cassandra major version. Now only support version `3.11`.
        :param pulumi.Input[_builtins.int] node_count: The node count of Cassandra dataCenter-1 default to 2.
        :param pulumi.Input[_builtins.str] pay_type: The pay type of Cassandra dataCenter-1. Valid values are `Subscription`, `PayAsYouGo`,System default to `PayAsYouGo`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: A list of security group ids to associate with.
               
               > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch_id of dataCenter-1, can not empty.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the Cassandra cluster. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["data_center_name"] = data_center_name
        __props__.__dict__["disk_size"] = disk_size
        __props__.__dict__["disk_type"] = disk_type
        __props__.__dict__["enable_public"] = enable_public
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ip_white"] = ip_white
        __props__.__dict__["maintain_end_time"] = maintain_end_time
        __props__.__dict__["maintain_start_time"] = maintain_start_time
        __props__.__dict__["major_version"] = major_version
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["password"] = password
        __props__.__dict__["pay_type"] = pay_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["public_points"] = public_points
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Auto renew of dataCenter-1,`true` or `false`. System default to `false`, valid when pay_type = PrePaid.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Period of dataCenter-1 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
        """
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cassandra cluster name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="dataCenterName")
    def data_center_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cassandra dataCenter-1 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
        """
        return pulumi.get(self, "data_center_name")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        User-defined Cassandra dataCenter-1 one node's storage space.Unit: GB. Value range:
        - Custom storage space; value range: [160, 2000].
        - 80-GB increments.
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The disk type of Cassandra dataCenter-1. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="enablePublic")
    def enable_public(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "enable_public")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipWhite")
    def ip_white(self) -> pulumi.Output[_builtins.str]:
        """
        Set the instance's IP whitelist in VPC network.
        """
        return pulumi.get(self, "ip_white")

    @_builtins.property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The end time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_end_time")

    @_builtins.property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The start time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_start_time")

    @_builtins.property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> pulumi.Output[_builtins.str]:
        """
        Cassandra major version. Now only support version `3.11`.
        """
        return pulumi.get(self, "major_version")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[_builtins.int]:
        """
        The node count of Cassandra dataCenter-1 default to 2.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> pulumi.Output[_builtins.str]:
        """
        The pay type of Cassandra dataCenter-1. Valid values are `Subscription`, `PayAsYouGo`,System default to `PayAsYouGo`.
        """
        return pulumi.get(self, "pay_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="publicPoints")
    def public_points(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "public_points")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of security group ids to associate with.

        > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The vswitch_id of dataCenter-1, can not empty.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Zone to launch the Cassandra cluster. If vswitch_id is not empty, this zone_id can be "" or consistent.
        """
        return pulumi.get(self, "zone_id")

