# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    """
    A collection of values returned by getService.
    """
    def __init__(__self__, changing_affect_time=None, changing_charge_type=None, enable=None, id=None, internet_charge_type=None, opening_time=None, status=None):
        if changing_affect_time and not isinstance(changing_affect_time, str):
            raise TypeError("Expected argument 'changing_affect_time' to be a str")
        pulumi.set(__self__, "changing_affect_time", changing_affect_time)
        if changing_charge_type and not isinstance(changing_charge_type, str):
            raise TypeError("Expected argument 'changing_charge_type' to be a str")
        pulumi.set(__self__, "changing_charge_type", changing_charge_type)
        if enable and not isinstance(enable, str):
            raise TypeError("Expected argument 'enable' to be a str")
        pulumi.set(__self__, "enable", enable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internet_charge_type and not isinstance(internet_charge_type, str):
            raise TypeError("Expected argument 'internet_charge_type' to be a str")
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if opening_time and not isinstance(opening_time, str):
            raise TypeError("Expected argument 'opening_time' to be a str")
        pulumi.set(__self__, "opening_time", opening_time)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="changingAffectTime")
    def changing_affect_time(self) -> _builtins.str:
        """
        The time when the metering method for the next cycle takes effect. The time is displayed in GMT.
        """
        return pulumi.get(self, "changing_affect_time")

    @_builtins.property
    @pulumi.getter(name="changingChargeType")
    def changing_charge_type(self) -> _builtins.str:
        """
        The metering method for the next cycle.
        """
        return pulumi.get(self, "changing_charge_type")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="openingTime")
    def opening_time(self) -> _builtins.str:
        """
        The time when the CDN service was activated. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mmZ format.
        """
        return pulumi.get(self, "opening_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current service enable status.
        """
        return pulumi.get(self, "status")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            changing_affect_time=self.changing_affect_time,
            changing_charge_type=self.changing_charge_type,
            enable=self.enable,
            id=self.id,
            internet_charge_type=self.internet_charge_type,
            opening_time=self.opening_time,
            status=self.status)


def get_service(enable: Optional[_builtins.str] = None,
                internet_charge_type: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    Using this data source can enable CDN service automatically. If the service has been enabled, it will return `Opened`.

    For information about CDN and how to use it, see [What is CDN](https://www.alibabacloud.com/help/product/27099.htm).

    > **NOTE:** Available since v1.98.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    open = alicloud.cdn.get_service(enable="On",
        internet_charge_type="PayByTraffic")
    ```


    :param _builtins.str enable: Setting the value to `On` to enable the service. If has been enabled, return the result. Default value: `Off`. Valid values: `On`, `Off`.
    :param _builtins.str internet_charge_type: The new billing method. Valid values: `PayByTraffic` and `PayByBandwidth`. Default value: `PayByTraffic`.
           It is required when `enable = on`. If the CDN service has been opened and you can update its internet charge type by modifying the filed `internet_charge_type`.
           As a note, the updated internet charge type will be effective in the next day zero time.
           
           > **NOTE:** Setting `enable = "On"` to open the CDN service that means you have read and agreed the [CDN Terms of Service](https://help.aliyun.com/document_detail/27110.html). The service can not closed once it is opened.
    """
    __args__ = dict()
    __args__['enable'] = enable
    __args__['internetChargeType'] = internet_charge_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cdn/getService:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        changing_affect_time=pulumi.get(__ret__, 'changing_affect_time'),
        changing_charge_type=pulumi.get(__ret__, 'changing_charge_type'),
        enable=pulumi.get(__ret__, 'enable'),
        id=pulumi.get(__ret__, 'id'),
        internet_charge_type=pulumi.get(__ret__, 'internet_charge_type'),
        opening_time=pulumi.get(__ret__, 'opening_time'),
        status=pulumi.get(__ret__, 'status'))
def get_service_output(enable: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       internet_charge_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    Using this data source can enable CDN service automatically. If the service has been enabled, it will return `Opened`.

    For information about CDN and how to use it, see [What is CDN](https://www.alibabacloud.com/help/product/27099.htm).

    > **NOTE:** Available since v1.98.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    open = alicloud.cdn.get_service(enable="On",
        internet_charge_type="PayByTraffic")
    ```


    :param _builtins.str enable: Setting the value to `On` to enable the service. If has been enabled, return the result. Default value: `Off`. Valid values: `On`, `Off`.
    :param _builtins.str internet_charge_type: The new billing method. Valid values: `PayByTraffic` and `PayByBandwidth`. Default value: `PayByTraffic`.
           It is required when `enable = on`. If the CDN service has been opened and you can update its internet charge type by modifying the filed `internet_charge_type`.
           As a note, the updated internet charge type will be effective in the next day zero time.
           
           > **NOTE:** Setting `enable = "On"` to open the CDN service that means you have read and agreed the [CDN Terms of Service](https://help.aliyun.com/document_detail/27110.html). The service can not closed once it is opened.
    """
    __args__ = dict()
    __args__['enable'] = enable
    __args__['internetChargeType'] = internet_charge_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cdn/getService:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        changing_affect_time=pulumi.get(__response__, 'changing_affect_time'),
        changing_charge_type=pulumi.get(__response__, 'changing_charge_type'),
        enable=pulumi.get(__response__, 'enable'),
        id=pulumi.get(__response__, 'id'),
        internet_charge_type=pulumi.get(__response__, 'internet_charge_type'),
        opening_time=pulumi.get(__response__, 'opening_time'),
        status=pulumi.get(__response__, 'status')))
