# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBandwidthPackagesResult',
    'AwaitableGetBandwidthPackagesResult',
    'get_bandwidth_packages',
    'get_bandwidth_packages_output',
]

@pulumi.output_type
class GetBandwidthPackagesResult:
    """
    A collection of values returned by getBandwidthPackages.
    """
    def __init__(__self__, id=None, ids=None, include_reservation_data=None, instance_id=None, name_regex=None, names=None, output_file=None, packages=None, status=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if include_reservation_data and not isinstance(include_reservation_data, bool):
            raise TypeError("Expected argument 'include_reservation_data' to be a bool")
        pulumi.set(__self__, "include_reservation_data", include_reservation_data)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if packages and not isinstance(packages, list):
            raise TypeError("Expected argument 'packages' to be a list")
        pulumi.set(__self__, "packages", packages)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of specific CEN Bandwidth Package IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="includeReservationData")
    def include_reservation_data(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_reservation_data")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of the CEN instance that are associated with the bandwidth package.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        (Available in 1.98.0+) - A list of CEN Bandwidth Package Names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def packages(self) -> Sequence['outputs.GetBandwidthPackagesPackageResult']:
        """
        A list of CEN bandwidth package. Each element contains the following attributes:
        """
        return pulumi.get(self, "packages")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the CEN Bandwidth Package in CEN instance, including `Idle` and `InUse`.
        """
        return pulumi.get(self, "status")


class AwaitableGetBandwidthPackagesResult(GetBandwidthPackagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBandwidthPackagesResult(
            id=self.id,
            ids=self.ids,
            include_reservation_data=self.include_reservation_data,
            instance_id=self.instance_id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            packages=self.packages,
            status=self.status)


def get_bandwidth_packages(ids: Optional[Sequence[_builtins.str]] = None,
                           include_reservation_data: Optional[_builtins.bool] = None,
                           instance_id: Optional[_builtins.str] = None,
                           name_regex: Optional[_builtins.str] = None,
                           output_file: Optional[_builtins.str] = None,
                           status: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBandwidthPackagesResult:
    """
    This data source provides CEN Bandwidth Packages available to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.cen.get_bandwidth_packages(instance_id="cen-id1",
        name_regex="^foo")
    pulumi.export("firstCenBandwidthPackageId", example.packages[0].id)
    ```


    :param Sequence[_builtins.str] ids: Limit search to a list of specific CEN Bandwidth Package IDs.
    :param _builtins.bool include_reservation_data: Indicates whether to include renewal data. Valid values: `true`: Return renewal data in the response. `false`: Do not return renewal data in the response.
    :param _builtins.str instance_id: ID of a CEN instance.
    :param _builtins.str name_regex: A regex string to filter CEN Bandwidth Package by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: Status of the CEN Bandwidth Package in CEN instance, Valid value: `Idle` and `InUse`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['includeReservationData'] = include_reservation_data
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getBandwidthPackages:getBandwidthPackages', __args__, opts=opts, typ=GetBandwidthPackagesResult).value

    return AwaitableGetBandwidthPackagesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        include_reservation_data=pulumi.get(__ret__, 'include_reservation_data'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        packages=pulumi.get(__ret__, 'packages'),
        status=pulumi.get(__ret__, 'status'))
def get_bandwidth_packages_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                  include_reservation_data: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                  instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBandwidthPackagesResult]:
    """
    This data source provides CEN Bandwidth Packages available to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.cen.get_bandwidth_packages(instance_id="cen-id1",
        name_regex="^foo")
    pulumi.export("firstCenBandwidthPackageId", example.packages[0].id)
    ```


    :param Sequence[_builtins.str] ids: Limit search to a list of specific CEN Bandwidth Package IDs.
    :param _builtins.bool include_reservation_data: Indicates whether to include renewal data. Valid values: `true`: Return renewal data in the response. `false`: Do not return renewal data in the response.
    :param _builtins.str instance_id: ID of a CEN instance.
    :param _builtins.str name_regex: A regex string to filter CEN Bandwidth Package by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: Status of the CEN Bandwidth Package in CEN instance, Valid value: `Idle` and `InUse`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['includeReservationData'] = include_reservation_data
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cen/getBandwidthPackages:getBandwidthPackages', __args__, opts=opts, typ=GetBandwidthPackagesResult)
    return __ret__.apply(lambda __response__: GetBandwidthPackagesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        include_reservation_data=pulumi.get(__response__, 'include_reservation_data'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        packages=pulumi.get(__response__, 'packages'),
        status=pulumi.get(__response__, 'status')))
