# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlowlogsResult',
    'AwaitableGetFlowlogsResult',
    'get_flowlogs',
    'get_flowlogs_output',
]

@pulumi.output_type
class GetFlowlogsResult:
    """
    A collection of values returned by getFlowlogs.
    """
    def __init__(__self__, cen_id=None, description=None, flow_log_id=None, flow_log_name=None, flow_log_version=None, flowlogs=None, id=None, ids=None, interval=None, log_store_name=None, name_regex=None, names=None, output_file=None, page_number=None, page_size=None, project_name=None, region_id=None, status=None, transit_router_id=None):
        if cen_id and not isinstance(cen_id, str):
            raise TypeError("Expected argument 'cen_id' to be a str")
        pulumi.set(__self__, "cen_id", cen_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if flow_log_id and not isinstance(flow_log_id, str):
            raise TypeError("Expected argument 'flow_log_id' to be a str")
        pulumi.set(__self__, "flow_log_id", flow_log_id)
        if flow_log_name and not isinstance(flow_log_name, str):
            raise TypeError("Expected argument 'flow_log_name' to be a str")
        pulumi.set(__self__, "flow_log_name", flow_log_name)
        if flow_log_version and not isinstance(flow_log_version, str):
            raise TypeError("Expected argument 'flow_log_version' to be a str")
        pulumi.set(__self__, "flow_log_version", flow_log_version)
        if flowlogs and not isinstance(flowlogs, list):
            raise TypeError("Expected argument 'flowlogs' to be a list")
        pulumi.set(__self__, "flowlogs", flowlogs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if interval and not isinstance(interval, int):
            raise TypeError("Expected argument 'interval' to be a int")
        pulumi.set(__self__, "interval", interval)
        if log_store_name and not isinstance(log_store_name, str):
            raise TypeError("Expected argument 'log_store_name' to be a str")
        pulumi.set(__self__, "log_store_name", log_store_name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if region_id and not isinstance(region_id, str):
            raise TypeError("Expected argument 'region_id' to be a str")
        pulumi.set(__self__, "region_id", region_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if transit_router_id and not isinstance(transit_router_id, str):
            raise TypeError("Expected argument 'transit_router_id' to be a str")
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[_builtins.str]:
        """
        The ID of Cen instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of the flowlog.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="flowLogId")
    def flow_log_id(self) -> Optional[_builtins.str]:
        """
        The ID of FlowLog.
        """
        return pulumi.get(self, "flow_log_id")

    @_builtins.property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> Optional[_builtins.str]:
        """
        The name of the flowlog.
        """
        return pulumi.get(self, "flow_log_name")

    @_builtins.property
    @pulumi.getter(name="flowLogVersion")
    def flow_log_version(self) -> Optional[_builtins.str]:
        """
        (Available since v1.236.0) Flowlog Version.
        """
        return pulumi.get(self, "flow_log_version")

    @_builtins.property
    @pulumi.getter
    def flowlogs(self) -> Sequence['outputs.GetFlowlogsFlowlogResult']:
        """
        A list of Flow Log Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "flowlogs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Flow Log IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        (Available since v1.236.0) The duration of the capture window for the flow log to capture traffic. Unit: seconds. Valid values: **60** or **600 * *. Default value: **600 * *.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="logStoreName")
    def log_store_name(self) -> Optional[_builtins.str]:
        """
        The LogStore that stores the flowlog.
        """
        return pulumi.get(self, "log_store_name")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Flow Logs.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[_builtins.str]:
        """
        The Project that stores the flowlog.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[_builtins.str]:
        """
        (Available since v1.236.0) Region Id.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the flow log. Valid values:-**Active**: started.-**InActive**: not started.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[_builtins.str]:
        """
        (Available since v1.236.0) Transit Router ID.
        """
        return pulumi.get(self, "transit_router_id")


class AwaitableGetFlowlogsResult(GetFlowlogsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlowlogsResult(
            cen_id=self.cen_id,
            description=self.description,
            flow_log_id=self.flow_log_id,
            flow_log_name=self.flow_log_name,
            flow_log_version=self.flow_log_version,
            flowlogs=self.flowlogs,
            id=self.id,
            ids=self.ids,
            interval=self.interval,
            log_store_name=self.log_store_name,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            project_name=self.project_name,
            region_id=self.region_id,
            status=self.status,
            transit_router_id=self.transit_router_id)


def get_flowlogs(cen_id: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 flow_log_id: Optional[_builtins.str] = None,
                 flow_log_name: Optional[_builtins.str] = None,
                 flow_log_version: Optional[_builtins.str] = None,
                 ids: Optional[Sequence[_builtins.str]] = None,
                 interval: Optional[_builtins.int] = None,
                 log_store_name: Optional[_builtins.str] = None,
                 name_regex: Optional[_builtins.str] = None,
                 output_file: Optional[_builtins.str] = None,
                 page_number: Optional[_builtins.int] = None,
                 page_size: Optional[_builtins.int] = None,
                 project_name: Optional[_builtins.str] = None,
                 region_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 transit_router_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlowlogsResult:
    """
    This data source provides CEN flow logs available to the user.

    > **NOTE:** Available since v1.78.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf-example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    defaultc5kxy_c = alicloud.cen.Instance("defaultc5kxyC", cen_instance_name=name)
    default_vw2_u9u = alicloud.cen.TransitRouter("defaultVw2U9u", cen_id=defaultc5kxy_c.id)
    default_project = alicloud.log.Project("default",
        project_name=f"{name}-{default_integer['result']}",
        description="terraform-example")
    default_store = alicloud.log.Store("default",
        project_name=default_project.project_name,
        logstore_name=f"{name}-{default_integer['result']}",
        shard_count=3,
        auto_split=True,
        max_split_shard_count=60,
        append_meta=True)
    default_flow_log = alicloud.cen.FlowLog("default",
        project_name=default_store.project_name,
        flow_log_name=f"{name}-{default_integer['result']}",
        log_format_string="${srcaddr}${dstaddr}${bytes}",
        cen_id=defaultc5kxy_c.id,
        log_store_name=default_store.logstore_name,
        interval=600,
        status="Active",
        transit_router_id=default_vw2_u9u.transit_router_id,
        description="flowlog-resource-example-1")
    default = alicloud.cen.get_flowlogs_output(ids=[default_flow_log.id])
    pulumi.export("firstCenFlowlogId", default.flowlogs[0].id)
    ```


    :param _builtins.str cen_id: The ID of Cen instance.
    :param _builtins.str description: The description of the flowlog.
    :param _builtins.str flow_log_id: The ID of FlowLog.
    :param _builtins.str flow_log_name: The name of the flowlog.
    :param _builtins.str flow_log_version: Flowlog Version.
    :param Sequence[_builtins.str] ids: A list of Flow Log IDs.
    :param _builtins.int interval: The duration of the capture window for the flow log to capture traffic. Unit: seconds. Valid values: **60** or **600 * *. Default value: **600 * *.
    :param _builtins.str log_store_name: The LogStore that stores the flowlog.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Current page number.
    :param _builtins.int page_size: Number of records per page.
    :param _builtins.str project_name: The Project that stores the flowlog.
    :param _builtins.str region_id: Region id
    :param _builtins.str status: The status of the flow log. Valid values:-**Active**: started.-**InActive**: not started.
    :param _builtins.str transit_router_id: Transit Router ID
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['description'] = description
    __args__['flowLogId'] = flow_log_id
    __args__['flowLogName'] = flow_log_name
    __args__['flowLogVersion'] = flow_log_version
    __args__['ids'] = ids
    __args__['interval'] = interval
    __args__['logStoreName'] = log_store_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['projectName'] = project_name
    __args__['regionId'] = region_id
    __args__['status'] = status
    __args__['transitRouterId'] = transit_router_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getFlowlogs:getFlowlogs', __args__, opts=opts, typ=GetFlowlogsResult).value

    return AwaitableGetFlowlogsResult(
        cen_id=pulumi.get(__ret__, 'cen_id'),
        description=pulumi.get(__ret__, 'description'),
        flow_log_id=pulumi.get(__ret__, 'flow_log_id'),
        flow_log_name=pulumi.get(__ret__, 'flow_log_name'),
        flow_log_version=pulumi.get(__ret__, 'flow_log_version'),
        flowlogs=pulumi.get(__ret__, 'flowlogs'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        interval=pulumi.get(__ret__, 'interval'),
        log_store_name=pulumi.get(__ret__, 'log_store_name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        project_name=pulumi.get(__ret__, 'project_name'),
        region_id=pulumi.get(__ret__, 'region_id'),
        status=pulumi.get(__ret__, 'status'),
        transit_router_id=pulumi.get(__ret__, 'transit_router_id'))
def get_flowlogs_output(cen_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        flow_log_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        flow_log_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        flow_log_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        interval: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        log_store_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        project_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        region_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        transit_router_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlowlogsResult]:
    """
    This data source provides CEN flow logs available to the user.

    > **NOTE:** Available since v1.78.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf-example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    defaultc5kxy_c = alicloud.cen.Instance("defaultc5kxyC", cen_instance_name=name)
    default_vw2_u9u = alicloud.cen.TransitRouter("defaultVw2U9u", cen_id=defaultc5kxy_c.id)
    default_project = alicloud.log.Project("default",
        project_name=f"{name}-{default_integer['result']}",
        description="terraform-example")
    default_store = alicloud.log.Store("default",
        project_name=default_project.project_name,
        logstore_name=f"{name}-{default_integer['result']}",
        shard_count=3,
        auto_split=True,
        max_split_shard_count=60,
        append_meta=True)
    default_flow_log = alicloud.cen.FlowLog("default",
        project_name=default_store.project_name,
        flow_log_name=f"{name}-{default_integer['result']}",
        log_format_string="${srcaddr}${dstaddr}${bytes}",
        cen_id=defaultc5kxy_c.id,
        log_store_name=default_store.logstore_name,
        interval=600,
        status="Active",
        transit_router_id=default_vw2_u9u.transit_router_id,
        description="flowlog-resource-example-1")
    default = alicloud.cen.get_flowlogs_output(ids=[default_flow_log.id])
    pulumi.export("firstCenFlowlogId", default.flowlogs[0].id)
    ```


    :param _builtins.str cen_id: The ID of Cen instance.
    :param _builtins.str description: The description of the flowlog.
    :param _builtins.str flow_log_id: The ID of FlowLog.
    :param _builtins.str flow_log_name: The name of the flowlog.
    :param _builtins.str flow_log_version: Flowlog Version.
    :param Sequence[_builtins.str] ids: A list of Flow Log IDs.
    :param _builtins.int interval: The duration of the capture window for the flow log to capture traffic. Unit: seconds. Valid values: **60** or **600 * *. Default value: **600 * *.
    :param _builtins.str log_store_name: The LogStore that stores the flowlog.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Current page number.
    :param _builtins.int page_size: Number of records per page.
    :param _builtins.str project_name: The Project that stores the flowlog.
    :param _builtins.str region_id: Region id
    :param _builtins.str status: The status of the flow log. Valid values:-**Active**: started.-**InActive**: not started.
    :param _builtins.str transit_router_id: Transit Router ID
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['description'] = description
    __args__['flowLogId'] = flow_log_id
    __args__['flowLogName'] = flow_log_name
    __args__['flowLogVersion'] = flow_log_version
    __args__['ids'] = ids
    __args__['interval'] = interval
    __args__['logStoreName'] = log_store_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['projectName'] = project_name
    __args__['regionId'] = region_id
    __args__['status'] = status
    __args__['transitRouterId'] = transit_router_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cen/getFlowlogs:getFlowlogs', __args__, opts=opts, typ=GetFlowlogsResult)
    return __ret__.apply(lambda __response__: GetFlowlogsResult(
        cen_id=pulumi.get(__response__, 'cen_id'),
        description=pulumi.get(__response__, 'description'),
        flow_log_id=pulumi.get(__response__, 'flow_log_id'),
        flow_log_name=pulumi.get(__response__, 'flow_log_name'),
        flow_log_version=pulumi.get(__response__, 'flow_log_version'),
        flowlogs=pulumi.get(__response__, 'flowlogs'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        interval=pulumi.get(__response__, 'interval'),
        log_store_name=pulumi.get(__response__, 'log_store_name'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        project_name=pulumi.get(__response__, 'project_name'),
        region_id=pulumi.get(__response__, 'region_id'),
        status=pulumi.get(__response__, 'status'),
        transit_router_id=pulumi.get(__response__, 'transit_router_id')))
