# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceAttachmentArgs', 'InstanceAttachment']

@pulumi.input_type
class InstanceAttachmentArgs:
    def __init__(__self__, *,
                 child_instance_id: pulumi.Input[_builtins.str],
                 child_instance_region_id: pulumi.Input[_builtins.str],
                 child_instance_type: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 cen_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 child_instance_owner_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a InstanceAttachment resource.
        :param pulumi.Input[_builtins.str] child_instance_id: The ID of the child instance to attach.
        :param pulumi.Input[_builtins.str] child_instance_region_id: The region ID of the child instance to attach.
        :param pulumi.Input[_builtins.str] child_instance_type: The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the CEN.
        :param pulumi.Input[_builtins.int] cen_owner_id: The account ID to which the CEN instance belongs.
               
               ->**NOTE:** Ensure that the child instance is not used in Express Connect.
        :param pulumi.Input[_builtins.int] child_instance_owner_id: The uid of the child instance. Only used when attach a child instance of other account.
        """
        pulumi.set(__self__, "child_instance_id", child_instance_id)
        pulumi.set(__self__, "child_instance_region_id", child_instance_region_id)
        pulumi.set(__self__, "child_instance_type", child_instance_type)
        pulumi.set(__self__, "instance_id", instance_id)
        if cen_owner_id is not None:
            pulumi.set(__self__, "cen_owner_id", cen_owner_id)
        if child_instance_owner_id is not None:
            pulumi.set(__self__, "child_instance_owner_id", child_instance_owner_id)

    @_builtins.property
    @pulumi.getter(name="childInstanceId")
    def child_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the child instance to attach.
        """
        return pulumi.get(self, "child_instance_id")

    @child_instance_id.setter
    def child_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "child_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="childInstanceRegionId")
    def child_instance_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The region ID of the child instance to attach.
        """
        return pulumi.get(self, "child_instance_region_id")

    @child_instance_region_id.setter
    def child_instance_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "child_instance_region_id", value)

    @_builtins.property
    @pulumi.getter(name="childInstanceType")
    def child_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
        """
        return pulumi.get(self, "child_instance_type")

    @child_instance_type.setter
    def child_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "child_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the CEN.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="cenOwnerId")
    def cen_owner_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The account ID to which the CEN instance belongs.

        ->**NOTE:** Ensure that the child instance is not used in Express Connect.
        """
        return pulumi.get(self, "cen_owner_id")

    @cen_owner_id.setter
    def cen_owner_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cen_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="childInstanceOwnerId")
    def child_instance_owner_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The uid of the child instance. Only used when attach a child instance of other account.
        """
        return pulumi.get(self, "child_instance_owner_id")

    @child_instance_owner_id.setter
    def child_instance_owner_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "child_instance_owner_id", value)


@pulumi.input_type
class _InstanceAttachmentState:
    def __init__(__self__, *,
                 cen_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 child_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 child_instance_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 child_instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 child_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceAttachment resources.
        :param pulumi.Input[_builtins.int] cen_owner_id: The account ID to which the CEN instance belongs.
               
               ->**NOTE:** Ensure that the child instance is not used in Express Connect.
        :param pulumi.Input[_builtins.str] child_instance_id: The ID of the child instance to attach.
        :param pulumi.Input[_builtins.int] child_instance_owner_id: The uid of the child instance. Only used when attach a child instance of other account.
        :param pulumi.Input[_builtins.str] child_instance_region_id: The region ID of the child instance to attach.
        :param pulumi.Input[_builtins.str] child_instance_type: The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the CEN.
        :param pulumi.Input[_builtins.str] status: The associating status of the network.
        """
        if cen_owner_id is not None:
            pulumi.set(__self__, "cen_owner_id", cen_owner_id)
        if child_instance_id is not None:
            pulumi.set(__self__, "child_instance_id", child_instance_id)
        if child_instance_owner_id is not None:
            pulumi.set(__self__, "child_instance_owner_id", child_instance_owner_id)
        if child_instance_region_id is not None:
            pulumi.set(__self__, "child_instance_region_id", child_instance_region_id)
        if child_instance_type is not None:
            pulumi.set(__self__, "child_instance_type", child_instance_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="cenOwnerId")
    def cen_owner_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The account ID to which the CEN instance belongs.

        ->**NOTE:** Ensure that the child instance is not used in Express Connect.
        """
        return pulumi.get(self, "cen_owner_id")

    @cen_owner_id.setter
    def cen_owner_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cen_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="childInstanceId")
    def child_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the child instance to attach.
        """
        return pulumi.get(self, "child_instance_id")

    @child_instance_id.setter
    def child_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "child_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="childInstanceOwnerId")
    def child_instance_owner_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The uid of the child instance. Only used when attach a child instance of other account.
        """
        return pulumi.get(self, "child_instance_owner_id")

    @child_instance_owner_id.setter
    def child_instance_owner_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "child_instance_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="childInstanceRegionId")
    def child_instance_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the child instance to attach.
        """
        return pulumi.get(self, "child_instance_region_id")

    @child_instance_region_id.setter
    def child_instance_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "child_instance_region_id", value)

    @_builtins.property
    @pulumi.getter(name="childInstanceType")
    def child_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
        """
        return pulumi.get(self, "child_instance_type")

    @child_instance_type.setter
    def child_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "child_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CEN.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The associating status of the network.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cen/instanceAttachment:InstanceAttachment")
class InstanceAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 child_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 child_instance_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 child_instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 child_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a CEN child instance attachment resource that associate the network(VPC, CCN, VBR) with the CEN instance.

        > **NOTE:** Available since v1.42.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_regions(current=True)
        example = alicloud.vpc.Network("example",
            vpc_name="tf_example",
            cidr_block="172.17.3.0/24")
        example_instance = alicloud.cen.Instance("example",
            cen_instance_name="tf_example",
            description="an example for cen")
        example_instance_attachment = alicloud.cen.InstanceAttachment("example",
            instance_id=example_instance.id,
            child_instance_id=example.id,
            child_instance_type="VPC",
            child_instance_region_id=default.regions[0].id)
        ```

        ## Import

        CEN instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/instanceAttachment:InstanceAttachment example cen-m7i7pjmkon********:vpc-2ze2w07mcy9nz********:VPC:cn-beijing
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cen_owner_id: The account ID to which the CEN instance belongs.
               
               ->**NOTE:** Ensure that the child instance is not used in Express Connect.
        :param pulumi.Input[_builtins.str] child_instance_id: The ID of the child instance to attach.
        :param pulumi.Input[_builtins.int] child_instance_owner_id: The uid of the child instance. Only used when attach a child instance of other account.
        :param pulumi.Input[_builtins.str] child_instance_region_id: The region ID of the child instance to attach.
        :param pulumi.Input[_builtins.str] child_instance_type: The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the CEN.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CEN child instance attachment resource that associate the network(VPC, CCN, VBR) with the CEN instance.

        > **NOTE:** Available since v1.42.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_regions(current=True)
        example = alicloud.vpc.Network("example",
            vpc_name="tf_example",
            cidr_block="172.17.3.0/24")
        example_instance = alicloud.cen.Instance("example",
            cen_instance_name="tf_example",
            description="an example for cen")
        example_instance_attachment = alicloud.cen.InstanceAttachment("example",
            instance_id=example_instance.id,
            child_instance_id=example.id,
            child_instance_type="VPC",
            child_instance_region_id=default.regions[0].id)
        ```

        ## Import

        CEN instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/instanceAttachment:InstanceAttachment example cen-m7i7pjmkon********:vpc-2ze2w07mcy9nz********:VPC:cn-beijing
        ```

        :param str resource_name: The name of the resource.
        :param InstanceAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 child_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 child_instance_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 child_instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 child_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceAttachmentArgs.__new__(InstanceAttachmentArgs)

            __props__.__dict__["cen_owner_id"] = cen_owner_id
            if child_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'child_instance_id'")
            __props__.__dict__["child_instance_id"] = child_instance_id
            __props__.__dict__["child_instance_owner_id"] = child_instance_owner_id
            if child_instance_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'child_instance_region_id'")
            __props__.__dict__["child_instance_region_id"] = child_instance_region_id
            if child_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'child_instance_type'")
            __props__.__dict__["child_instance_type"] = child_instance_type
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["status"] = None
        super(InstanceAttachment, __self__).__init__(
            'alicloud:cen/instanceAttachment:InstanceAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cen_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
            child_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            child_instance_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
            child_instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            child_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceAttachment':
        """
        Get an existing InstanceAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cen_owner_id: The account ID to which the CEN instance belongs.
               
               ->**NOTE:** Ensure that the child instance is not used in Express Connect.
        :param pulumi.Input[_builtins.str] child_instance_id: The ID of the child instance to attach.
        :param pulumi.Input[_builtins.int] child_instance_owner_id: The uid of the child instance. Only used when attach a child instance of other account.
        :param pulumi.Input[_builtins.str] child_instance_region_id: The region ID of the child instance to attach.
        :param pulumi.Input[_builtins.str] child_instance_type: The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the CEN.
        :param pulumi.Input[_builtins.str] status: The associating status of the network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceAttachmentState.__new__(_InstanceAttachmentState)

        __props__.__dict__["cen_owner_id"] = cen_owner_id
        __props__.__dict__["child_instance_id"] = child_instance_id
        __props__.__dict__["child_instance_owner_id"] = child_instance_owner_id
        __props__.__dict__["child_instance_region_id"] = child_instance_region_id
        __props__.__dict__["child_instance_type"] = child_instance_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["status"] = status
        return InstanceAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cenOwnerId")
    def cen_owner_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The account ID to which the CEN instance belongs.

        ->**NOTE:** Ensure that the child instance is not used in Express Connect.
        """
        return pulumi.get(self, "cen_owner_id")

    @_builtins.property
    @pulumi.getter(name="childInstanceId")
    def child_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the child instance to attach.
        """
        return pulumi.get(self, "child_instance_id")

    @_builtins.property
    @pulumi.getter(name="childInstanceOwnerId")
    def child_instance_owner_id(self) -> pulumi.Output[_builtins.int]:
        """
        The uid of the child instance. Only used when attach a child instance of other account.
        """
        return pulumi.get(self, "child_instance_owner_id")

    @_builtins.property
    @pulumi.getter(name="childInstanceRegionId")
    def child_instance_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the child instance to attach.
        """
        return pulumi.get(self, "child_instance_region_id")

    @_builtins.property
    @pulumi.getter(name="childInstanceType")
    def child_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
        """
        return pulumi.get(self, "child_instance_type")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the CEN.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The associating status of the network.
        """
        return pulumi.get(self, "status")

