# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TransitRouterArgs', 'TransitRouter']

@pulumi.input_type
class TransitRouterArgs:
    def __init__(__self__, *,
                 cen_id: pulumi.Input[_builtins.str],
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 support_multicast: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TransitRouter resource.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.bool] dry_run: The dry run.
        :param pulumi.Input[_builtins.bool] support_multicast: Specifies whether to enable the multicast feature for the Enterprise Edition transit router. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_description: The description of the Enterprise Edition transit router instance.
               The description must be 1 to 256 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        :param pulumi.Input[_builtins.str] transit_router_name: The name of the Enterprise Edition transit router.
               The name must be 1 to 128 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if support_multicast is not None:
            pulumi.set(__self__, "support_multicast", support_multicast)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_description is not None:
            pulumi.set(__self__, "transit_router_description", transit_router_description)
        if transit_router_name is not None:
            pulumi.set(__self__, "transit_router_name", transit_router_name)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="supportMulticast")
    def support_multicast(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the multicast feature for the Enterprise Edition transit router. Valid values:
        """
        return pulumi.get(self, "support_multicast")

    @support_multicast.setter
    def support_multicast(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_multicast", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterDescription")
    def transit_router_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Enterprise Edition transit router instance.
        The description must be 1 to 256 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        """
        return pulumi.get(self, "transit_router_description")

    @transit_router_description.setter
    def transit_router_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterName")
    def transit_router_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Enterprise Edition transit router.
        The name must be 1 to 128 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        """
        return pulumi.get(self, "transit_router_name")

    @transit_router_name.setter
    def transit_router_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_name", value)


@pulumi.input_type
class _TransitRouterState:
    def __init__(__self__, *,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 support_multicast: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TransitRouter resources.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.247.0) The time when the transit router was created.
        :param pulumi.Input[_builtins.bool] dry_run: The dry run.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.247.0) The ID of the region where the transit router is deployed.
        :param pulumi.Input[_builtins.str] status: The status of the transit router.
        :param pulumi.Input[_builtins.bool] support_multicast: Specifies whether to enable the multicast feature for the Enterprise Edition transit router. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_description: The description of the Enterprise Edition transit router instance.
               The description must be 1 to 256 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router.
        :param pulumi.Input[_builtins.str] transit_router_name: The name of the Enterprise Edition transit router.
               The name must be 1 to 128 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        :param pulumi.Input[_builtins.str] type: The edition of the transit router.
        """
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_multicast is not None:
            pulumi.set(__self__, "support_multicast", support_multicast)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_description is not None:
            pulumi.set(__self__, "transit_router_description", transit_router_description)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_name is not None:
            pulumi.set(__self__, "transit_router_name", transit_router_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.247.0) The time when the transit router was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.247.0) The ID of the region where the transit router is deployed.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the transit router.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="supportMulticast")
    def support_multicast(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the multicast feature for the Enterprise Edition transit router. Valid values:
        """
        return pulumi.get(self, "support_multicast")

    @support_multicast.setter
    def support_multicast(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_multicast", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterDescription")
    def transit_router_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Enterprise Edition transit router instance.
        The description must be 1 to 256 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        """
        return pulumi.get(self, "transit_router_description")

    @transit_router_description.setter
    def transit_router_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterName")
    def transit_router_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Enterprise Edition transit router.
        The name must be 1 to 128 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        """
        return pulumi.get(self, "transit_router_name")

    @transit_router_name.setter
    def transit_router_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition of the transit router.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:cen/transitRouter:TransitRouter")
class TransitRouter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 support_multicast: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router resource.

        For information about Cloud Enterprise Network (CEN) Transit Router and how to use it, see [What is Transit Router](https://next.api.alibabacloud.com/document/Cbn/2017-09-12/CreateTransitRouter).

        > **NOTE:** Available since v1.126.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.cen.Instance("example",
            cen_instance_name=name,
            description=name)
        example_transit_router = alicloud.cen.TransitRouter("example",
            cen_id=example.id,
            transit_router_name=name)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouter:TransitRouter example <cen_id>:<transit_router_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.bool] dry_run: The dry run.
        :param pulumi.Input[_builtins.bool] support_multicast: Specifies whether to enable the multicast feature for the Enterprise Edition transit router. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_description: The description of the Enterprise Edition transit router instance.
               The description must be 1 to 256 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        :param pulumi.Input[_builtins.str] transit_router_name: The name of the Enterprise Edition transit router.
               The name must be 1 to 128 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitRouterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router resource.

        For information about Cloud Enterprise Network (CEN) Transit Router and how to use it, see [What is Transit Router](https://next.api.alibabacloud.com/document/Cbn/2017-09-12/CreateTransitRouter).

        > **NOTE:** Available since v1.126.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.cen.Instance("example",
            cen_instance_name=name,
            description=name)
        example_transit_router = alicloud.cen.TransitRouter("example",
            cen_id=example.id,
            transit_router_name=name)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouter:TransitRouter example <cen_id>:<transit_router_id>
        ```

        :param str resource_name: The name of the resource.
        :param TransitRouterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitRouterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 support_multicast: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitRouterArgs.__new__(TransitRouterArgs)

            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["support_multicast"] = support_multicast
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_router_description"] = transit_router_description
            __props__.__dict__["transit_router_name"] = transit_router_name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["transit_router_id"] = None
            __props__.__dict__["type"] = None
        super(TransitRouter, __self__).__init__(
            'alicloud:cen/transitRouter:TransitRouter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cen_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            support_multicast: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transit_router_description: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'TransitRouter':
        """
        Get an existing TransitRouter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.247.0) The time when the transit router was created.
        :param pulumi.Input[_builtins.bool] dry_run: The dry run.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.247.0) The ID of the region where the transit router is deployed.
        :param pulumi.Input[_builtins.str] status: The status of the transit router.
        :param pulumi.Input[_builtins.bool] support_multicast: Specifies whether to enable the multicast feature for the Enterprise Edition transit router. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_description: The description of the Enterprise Edition transit router instance.
               The description must be 1 to 256 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router.
        :param pulumi.Input[_builtins.str] transit_router_name: The name of the Enterprise Edition transit router.
               The name must be 1 to 128 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        :param pulumi.Input[_builtins.str] type: The edition of the transit router.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitRouterState.__new__(_TransitRouterState)

        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["status"] = status
        __props__.__dict__["support_multicast"] = support_multicast
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transit_router_description"] = transit_router_description
        __props__.__dict__["transit_router_id"] = transit_router_id
        __props__.__dict__["transit_router_name"] = transit_router_name
        __props__.__dict__["type"] = type
        return TransitRouter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.247.0) The time when the transit router was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The dry run.
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.247.0) The ID of the region where the transit router is deployed.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the transit router.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="supportMulticast")
    def support_multicast(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the multicast feature for the Enterprise Edition transit router. Valid values:
        """
        return pulumi.get(self, "support_multicast")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitRouterDescription")
    def transit_router_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Enterprise Edition transit router instance.
        The description must be 1 to 256 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        """
        return pulumi.get(self, "transit_router_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterName")
    def transit_router_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Enterprise Edition transit router.
        The name must be 1 to 128 characters in length, and cannot start with http:// or https://. You can also leave this parameter empty.
        """
        return pulumi.get(self, "transit_router_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The edition of the transit router.
        """
        return pulumi.get(self, "type")

