# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TransitRouterVpcAttachmentArgs', 'TransitRouterVpcAttachment']

@pulumi.input_type
class TransitRouterVpcAttachmentArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 zone_mappings: pulumi.Input[Sequence[pulumi.Input['TransitRouterVpcAttachmentZoneMappingArgs']]],
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_vpc_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_vpc_attachment_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_owner_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a TransitRouterVpcAttachment resource.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[Sequence[pulumi.Input['TransitRouterVpcAttachmentZoneMappingArgs']]] zone_mappings: ZoneMappingss See `zone_mappings` below.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to VPCs. Valid values:
               - **false:** (default)
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        :param pulumi.Input[_builtins.bool] force_delete: Whether to forcibly delete the VPC connection. The value is:
        :param pulumi.Input[_builtins.str] payment_type: The billing method. The default value is `PayAsYouGo`, which specifies the pay-as-you-go billing method.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the transit router vpc attachment. Default value: `VPC`. Valid values: `VPC`.
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The description of the VPC connection.
               
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: . Field 'transit_router_attachment_name' has been deprecated from provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the Enterprise Edition transit router.
        :param pulumi.Input[_builtins.str] transit_router_vpc_attachment_name: The name of the VPC connection.
               
               The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] transit_router_vpc_attachment_options: TransitRouterVpcAttachmentOptions
        :param pulumi.Input[_builtins.int] vpc_owner_id: VpcOwnerId
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_mappings", zone_mappings)
        if auto_publish_route_enabled is not None:
            pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if route_table_association_enabled is not None:
            warnings.warn("""Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""", DeprecationWarning)
            pulumi.log.warn("""route_table_association_enabled is deprecated: Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""")
        if route_table_association_enabled is not None:
            pulumi.set(__self__, "route_table_association_enabled", route_table_association_enabled)
        if route_table_propagation_enabled is not None:
            warnings.warn("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""", DeprecationWarning)
            pulumi.log.warn("""route_table_propagation_enabled is deprecated: Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""")
        if route_table_propagation_enabled is not None:
            pulumi.set(__self__, "route_table_propagation_enabled", route_table_propagation_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_attachment_description is not None:
            pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        if transit_router_attachment_name is not None:
            warnings.warn("""Field 'transit_router_attachment_name' has been deprecated since provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""transit_router_attachment_name is deprecated: Field 'transit_router_attachment_name' has been deprecated since provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.""")
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_vpc_attachment_name is not None:
            pulumi.set(__self__, "transit_router_vpc_attachment_name", transit_router_vpc_attachment_name)
        if transit_router_vpc_attachment_options is not None:
            pulumi.set(__self__, "transit_router_vpc_attachment_options", transit_router_vpc_attachment_options)
        if vpc_owner_id is not None:
            pulumi.set(__self__, "vpc_owner_id", vpc_owner_id)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['TransitRouterVpcAttachmentZoneMappingArgs']]]:
        """
        ZoneMappingss See `zone_mappings` below.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone_mappings")

    @zone_mappings.setter
    def zone_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['TransitRouterVpcAttachmentZoneMappingArgs']]]):
        pulumi.set(self, "zone_mappings", value)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to VPCs. Valid values:
        - **false:** (default)
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @auto_publish_route_enabled.setter
    def auto_publish_route_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_publish_route_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to forcibly delete the VPC connection. The value is:
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method. The default value is `PayAsYouGo`, which specifies the pay-as-you-go billing method.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type of the transit router vpc attachment. Default value: `VPC`. Valid values: `VPC`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="routeTableAssociationEnabled")
    @_utilities.deprecated("""Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""")
    def route_table_association_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        """
        return pulumi.get(self, "route_table_association_enabled")

    @route_table_association_enabled.setter
    def route_table_association_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_association_enabled", value)

    @_builtins.property
    @pulumi.getter(name="routeTablePropagationEnabled")
    @_utilities.deprecated("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""")
    def route_table_propagation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @route_table_propagation_enabled.setter
    def route_table_propagation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_propagation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the VPC connection.

        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @transit_router_attachment_description.setter
    def transit_router_attachment_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    @_utilities.deprecated("""Field 'transit_router_attachment_name' has been deprecated since provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.""")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'transit_router_attachment_name' has been deprecated from provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterVpcAttachmentName")
    def transit_router_vpc_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC connection.

        The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "transit_router_vpc_attachment_name")

    @transit_router_vpc_attachment_name.setter
    def transit_router_vpc_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_vpc_attachment_name", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterVpcAttachmentOptions")
    def transit_router_vpc_attachment_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        TransitRouterVpcAttachmentOptions
        """
        return pulumi.get(self, "transit_router_vpc_attachment_options")

    @transit_router_vpc_attachment_options.setter
    def transit_router_vpc_attachment_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "transit_router_vpc_attachment_options", value)

    @_builtins.property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        VpcOwnerId
        """
        return pulumi.get(self, "vpc_owner_id")

    @vpc_owner_id.setter
    def vpc_owner_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpc_owner_id", value)


@pulumi.input_type
class _TransitRouterVpcAttachmentState:
    def __init__(__self__, *,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_vpc_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_vpc_attachment_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['TransitRouterVpcAttachmentZoneMappingArgs']]]] = None):
        """
        Input properties used for looking up and filtering TransitRouterVpcAttachment resources.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to VPCs. Valid values:
               - **false:** (default)
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        :param pulumi.Input[_builtins.bool] force_delete: Whether to forcibly delete the VPC connection. The value is:
        :param pulumi.Input[_builtins.str] payment_type: The billing method. The default value is `PayAsYouGo`, which specifies the pay-as-you-go billing method.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the transit router vpc attachment. Default value: `VPC`. Valid values: `VPC`.
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
        :param pulumi.Input[_builtins.str] status: Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The description of the VPC connection.
               
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: The ID of the Transit Router Attachment.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: . Field 'transit_router_attachment_name' has been deprecated from provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the Enterprise Edition transit router.
        :param pulumi.Input[_builtins.str] transit_router_vpc_attachment_name: The name of the VPC connection.
               
               The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] transit_router_vpc_attachment_options: TransitRouterVpcAttachmentOptions
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.int] vpc_owner_id: VpcOwnerId
        :param pulumi.Input[Sequence[pulumi.Input['TransitRouterVpcAttachmentZoneMappingArgs']]] zone_mappings: ZoneMappingss See `zone_mappings` below.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if auto_publish_route_enabled is not None:
            pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if route_table_association_enabled is not None:
            warnings.warn("""Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""", DeprecationWarning)
            pulumi.log.warn("""route_table_association_enabled is deprecated: Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""")
        if route_table_association_enabled is not None:
            pulumi.set(__self__, "route_table_association_enabled", route_table_association_enabled)
        if route_table_propagation_enabled is not None:
            warnings.warn("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""", DeprecationWarning)
            pulumi.log.warn("""route_table_propagation_enabled is deprecated: Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""")
        if route_table_propagation_enabled is not None:
            pulumi.set(__self__, "route_table_propagation_enabled", route_table_propagation_enabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_attachment_description is not None:
            pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        if transit_router_attachment_id is not None:
            pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        if transit_router_attachment_name is not None:
            warnings.warn("""Field 'transit_router_attachment_name' has been deprecated since provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""transit_router_attachment_name is deprecated: Field 'transit_router_attachment_name' has been deprecated since provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.""")
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_vpc_attachment_name is not None:
            pulumi.set(__self__, "transit_router_vpc_attachment_name", transit_router_vpc_attachment_name)
        if transit_router_vpc_attachment_options is not None:
            pulumi.set(__self__, "transit_router_vpc_attachment_options", transit_router_vpc_attachment_options)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_owner_id is not None:
            pulumi.set(__self__, "vpc_owner_id", vpc_owner_id)
        if zone_mappings is not None:
            pulumi.set(__self__, "zone_mappings", zone_mappings)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to VPCs. Valid values:
        - **false:** (default)
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @auto_publish_route_enabled.setter
    def auto_publish_route_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_publish_route_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to forcibly delete the VPC connection. The value is:
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method. The default value is `PayAsYouGo`, which specifies the pay-as-you-go billing method.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type of the transit router vpc attachment. Default value: `VPC`. Valid values: `VPC`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="routeTableAssociationEnabled")
    @_utilities.deprecated("""Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""")
    def route_table_association_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        """
        return pulumi.get(self, "route_table_association_enabled")

    @route_table_association_enabled.setter
    def route_table_association_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_association_enabled", value)

    @_builtins.property
    @pulumi.getter(name="routeTablePropagationEnabled")
    @_utilities.deprecated("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""")
    def route_table_propagation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @route_table_propagation_enabled.setter
    def route_table_propagation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_propagation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the VPC connection.

        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @transit_router_attachment_description.setter
    def transit_router_attachment_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Transit Router Attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @transit_router_attachment_id.setter
    def transit_router_attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    @_utilities.deprecated("""Field 'transit_router_attachment_name' has been deprecated since provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.""")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'transit_router_attachment_name' has been deprecated from provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterVpcAttachmentName")
    def transit_router_vpc_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC connection.

        The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "transit_router_vpc_attachment_name")

    @transit_router_vpc_attachment_name.setter
    def transit_router_vpc_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_vpc_attachment_name", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterVpcAttachmentOptions")
    def transit_router_vpc_attachment_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        TransitRouterVpcAttachmentOptions
        """
        return pulumi.get(self, "transit_router_vpc_attachment_options")

    @transit_router_vpc_attachment_options.setter
    def transit_router_vpc_attachment_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "transit_router_vpc_attachment_options", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        VpcOwnerId
        """
        return pulumi.get(self, "vpc_owner_id")

    @vpc_owner_id.setter
    def vpc_owner_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpc_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransitRouterVpcAttachmentZoneMappingArgs']]]]:
        """
        ZoneMappingss See `zone_mappings` below.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone_mappings")

    @zone_mappings.setter
    def zone_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransitRouterVpcAttachmentZoneMappingArgs']]]]):
        pulumi.set(self, "zone_mappings", value)


@pulumi.type_token("alicloud:cen/transitRouterVpcAttachment:TransitRouterVpcAttachment")
class TransitRouterVpcAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_vpc_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_vpc_attachment_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransitRouterVpcAttachmentZoneMappingArgs', 'TransitRouterVpcAttachmentZoneMappingArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a CEN Transit Router VPC Attachment resource that associate the VPC with the CEN instance. [What is Cen Transit Router VPC Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutervpcattachment)

        > **NOTE:** Available since v1.126.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cen.get_transit_router_available_resources()
        master_zone = default.resources[0].master_zones[0]
        slave_zone = default.resources[0].slave_zones[1]
        example = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        example_master = alicloud.vpc.Switch("example_master",
            vswitch_name=name,
            cidr_block="192.168.1.0/24",
            vpc_id=example.id,
            zone_id=master_zone)
        example_slave = alicloud.vpc.Switch("example_slave",
            vswitch_name=name,
            cidr_block="192.168.2.0/24",
            vpc_id=example.id,
            zone_id=slave_zone)
        example_instance = alicloud.cen.Instance("example",
            cen_instance_name=name,
            protection_level="REDUCED")
        example_transit_router = alicloud.cen.TransitRouter("example",
            transit_router_name=name,
            cen_id=example_instance.id)
        example_transit_router_vpc_attachment = alicloud.cen.TransitRouterVpcAttachment("example",
            cen_id=example_instance.id,
            transit_router_id=example_transit_router.transit_router_id,
            vpc_id=example.id,
            zone_mappings=[
                {
                    "zone_id": master_zone,
                    "vswitch_id": example_master.id,
                },
                {
                    "zone_id": slave_zone,
                    "vswitch_id": example_slave.id,
                },
            ],
            transit_router_attachment_name=name,
            transit_router_attachment_description=name)
        ```

        ## Import

        CEN Transit Router Vpc Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterVpcAttachment:TransitRouterVpcAttachment example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to VPCs. Valid values:
               - **false:** (default)
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        :param pulumi.Input[_builtins.bool] force_delete: Whether to forcibly delete the VPC connection. The value is:
        :param pulumi.Input[_builtins.str] payment_type: The billing method. The default value is `PayAsYouGo`, which specifies the pay-as-you-go billing method.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the transit router vpc attachment. Default value: `VPC`. Valid values: `VPC`.
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The description of the VPC connection.
               
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: . Field 'transit_router_attachment_name' has been deprecated from provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the Enterprise Edition transit router.
        :param pulumi.Input[_builtins.str] transit_router_vpc_attachment_name: The name of the VPC connection.
               
               The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] transit_router_vpc_attachment_options: TransitRouterVpcAttachmentOptions
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.int] vpc_owner_id: VpcOwnerId
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransitRouterVpcAttachmentZoneMappingArgs', 'TransitRouterVpcAttachmentZoneMappingArgsDict']]]] zone_mappings: ZoneMappingss See `zone_mappings` below.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitRouterVpcAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CEN Transit Router VPC Attachment resource that associate the VPC with the CEN instance. [What is Cen Transit Router VPC Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutervpcattachment)

        > **NOTE:** Available since v1.126.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cen.get_transit_router_available_resources()
        master_zone = default.resources[0].master_zones[0]
        slave_zone = default.resources[0].slave_zones[1]
        example = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="192.168.0.0/16")
        example_master = alicloud.vpc.Switch("example_master",
            vswitch_name=name,
            cidr_block="192.168.1.0/24",
            vpc_id=example.id,
            zone_id=master_zone)
        example_slave = alicloud.vpc.Switch("example_slave",
            vswitch_name=name,
            cidr_block="192.168.2.0/24",
            vpc_id=example.id,
            zone_id=slave_zone)
        example_instance = alicloud.cen.Instance("example",
            cen_instance_name=name,
            protection_level="REDUCED")
        example_transit_router = alicloud.cen.TransitRouter("example",
            transit_router_name=name,
            cen_id=example_instance.id)
        example_transit_router_vpc_attachment = alicloud.cen.TransitRouterVpcAttachment("example",
            cen_id=example_instance.id,
            transit_router_id=example_transit_router.transit_router_id,
            vpc_id=example.id,
            zone_mappings=[
                {
                    "zone_id": master_zone,
                    "vswitch_id": example_master.id,
                },
                {
                    "zone_id": slave_zone,
                    "vswitch_id": example_slave.id,
                },
            ],
            transit_router_attachment_name=name,
            transit_router_attachment_description=name)
        ```

        ## Import

        CEN Transit Router Vpc Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterVpcAttachment:TransitRouterVpcAttachment example <id>
        ```

        :param str resource_name: The name of the resource.
        :param TransitRouterVpcAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitRouterVpcAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_vpc_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_vpc_attachment_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransitRouterVpcAttachmentZoneMappingArgs', 'TransitRouterVpcAttachmentZoneMappingArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitRouterVpcAttachmentArgs.__new__(TransitRouterVpcAttachmentArgs)

            __props__.__dict__["auto_publish_route_enabled"] = auto_publish_route_enabled
            __props__.__dict__["cen_id"] = cen_id
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["route_table_association_enabled"] = route_table_association_enabled
            __props__.__dict__["route_table_propagation_enabled"] = route_table_propagation_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_router_attachment_description"] = transit_router_attachment_description
            __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
            __props__.__dict__["transit_router_id"] = transit_router_id
            __props__.__dict__["transit_router_vpc_attachment_name"] = transit_router_vpc_attachment_name
            __props__.__dict__["transit_router_vpc_attachment_options"] = transit_router_vpc_attachment_options
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vpc_owner_id"] = vpc_owner_id
            if zone_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'zone_mappings'")
            __props__.__dict__["zone_mappings"] = zone_mappings
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["transit_router_attachment_id"] = None
        super(TransitRouterVpcAttachment, __self__).__init__(
            'alicloud:cen/transitRouterVpcAttachment:TransitRouterVpcAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cen_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_vpc_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_vpc_attachment_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_owner_id: Optional[pulumi.Input[_builtins.int]] = None,
            zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransitRouterVpcAttachmentZoneMappingArgs', 'TransitRouterVpcAttachmentZoneMappingArgsDict']]]]] = None) -> 'TransitRouterVpcAttachment':
        """
        Get an existing TransitRouterVpcAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to VPCs. Valid values:
               - **false:** (default)
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        :param pulumi.Input[_builtins.bool] force_delete: Whether to forcibly delete the VPC connection. The value is:
        :param pulumi.Input[_builtins.str] payment_type: The billing method. The default value is `PayAsYouGo`, which specifies the pay-as-you-go billing method.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the transit router vpc attachment. Default value: `VPC`. Valid values: `VPC`.
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
        :param pulumi.Input[_builtins.str] status: Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The description of the VPC connection.
               
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: The ID of the Transit Router Attachment.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: . Field 'transit_router_attachment_name' has been deprecated from provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the Enterprise Edition transit router.
        :param pulumi.Input[_builtins.str] transit_router_vpc_attachment_name: The name of the VPC connection.
               
               The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] transit_router_vpc_attachment_options: TransitRouterVpcAttachmentOptions
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.int] vpc_owner_id: VpcOwnerId
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransitRouterVpcAttachmentZoneMappingArgs', 'TransitRouterVpcAttachmentZoneMappingArgsDict']]]] zone_mappings: ZoneMappingss See `zone_mappings` below.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitRouterVpcAttachmentState.__new__(_TransitRouterVpcAttachmentState)

        __props__.__dict__["auto_publish_route_enabled"] = auto_publish_route_enabled
        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["route_table_association_enabled"] = route_table_association_enabled
        __props__.__dict__["route_table_propagation_enabled"] = route_table_propagation_enabled
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transit_router_attachment_description"] = transit_router_attachment_description
        __props__.__dict__["transit_router_attachment_id"] = transit_router_attachment_id
        __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
        __props__.__dict__["transit_router_id"] = transit_router_id
        __props__.__dict__["transit_router_vpc_attachment_name"] = transit_router_vpc_attachment_name
        __props__.__dict__["transit_router_vpc_attachment_options"] = transit_router_vpc_attachment_options
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_owner_id"] = vpc_owner_id
        __props__.__dict__["zone_mappings"] = zone_mappings
        return TransitRouterVpcAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to VPCs. Valid values:
        - **false:** (default)
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to forcibly delete the VPC connection. The value is:
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method. The default value is `PayAsYouGo`, which specifies the pay-as-you-go billing method.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        The resource type of the transit router vpc attachment. Default value: `VPC`. Valid values: `VPC`.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="routeTableAssociationEnabled")
    @_utilities.deprecated("""Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""")
    def route_table_association_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        """
        return pulumi.get(self, "route_table_association_enabled")

    @_builtins.property
    @pulumi.getter(name="routeTablePropagationEnabled")
    @_utilities.deprecated("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""")
    def route_table_propagation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the VPC connection.

        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Transit Router Attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    @_utilities.deprecated("""Field 'transit_router_attachment_name' has been deprecated since provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.""")
    def transit_router_attachment_name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'transit_router_attachment_name' has been deprecated from provider version 1.230.1. New field 'transit_router_vpc_attachment_name' instead.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterVpcAttachmentName")
    def transit_router_vpc_attachment_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the VPC connection.

        The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "transit_router_vpc_attachment_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterVpcAttachmentOptions")
    def transit_router_vpc_attachment_options(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        TransitRouterVpcAttachmentOptions
        """
        return pulumi.get(self, "transit_router_vpc_attachment_options")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> pulumi.Output[_builtins.int]:
        """
        VpcOwnerId
        """
        return pulumi.get(self, "vpc_owner_id")

    @_builtins.property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> pulumi.Output[Sequence['outputs.TransitRouterVpcAttachmentZoneMapping']]:
        """
        ZoneMappingss See `zone_mappings` below.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone_mappings")

