# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AggregateConfigRuleArgs', 'AggregateConfigRule']

@pulumi.input_type
class AggregateConfigRuleArgs:
    def __init__(__self__, *,
                 aggregate_config_rule_name: pulumi.Input[_builtins.str],
                 aggregator_id: pulumi.Input[_builtins.str],
                 config_rule_trigger_types: pulumi.Input[_builtins.str],
                 resource_types_scopes: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 risk_level: pulumi.Input[_builtins.int],
                 source_identifier: pulumi.Input[_builtins.str],
                 source_owner: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 input_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_key_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value_scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AggregateConfigRule resource.
        :param pulumi.Input[_builtins.str] aggregate_config_rule_name: The name of the rule.
        :param pulumi.Input[_builtins.str] aggregator_id: The Aggregator Id.
        :param pulumi.Input[_builtins.str] config_rule_trigger_types: The trigger type of the rule. Valid values: `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types_scopes: Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config.](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
        :param pulumi.Input[_builtins.int] risk_level: The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info.
        :param pulumi.Input[_builtins.str] source_identifier: The identifier of the rule. For a managed rule, the value is the identifier of the managed rule. For a custom rule, the value is the ARN of the custom rule. Using managed rules, refer to [List of Managed rules.](https://www.alibabacloud.com/help/en/doc-detail/127404.htm)
        :param pulumi.Input[_builtins.str] source_owner: Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values: `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.str] exclude_resource_ids_scope: The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] input_parameters: The settings map of the input parameters for the rule.
        :param pulumi.Input[_builtins.str] maximum_execution_frequency: The frequency of the compliance evaluations. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`. System default value is `TwentyFour_Hours` and valid when the `config_rule_trigger_types` is `ScheduledNotification`.
        :param pulumi.Input[_builtins.str] region_ids_scope: The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[_builtins.str] resource_group_ids_scope: The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[_builtins.str] status: The rule status. The valid values: `ACTIVE`, `INACTIVE`.
        :param pulumi.Input[_builtins.str] tag_key_scope: The rule monitors the tag key, only applies to rules created based on managed rules.
        :param pulumi.Input[_builtins.str] tag_value_scope: The rule monitors the tag value, use with the `tag_key_scope` options. only applies to rules created based on managed rules.
        """
        pulumi.set(__self__, "aggregate_config_rule_name", aggregate_config_rule_name)
        pulumi.set(__self__, "aggregator_id", aggregator_id)
        pulumi.set(__self__, "config_rule_trigger_types", config_rule_trigger_types)
        pulumi.set(__self__, "resource_types_scopes", resource_types_scopes)
        pulumi.set(__self__, "risk_level", risk_level)
        pulumi.set(__self__, "source_identifier", source_identifier)
        pulumi.set(__self__, "source_owner", source_owner)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_resource_ids_scope is not None:
            pulumi.set(__self__, "exclude_resource_ids_scope", exclude_resource_ids_scope)
        if input_parameters is not None:
            pulumi.set(__self__, "input_parameters", input_parameters)
        if maximum_execution_frequency is not None:
            pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        if region_ids_scope is not None:
            pulumi.set(__self__, "region_ids_scope", region_ids_scope)
        if resource_group_ids_scope is not None:
            pulumi.set(__self__, "resource_group_ids_scope", resource_group_ids_scope)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag_key_scope is not None:
            pulumi.set(__self__, "tag_key_scope", tag_key_scope)
        if tag_value_scope is not None:
            pulumi.set(__self__, "tag_value_scope", tag_value_scope)

    @_builtins.property
    @pulumi.getter(name="aggregateConfigRuleName")
    def aggregate_config_rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "aggregate_config_rule_name")

    @aggregate_config_rule_name.setter
    def aggregate_config_rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "aggregate_config_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="aggregatorId")
    def aggregator_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Aggregator Id.
        """
        return pulumi.get(self, "aggregator_id")

    @aggregator_id.setter
    def aggregator_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "aggregator_id", value)

    @_builtins.property
    @pulumi.getter(name="configRuleTriggerTypes")
    def config_rule_trigger_types(self) -> pulumi.Input[_builtins.str]:
        """
        The trigger type of the rule. Valid values: `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        """
        return pulumi.get(self, "config_rule_trigger_types")

    @config_rule_trigger_types.setter
    def config_rule_trigger_types(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_rule_trigger_types", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypesScopes")
    def resource_types_scopes(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config.](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
        """
        return pulumi.get(self, "resource_types_scopes")

    @resource_types_scopes.setter
    def resource_types_scopes(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "resource_types_scopes", value)

    @_builtins.property
    @pulumi.getter(name="riskLevel")
    def risk_level(self) -> pulumi.Input[_builtins.int]:
        """
        The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info.
        """
        return pulumi.get(self, "risk_level")

    @risk_level.setter
    def risk_level(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "risk_level", value)

    @_builtins.property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the rule. For a managed rule, the value is the identifier of the managed rule. For a custom rule, the value is the ARN of the custom rule. Using managed rules, refer to [List of Managed rules.](https://www.alibabacloud.com/help/en/doc-detail/127404.htm)
        """
        return pulumi.get(self, "source_identifier")

    @source_identifier.setter
    def source_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_identifier", value)

    @_builtins.property
    @pulumi.getter(name="sourceOwner")
    def source_owner(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values: `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule.
        """
        return pulumi.get(self, "source_owner")

    @source_owner.setter
    def source_owner(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_owner", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="excludeResourceIdsScope")
    def exclude_resource_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        """
        return pulumi.get(self, "exclude_resource_ids_scope")

    @exclude_resource_ids_scope.setter
    def exclude_resource_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_resource_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The settings map of the input parameters for the rule.
        """
        return pulumi.get(self, "input_parameters")

    @input_parameters.setter
    def input_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "input_parameters", value)

    @_builtins.property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The frequency of the compliance evaluations. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`. System default value is `TwentyFour_Hours` and valid when the `config_rule_trigger_types` is `ScheduledNotification`.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @maximum_execution_frequency.setter
    def maximum_execution_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maximum_execution_frequency", value)

    @_builtins.property
    @pulumi.getter(name="regionIdsScope")
    def region_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "region_ids_scope")

    @region_ids_scope.setter
    def region_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupIdsScope")
    def resource_group_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "resource_group_ids_scope")

    @resource_group_ids_scope.setter
    def resource_group_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_ids_scope", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule status. The valid values: `ACTIVE`, `INACTIVE`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tagKeyScope")
    def tag_key_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule monitors the tag key, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "tag_key_scope")

    @tag_key_scope.setter
    def tag_key_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_key_scope", value)

    @_builtins.property
    @pulumi.getter(name="tagValueScope")
    def tag_value_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule monitors the tag value, use with the `tag_key_scope` options. only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "tag_value_scope")

    @tag_value_scope.setter
    def tag_value_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_value_scope", value)


@pulumi.input_type
class _AggregateConfigRuleState:
    def __init__(__self__, *,
                 aggregate_config_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_rule_trigger_types: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 input_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 risk_level: Optional[pulumi.Input[_builtins.int]] = None,
                 source_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 source_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_key_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value_scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AggregateConfigRule resources.
        :param pulumi.Input[_builtins.str] aggregate_config_rule_name: The name of the rule.
        :param pulumi.Input[_builtins.str] aggregator_id: The Aggregator Id.
        :param pulumi.Input[_builtins.str] config_rule_id: (Available since v1.141.0) The rule ID of Aggregate Config Rule.
        :param pulumi.Input[_builtins.str] config_rule_trigger_types: The trigger type of the rule. Valid values: `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.str] exclude_resource_ids_scope: The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] input_parameters: The settings map of the input parameters for the rule.
        :param pulumi.Input[_builtins.str] maximum_execution_frequency: The frequency of the compliance evaluations. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`. System default value is `TwentyFour_Hours` and valid when the `config_rule_trigger_types` is `ScheduledNotification`.
        :param pulumi.Input[_builtins.str] region_ids_scope: The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[_builtins.str] resource_group_ids_scope: The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types_scopes: Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config.](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
        :param pulumi.Input[_builtins.int] risk_level: The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info.
        :param pulumi.Input[_builtins.str] source_identifier: The identifier of the rule. For a managed rule, the value is the identifier of the managed rule. For a custom rule, the value is the ARN of the custom rule. Using managed rules, refer to [List of Managed rules.](https://www.alibabacloud.com/help/en/doc-detail/127404.htm)
        :param pulumi.Input[_builtins.str] source_owner: Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values: `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule.
        :param pulumi.Input[_builtins.str] status: The rule status. The valid values: `ACTIVE`, `INACTIVE`.
        :param pulumi.Input[_builtins.str] tag_key_scope: The rule monitors the tag key, only applies to rules created based on managed rules.
        :param pulumi.Input[_builtins.str] tag_value_scope: The rule monitors the tag value, use with the `tag_key_scope` options. only applies to rules created based on managed rules.
        """
        if aggregate_config_rule_name is not None:
            pulumi.set(__self__, "aggregate_config_rule_name", aggregate_config_rule_name)
        if aggregator_id is not None:
            pulumi.set(__self__, "aggregator_id", aggregator_id)
        if config_rule_id is not None:
            pulumi.set(__self__, "config_rule_id", config_rule_id)
        if config_rule_trigger_types is not None:
            pulumi.set(__self__, "config_rule_trigger_types", config_rule_trigger_types)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_resource_ids_scope is not None:
            pulumi.set(__self__, "exclude_resource_ids_scope", exclude_resource_ids_scope)
        if input_parameters is not None:
            pulumi.set(__self__, "input_parameters", input_parameters)
        if maximum_execution_frequency is not None:
            pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        if region_ids_scope is not None:
            pulumi.set(__self__, "region_ids_scope", region_ids_scope)
        if resource_group_ids_scope is not None:
            pulumi.set(__self__, "resource_group_ids_scope", resource_group_ids_scope)
        if resource_types_scopes is not None:
            pulumi.set(__self__, "resource_types_scopes", resource_types_scopes)
        if risk_level is not None:
            pulumi.set(__self__, "risk_level", risk_level)
        if source_identifier is not None:
            pulumi.set(__self__, "source_identifier", source_identifier)
        if source_owner is not None:
            pulumi.set(__self__, "source_owner", source_owner)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag_key_scope is not None:
            pulumi.set(__self__, "tag_key_scope", tag_key_scope)
        if tag_value_scope is not None:
            pulumi.set(__self__, "tag_value_scope", tag_value_scope)

    @_builtins.property
    @pulumi.getter(name="aggregateConfigRuleName")
    def aggregate_config_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "aggregate_config_rule_name")

    @aggregate_config_rule_name.setter
    def aggregate_config_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregate_config_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="aggregatorId")
    def aggregator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Aggregator Id.
        """
        return pulumi.get(self, "aggregator_id")

    @aggregator_id.setter
    def aggregator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregator_id", value)

    @_builtins.property
    @pulumi.getter(name="configRuleId")
    def config_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.141.0) The rule ID of Aggregate Config Rule.
        """
        return pulumi.get(self, "config_rule_id")

    @config_rule_id.setter
    def config_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_rule_id", value)

    @_builtins.property
    @pulumi.getter(name="configRuleTriggerTypes")
    def config_rule_trigger_types(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The trigger type of the rule. Valid values: `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        """
        return pulumi.get(self, "config_rule_trigger_types")

    @config_rule_trigger_types.setter
    def config_rule_trigger_types(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_rule_trigger_types", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="excludeResourceIdsScope")
    def exclude_resource_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        """
        return pulumi.get(self, "exclude_resource_ids_scope")

    @exclude_resource_ids_scope.setter
    def exclude_resource_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_resource_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The settings map of the input parameters for the rule.
        """
        return pulumi.get(self, "input_parameters")

    @input_parameters.setter
    def input_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "input_parameters", value)

    @_builtins.property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The frequency of the compliance evaluations. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`. System default value is `TwentyFour_Hours` and valid when the `config_rule_trigger_types` is `ScheduledNotification`.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @maximum_execution_frequency.setter
    def maximum_execution_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maximum_execution_frequency", value)

    @_builtins.property
    @pulumi.getter(name="regionIdsScope")
    def region_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "region_ids_scope")

    @region_ids_scope.setter
    def region_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupIdsScope")
    def resource_group_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "resource_group_ids_scope")

    @resource_group_ids_scope.setter
    def resource_group_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypesScopes")
    def resource_types_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config.](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
        """
        return pulumi.get(self, "resource_types_scopes")

    @resource_types_scopes.setter
    def resource_types_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_types_scopes", value)

    @_builtins.property
    @pulumi.getter(name="riskLevel")
    def risk_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info.
        """
        return pulumi.get(self, "risk_level")

    @risk_level.setter
    def risk_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "risk_level", value)

    @_builtins.property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the rule. For a managed rule, the value is the identifier of the managed rule. For a custom rule, the value is the ARN of the custom rule. Using managed rules, refer to [List of Managed rules.](https://www.alibabacloud.com/help/en/doc-detail/127404.htm)
        """
        return pulumi.get(self, "source_identifier")

    @source_identifier.setter
    def source_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_identifier", value)

    @_builtins.property
    @pulumi.getter(name="sourceOwner")
    def source_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values: `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule.
        """
        return pulumi.get(self, "source_owner")

    @source_owner.setter
    def source_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_owner", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule status. The valid values: `ACTIVE`, `INACTIVE`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tagKeyScope")
    def tag_key_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule monitors the tag key, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "tag_key_scope")

    @tag_key_scope.setter
    def tag_key_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_key_scope", value)

    @_builtins.property
    @pulumi.getter(name="tagValueScope")
    def tag_value_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule monitors the tag value, use with the `tag_key_scope` options. only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "tag_value_scope")

    @tag_value_scope.setter
    def tag_value_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_value_scope", value)


@pulumi.type_token("alicloud:cfg/aggregateConfigRule:AggregateConfigRule")
class AggregateConfigRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregate_config_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_rule_trigger_types: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 input_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 risk_level: Optional[pulumi.Input[_builtins.int]] = None,
                 source_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 source_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_key_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Config Aggregate Config Rule resource.

        For information about Cloud Config Aggregate Config Rule and how to use it, see [What is Aggregate Config Rule](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createaggregateconfigrule).

        > **NOTE:** Available since v1.124.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_accounts(status="CreateSuccess")
        last = len(default.accounts).apply(lambda length: length - 1)
        default_aggregator = alicloud.cfg.Aggregator("default",
            aggregator_accounts=[{
                "account_id": default.accounts[last].account_id,
                "account_name": default.accounts[last].display_name,
                "account_type": "ResourceDirectory",
            }],
            aggregator_name=name,
            description=name,
            aggregator_type="CUSTOM")
        default_aggregate_config_rule = alicloud.cfg.AggregateConfigRule("default",
            aggregate_config_rule_name="contains-tag",
            aggregator_id=default_aggregator.id,
            config_rule_trigger_types="ConfigurationItemChangeNotification",
            source_owner="ALIYUN",
            source_identifier="contains-tag",
            risk_level=1,
            resource_types_scopes=["ACS::ECS::Instance"],
            input_parameters={
                "key": "example",
                "value": "example",
            })
        ```

        ## Import

        Cloud Config Aggregate Config Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cfg/aggregateConfigRule:AggregateConfigRule example "<aggregator_id>:<config_rule_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aggregate_config_rule_name: The name of the rule.
        :param pulumi.Input[_builtins.str] aggregator_id: The Aggregator Id.
        :param pulumi.Input[_builtins.str] config_rule_trigger_types: The trigger type of the rule. Valid values: `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.str] exclude_resource_ids_scope: The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] input_parameters: The settings map of the input parameters for the rule.
        :param pulumi.Input[_builtins.str] maximum_execution_frequency: The frequency of the compliance evaluations. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`. System default value is `TwentyFour_Hours` and valid when the `config_rule_trigger_types` is `ScheduledNotification`.
        :param pulumi.Input[_builtins.str] region_ids_scope: The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[_builtins.str] resource_group_ids_scope: The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types_scopes: Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config.](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
        :param pulumi.Input[_builtins.int] risk_level: The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info.
        :param pulumi.Input[_builtins.str] source_identifier: The identifier of the rule. For a managed rule, the value is the identifier of the managed rule. For a custom rule, the value is the ARN of the custom rule. Using managed rules, refer to [List of Managed rules.](https://www.alibabacloud.com/help/en/doc-detail/127404.htm)
        :param pulumi.Input[_builtins.str] source_owner: Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values: `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule.
        :param pulumi.Input[_builtins.str] status: The rule status. The valid values: `ACTIVE`, `INACTIVE`.
        :param pulumi.Input[_builtins.str] tag_key_scope: The rule monitors the tag key, only applies to rules created based on managed rules.
        :param pulumi.Input[_builtins.str] tag_value_scope: The rule monitors the tag value, use with the `tag_key_scope` options. only applies to rules created based on managed rules.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AggregateConfigRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Config Aggregate Config Rule resource.

        For information about Cloud Config Aggregate Config Rule and how to use it, see [What is Aggregate Config Rule](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createaggregateconfigrule).

        > **NOTE:** Available since v1.124.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_accounts(status="CreateSuccess")
        last = len(default.accounts).apply(lambda length: length - 1)
        default_aggregator = alicloud.cfg.Aggregator("default",
            aggregator_accounts=[{
                "account_id": default.accounts[last].account_id,
                "account_name": default.accounts[last].display_name,
                "account_type": "ResourceDirectory",
            }],
            aggregator_name=name,
            description=name,
            aggregator_type="CUSTOM")
        default_aggregate_config_rule = alicloud.cfg.AggregateConfigRule("default",
            aggregate_config_rule_name="contains-tag",
            aggregator_id=default_aggregator.id,
            config_rule_trigger_types="ConfigurationItemChangeNotification",
            source_owner="ALIYUN",
            source_identifier="contains-tag",
            risk_level=1,
            resource_types_scopes=["ACS::ECS::Instance"],
            input_parameters={
                "key": "example",
                "value": "example",
            })
        ```

        ## Import

        Cloud Config Aggregate Config Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cfg/aggregateConfigRule:AggregateConfigRule example "<aggregator_id>:<config_rule_id>"
        ```

        :param str resource_name: The name of the resource.
        :param AggregateConfigRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AggregateConfigRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregate_config_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_rule_trigger_types: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 input_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 risk_level: Optional[pulumi.Input[_builtins.int]] = None,
                 source_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 source_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_key_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AggregateConfigRuleArgs.__new__(AggregateConfigRuleArgs)

            if aggregate_config_rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'aggregate_config_rule_name'")
            __props__.__dict__["aggregate_config_rule_name"] = aggregate_config_rule_name
            if aggregator_id is None and not opts.urn:
                raise TypeError("Missing required property 'aggregator_id'")
            __props__.__dict__["aggregator_id"] = aggregator_id
            if config_rule_trigger_types is None and not opts.urn:
                raise TypeError("Missing required property 'config_rule_trigger_types'")
            __props__.__dict__["config_rule_trigger_types"] = config_rule_trigger_types
            __props__.__dict__["description"] = description
            __props__.__dict__["exclude_resource_ids_scope"] = exclude_resource_ids_scope
            __props__.__dict__["input_parameters"] = input_parameters
            __props__.__dict__["maximum_execution_frequency"] = maximum_execution_frequency
            __props__.__dict__["region_ids_scope"] = region_ids_scope
            __props__.__dict__["resource_group_ids_scope"] = resource_group_ids_scope
            if resource_types_scopes is None and not opts.urn:
                raise TypeError("Missing required property 'resource_types_scopes'")
            __props__.__dict__["resource_types_scopes"] = resource_types_scopes
            if risk_level is None and not opts.urn:
                raise TypeError("Missing required property 'risk_level'")
            __props__.__dict__["risk_level"] = risk_level
            if source_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'source_identifier'")
            __props__.__dict__["source_identifier"] = source_identifier
            if source_owner is None and not opts.urn:
                raise TypeError("Missing required property 'source_owner'")
            __props__.__dict__["source_owner"] = source_owner
            __props__.__dict__["status"] = status
            __props__.__dict__["tag_key_scope"] = tag_key_scope
            __props__.__dict__["tag_value_scope"] = tag_value_scope
            __props__.__dict__["config_rule_id"] = None
        super(AggregateConfigRule, __self__).__init__(
            'alicloud:cfg/aggregateConfigRule:AggregateConfigRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregate_config_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            aggregator_id: Optional[pulumi.Input[_builtins.str]] = None,
            config_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            config_rule_trigger_types: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
            input_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            maximum_execution_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
            resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            risk_level: Optional[pulumi.Input[_builtins.int]] = None,
            source_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            source_owner: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tag_key_scope: Optional[pulumi.Input[_builtins.str]] = None,
            tag_value_scope: Optional[pulumi.Input[_builtins.str]] = None) -> 'AggregateConfigRule':
        """
        Get an existing AggregateConfigRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aggregate_config_rule_name: The name of the rule.
        :param pulumi.Input[_builtins.str] aggregator_id: The Aggregator Id.
        :param pulumi.Input[_builtins.str] config_rule_id: (Available since v1.141.0) The rule ID of Aggregate Config Rule.
        :param pulumi.Input[_builtins.str] config_rule_trigger_types: The trigger type of the rule. Valid values: `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.str] exclude_resource_ids_scope: The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] input_parameters: The settings map of the input parameters for the rule.
        :param pulumi.Input[_builtins.str] maximum_execution_frequency: The frequency of the compliance evaluations. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`. System default value is `TwentyFour_Hours` and valid when the `config_rule_trigger_types` is `ScheduledNotification`.
        :param pulumi.Input[_builtins.str] region_ids_scope: The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[_builtins.str] resource_group_ids_scope: The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types_scopes: Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config.](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
        :param pulumi.Input[_builtins.int] risk_level: The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info.
        :param pulumi.Input[_builtins.str] source_identifier: The identifier of the rule. For a managed rule, the value is the identifier of the managed rule. For a custom rule, the value is the ARN of the custom rule. Using managed rules, refer to [List of Managed rules.](https://www.alibabacloud.com/help/en/doc-detail/127404.htm)
        :param pulumi.Input[_builtins.str] source_owner: Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values: `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule.
        :param pulumi.Input[_builtins.str] status: The rule status. The valid values: `ACTIVE`, `INACTIVE`.
        :param pulumi.Input[_builtins.str] tag_key_scope: The rule monitors the tag key, only applies to rules created based on managed rules.
        :param pulumi.Input[_builtins.str] tag_value_scope: The rule monitors the tag value, use with the `tag_key_scope` options. only applies to rules created based on managed rules.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AggregateConfigRuleState.__new__(_AggregateConfigRuleState)

        __props__.__dict__["aggregate_config_rule_name"] = aggregate_config_rule_name
        __props__.__dict__["aggregator_id"] = aggregator_id
        __props__.__dict__["config_rule_id"] = config_rule_id
        __props__.__dict__["config_rule_trigger_types"] = config_rule_trigger_types
        __props__.__dict__["description"] = description
        __props__.__dict__["exclude_resource_ids_scope"] = exclude_resource_ids_scope
        __props__.__dict__["input_parameters"] = input_parameters
        __props__.__dict__["maximum_execution_frequency"] = maximum_execution_frequency
        __props__.__dict__["region_ids_scope"] = region_ids_scope
        __props__.__dict__["resource_group_ids_scope"] = resource_group_ids_scope
        __props__.__dict__["resource_types_scopes"] = resource_types_scopes
        __props__.__dict__["risk_level"] = risk_level
        __props__.__dict__["source_identifier"] = source_identifier
        __props__.__dict__["source_owner"] = source_owner
        __props__.__dict__["status"] = status
        __props__.__dict__["tag_key_scope"] = tag_key_scope
        __props__.__dict__["tag_value_scope"] = tag_value_scope
        return AggregateConfigRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aggregateConfigRuleName")
    def aggregate_config_rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "aggregate_config_rule_name")

    @_builtins.property
    @pulumi.getter(name="aggregatorId")
    def aggregator_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Aggregator Id.
        """
        return pulumi.get(self, "aggregator_id")

    @_builtins.property
    @pulumi.getter(name="configRuleId")
    def config_rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.141.0) The rule ID of Aggregate Config Rule.
        """
        return pulumi.get(self, "config_rule_id")

    @_builtins.property
    @pulumi.getter(name="configRuleTriggerTypes")
    def config_rule_trigger_types(self) -> pulumi.Output[_builtins.str]:
        """
        The trigger type of the rule. Valid values: `ConfigurationItemChangeNotification`: The rule is triggered upon configuration changes. `ScheduledNotification`: The rule is triggered as scheduled.
        """
        return pulumi.get(self, "config_rule_trigger_types")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="excludeResourceIdsScope")
    def exclude_resource_ids_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rule monitors excluded resource IDs, multiple of which are separated by commas, only applies to rules created based on managed rules, , custom rule this field is empty.
        """
        return pulumi.get(self, "exclude_resource_ids_scope")

    @_builtins.property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The settings map of the input parameters for the rule.
        """
        return pulumi.get(self, "input_parameters")

    @_builtins.property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> pulumi.Output[_builtins.str]:
        """
        The frequency of the compliance evaluations. Valid values:  `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, `TwentyFour_Hours`. System default value is `TwentyFour_Hours` and valid when the `config_rule_trigger_types` is `ScheduledNotification`.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @_builtins.property
    @pulumi.getter(name="regionIdsScope")
    def region_ids_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rule monitors region IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "region_ids_scope")

    @_builtins.property
    @pulumi.getter(name="resourceGroupIdsScope")
    def resource_group_ids_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rule monitors resource group IDs, separated by commas, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "resource_group_ids_scope")

    @_builtins.property
    @pulumi.getter(name="resourceTypesScopes")
    def resource_types_scopes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Resource types to be evaluated. [Alibaba Cloud services that support Cloud Config.](https://www.alibabacloud.com/help/en/doc-detail/127411.htm)
        """
        return pulumi.get(self, "resource_types_scopes")

    @_builtins.property
    @pulumi.getter(name="riskLevel")
    def risk_level(self) -> pulumi.Output[_builtins.int]:
        """
        The risk level of the resources that are not compliant with the rule. Valid values:  `1`: critical `2`: warning `3`: info.
        """
        return pulumi.get(self, "risk_level")

    @_builtins.property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the rule. For a managed rule, the value is the identifier of the managed rule. For a custom rule, the value is the ARN of the custom rule. Using managed rules, refer to [List of Managed rules.](https://www.alibabacloud.com/help/en/doc-detail/127404.htm)
        """
        return pulumi.get(self, "source_identifier")

    @_builtins.property
    @pulumi.getter(name="sourceOwner")
    def source_owner(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether you or Alibaba Cloud owns and manages the rule. Valid values: `CUSTOM_FC`: The rule is a custom rule and you own the rule. `ALIYUN`: The rule is a managed rule and Alibaba Cloud owns the rule.
        """
        return pulumi.get(self, "source_owner")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The rule status. The valid values: `ACTIVE`, `INACTIVE`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tagKeyScope")
    def tag_key_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rule monitors the tag key, only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "tag_key_scope")

    @_builtins.property
    @pulumi.getter(name="tagValueScope")
    def tag_value_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rule monitors the tag value, use with the `tag_key_scope` options. only applies to rules created based on managed rules.
        """
        return pulumi.get(self, "tag_value_scope")

